/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal.services;

import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import com.ibm.ims.datatools.connectivity.internal.services.ResourceLocatorDelegate;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

class BundleResourceLocator
extends ResourceLocatorDelegate {
    BundleResourceLocator() {
    }

    @Override
    URL findPluginEntry(String pluginId, String path, ClassLoader cl) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        URL entryURL = bundle.getEntry(path);
        if (entryURL == null) {
            return null;
        }
        try {
            return this.resolveURL(entryURL);
        }
        catch (IOException e) {
            ConnectivityPlugin.getDefault().log(e);
            return null;
        }
    }

    @Override
    URL findPluginResource(String pluginId, String name, ClassLoader cl) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        return bundle != null ? bundle.getResource(name) : null;
    }

    @Override
    String findResourceString(String pluginId, String value) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        return bundle != null ? Platform.getResourceString((Bundle)bundle, (String)value) : null;
    }

    @Override
    IPath findPluginStateLocation(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        return stateLocation;
    }

    @Override
    URL resolveURL(URL url) throws IOException {
        return FileLocator.resolve((URL)url);
    }

    @Override
    URL toFileURL(URL url) throws IOException {
        return FileLocator.toFileURL((URL)url);
    }
}

