/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal;

import java.security.SecureRandom;
import java.util.GregorianCalendar;

public class UUID {
    private static int sClockSequence;
    private static byte[] sNodeID;
    private static long sLastTime;
    private static int sNum100nsTicks;
    private static long sEpochOffset;
    private static char[] sHexChars;
    private static char sSeparator;
    private byte[] mBytes = new byte[16];

    static {
        sHexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        sSeparator = (char)45;
        SecureRandom rng = new SecureRandom();
        sClockSequence = (short)rng.nextInt(16383);
        sNodeID = new byte[6];
        rng.nextBytes(sNodeID);
        sNodeID[0] = (byte)(sNodeID[0] | 0x80);
        sLastTime = System.currentTimeMillis();
        sNum100nsTicks = 0;
        sEpochOffset = new GregorianCalendar(1970, 0, 1, 0, 0, 0).getTime().getTime() - new GregorianCalendar(1582, 9, 15, 0, 0, 0).getTime().getTime();
    }

    public static UUID createUUID() {
        return new UUID();
    }

    private UUID() {
        long currentTime = UUID.getCurrentTime();
        int i = 3;
        while (i > -1) {
            this.mBytes[3 - i] = (byte)((currentTime & 255L << i * 8) >> i * 8);
            --i;
        }
        i = 5;
        while (i > 3) {
            this.mBytes[9 - i] = (byte)((currentTime & 255L << i * 8) >> i * 8);
            --i;
        }
        i = 7;
        while (i > 5) {
            this.mBytes[13 - i] = (byte)((currentTime & 255L << i * 8) >> i * 8);
            --i;
        }
        this.mBytes[6] = (byte)(this.mBytes[6] & 0xF);
        this.mBytes[6] = (byte)(this.mBytes[6] | 0x10);
        this.mBytes[8] = (byte)((sClockSequence & 0xBF00) >> 8);
        this.mBytes[8] = (byte)(this.mBytes[8] | 0x80);
        this.mBytes[9] = (byte)(sClockSequence & 0xFF);
        System.arraycopy(sNodeID, 0, this.mBytes, 10, 6);
    }

    public long getMostSigBytes() {
        long msb = 0L;
        int i = 0;
        while (i < 8) {
            msb |= (long)this.mBytes[i] << 56 >>> 8 * i;
            ++i;
        }
        return msb;
    }

    public long getLeastSigBytes() {
        long lsb = 0L;
        int i = 8;
        while (i < 16) {
            lsb |= (long)this.mBytes[i] << 56 >>> 8 * (i - 8);
            ++i;
        }
        return lsb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 4) {
            sb.append(sHexChars[(this.mBytes[i] & 0xF0) >> 4]);
            sb.append(sHexChars[this.mBytes[i] & 0xF]);
            ++i;
        }
        sb.append(sSeparator);
        i = 4;
        while (i < 6) {
            sb.append(sHexChars[(this.mBytes[i] & 0xF0) >> 4]);
            sb.append(sHexChars[this.mBytes[i] & 0xF]);
            ++i;
        }
        sb.append(sSeparator);
        i = 6;
        while (i < 8) {
            sb.append(sHexChars[(this.mBytes[i] & 0xF0) >> 4]);
            sb.append(sHexChars[this.mBytes[i] & 0xF]);
            ++i;
        }
        sb.append(sSeparator);
        i = 8;
        while (i < 10) {
            sb.append(sHexChars[(this.mBytes[i] & 0xF0) >> 4]);
            sb.append(sHexChars[this.mBytes[i] & 0xF]);
            ++i;
        }
        sb.append(sSeparator);
        i = 10;
        while (i < 16) {
            sb.append(sHexChars[(this.mBytes[i] & 0xF0) >> 4]);
            sb.append(sHexChars[this.mBytes[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    private static synchronized long getCurrentTime() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < sLastTime) {
            if (++sClockSequence > 16383) {
                sClockSequence = 0;
            }
            sNum100nsTicks = 0;
        } else if (currentTime == sLastTime) {
            if (++sNum100nsTicks >= 10000) {
                currentTime = System.currentTimeMillis();
                while (currentTime == sLastTime) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                    currentTime = System.currentTimeMillis();
                }
                sNum100nsTicks = 0;
            }
        } else {
            sNum100nsTicks = 0;
        }
        sLastTime = currentTime;
        currentTime += sEpochOffset;
        currentTime *= 10000L;
        return currentTime += (long)sNum100nsTicks;
    }
}

