/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal;

import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.IPropertySetChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class PropertySetChangeEvent
implements IPropertySetChangeEvent {
    private IConnectionProfile mConnectionProfile;
    private String mPropertiesType;
    private Map mChangedProperties;

    private PropertySetChangeEvent(IConnectionProfile profile, String propertiesType) {
        this.mConnectionProfile = profile;
        this.mPropertiesType = propertiesType;
    }

    public PropertySetChangeEvent(IConnectionProfile profile, String propertiesType, String property, String oldValue, String newValue) {
        this(profile, propertiesType);
        this.mChangedProperties = new HashMap(1);
        this.mChangedProperties.put(property, new ChangedProperty(property, oldValue, newValue));
    }

    public PropertySetChangeEvent(IConnectionProfile profile, String propertiesType, Properties oldProperties, Properties newProperties) {
        this(profile, propertiesType);
        HashSet<Object> keys = new HashSet<Object>(newProperties.keySet());
        keys.addAll(oldProperties.keySet());
        this.mChangedProperties = new HashMap(keys.size());
        for (String string : keys) {
            String oldValue = oldProperties.getProperty(string);
            String newValue = newProperties.getProperty(string);
            if ((oldValue != null || newValue == null) && (oldValue == null || oldValue.equals(newValue))) continue;
            this.mChangedProperties.put(string, new ChangedProperty(string, oldValue, newValue));
        }
        this.mChangedProperties = Collections.unmodifiableMap(this.mChangedProperties);
    }

    @Override
    public Map getChangedProperties() {
        return this.mChangedProperties;
    }

    @Override
    public IPropertySetChangeEvent.IChangedProperty getChangedProperty(String key) {
        if (this.mChangedProperties.containsKey(key)) {
            return (IPropertySetChangeEvent.IChangedProperty)this.mChangedProperties.get(key);
        }
        return null;
    }

    @Override
    public IConnectionProfile getConnectionProfile() {
        return this.mConnectionProfile;
    }

    @Override
    public String getPropertySetType() {
        return this.mPropertiesType;
    }

    private static class ChangedProperty
    implements IPropertySetChangeEvent.IChangedProperty {
        private String mKey;
        private String mNewValue;
        private String mOldValue;

        private ChangedProperty(String key, String oldValue, String newValue) {
            this.mKey = key;
            this.mNewValue = newValue;
            this.mOldValue = oldValue;
        }

        @Override
        public String getNewValue() {
            return this.mNewValue;
        }

        @Override
        public String getOldValue() {
            return this.mOldValue;
        }

        @Override
        public String getID() {
            return this.mKey;
        }
    }
}

