/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal;

import com.ibm.ims.datatools.connectivity.ConnectEvent;
import com.ibm.ims.datatools.connectivity.IConnection;
import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.IManagedConnection;
import com.ibm.ims.datatools.connectivity.IManagedConnectionListener;
import com.ibm.ims.datatools.connectivity.IManagedConnectionOfflineListener;
import com.ibm.ims.datatools.connectivity.IOfflineConnection;
import com.ibm.ims.datatools.connectivity.IServerVersionProvider;
import com.ibm.ims.datatools.connectivity.Version;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import com.ibm.ims.datatools.connectivity.internal.InternalConnectionFactoryProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;

public class ManagedConnection
implements IManagedConnection {
    private IConnectionProfile mProfile;
    private IConnection mConnection;
    private String mFactoryID;
    private Set mListeners = new HashSet();

    public ManagedConnection(IConnectionProfile profile, String factoryID) {
        this.mProfile = profile;
        this.mFactoryID = factoryID;
    }

    @Override
    public void addConnectionListener(IManagedConnectionListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeConnectionListener(IManagedConnectionListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void fireModifiedEvent(Object context) {
        if (!this.isConnected()) {
            return;
        }
        ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this, context);
        Iterator it = new ArrayList(this.mListeners).iterator();
        while (it.hasNext()) {
            try {
                ((IManagedConnectionListener)it.next()).modified(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    @Override
    public IConnection cloneConnection() {
        if (!this.isConnected()) {
            throw new IllegalStateException();
        }
        CloneConnectionJob connectJob = new CloneConnectionJob();
        connectJob.schedule();
        try {
            connectJob.join();
        }
        catch (InterruptedException interruptedException) {}
        return connectJob.getConnection();
    }

    @Override
    public void cloneConnection(IJobChangeListener listener) {
        if (!this.isConnected()) {
            throw new IllegalStateException();
        }
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        CloneConnectionJob connectJob = new CloneConnectionJob();
        connectJob.addJobChangeListener(listener);
        connectJob.schedule();
    }

    @Override
    public String getFactoryID() {
        return this.mFactoryID;
    }

    @Override
    public boolean isConnected() {
        return this.mConnection != null && this.mConnection.getConnectException() == null;
    }

    @Override
    public IConnection getConnection() {
        if (this.mConnection == null) {
            return null;
        }
        if (this.mConnection instanceof IServerVersionProvider) {
            return new RestrictedVersionProviderConnection();
        }
        return new RestrictedConnection();
    }

    public IConnectionProfile getConnectionProfile() {
        return this.mProfile;
    }

    @Override
    public boolean isWorkingOffline() {
        return this.isConnected() && this.mConnection instanceof IOfflineConnection && ((IOfflineConnection)this.mConnection).isWorkingOffline();
    }

    InternalConnectionFactoryProvider getConnectionFactoryProvider() {
        return (InternalConnectionFactoryProvider)this.getConnectionProfile().getProvider().getConnectionFactory(this.getFactoryID());
    }

    boolean supportsWorkOfflineMode() {
        return this.getConnectionFactoryProvider().supportsWorkOfflineMode();
    }

    boolean canWorkOffline() {
        return this.supportsWorkOfflineMode() && (this.isConnected() || this.getConnectionFactoryProvider().canWorkOffline(this.mProfile));
    }

    void createConnection(IProgressMonitor monitor) throws CoreException {
        ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this);
        if (this.isWorkingOffline()) {
            for (IManagedConnectionListener listener : new ArrayList(this.mListeners)) {
                if (!(listener instanceof IManagedConnectionOfflineListener)) continue;
                try {
                    ((IManagedConnectionOfflineListener)listener).aboutToAttach(event);
                }
                catch (Exception e) {
                    ConnectivityPlugin.getDefault().log(e);
                }
            }
            ((IOfflineConnection)this.mConnection).attach(monitor);
        } else {
            this.mConnection = this.supportsWorkOfflineMode() ? this.getConnectionFactoryProvider().createConnection(this.mProfile, monitor) : this.getConnectionProfile().createConnection(this.mFactoryID);
        }
        Iterator it = new ArrayList(this.mListeners).iterator();
        while (it.hasNext()) {
            try {
                ((IManagedConnectionListener)it.next()).opened(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        monitor.done();
    }

    void workOffline(IProgressMonitor monitor) throws CoreException {
        if (!this.supportsWorkOfflineMode()) {
            Status status = new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("ManagedConnection_offline_not_supported_error", new Object[]{this.getConnectionFactoryProvider().getName()}), null);
            throw new CoreException((IStatus)status);
        }
        ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this);
        if (this.isConnected()) {
            for (IManagedConnectionListener listener : new ArrayList(this.mListeners)) {
                if (!(listener instanceof IManagedConnectionOfflineListener)) continue;
                try {
                    ((IManagedConnectionOfflineListener)listener).aboutToDetach(event);
                }
                catch (Exception e) {
                    ConnectivityPlugin.getDefault().log(e);
                }
            }
            ((IOfflineConnection)this.mConnection).detach(monitor);
        } else {
            this.mConnection = this.getConnectionFactoryProvider().createOfflineConnection(this.getConnectionProfile(), monitor);
        }
        for (IManagedConnectionListener listener : new ArrayList(this.mListeners)) {
            if (!(listener instanceof IManagedConnectionOfflineListener)) continue;
            try {
                ((IManagedConnectionOfflineListener)listener).workingOffline(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        monitor.done();
    }

    void save(IProgressMonitor monitor) throws CoreException {
        if (!this.supportsWorkOfflineMode()) {
            Status status = new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("ManagedConnection_offline_not_supported_error", new Object[]{this.getConnectionFactoryProvider().getName()}), null);
            throw new CoreException((IStatus)status);
        }
        if (!this.isConnected()) {
            Status status = new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("ManagedConnection_save_not_connected_error"), null);
            throw new CoreException((IStatus)status);
        }
        ((IOfflineConnection)this.mConnection).save(monitor);
        monitor.done();
    }

    boolean okToClose() {
        boolean okToClose = true;
        if (this.mConnection == null || this.mConnection.getConnectException() != null) {
            return okToClose;
        }
        ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this);
        Iterator it = new ArrayList(this.mListeners).iterator();
        while (okToClose && it.hasNext()) {
            try {
                okToClose = ((IManagedConnectionListener)it.next()).okToClose(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return okToClose;
    }

    boolean okToDetach() {
        if (!this.canWorkOffline()) {
            return this.okToClose();
        }
        boolean okToDetach = true;
        ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this);
        Iterator it = new ArrayList(this.mListeners).iterator();
        while (okToDetach && it.hasNext()) {
            IManagedConnectionListener listener = (IManagedConnectionListener)it.next();
            if (!(listener instanceof IManagedConnectionOfflineListener)) continue;
            try {
                okToDetach = ((IManagedConnectionOfflineListener)listener).okToDetach(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return okToDetach;
    }

    void close() {
        if (this.mConnection == null) {
            return;
        }
        if (this.mConnection.getConnectException() != null) {
            this.mConnection.close();
            this.mConnection = null;
            return;
        }
        ConnectEvent event = new ConnectEvent(this.getConnectionProfile(), this);
        Iterator it = new ArrayList(this.mListeners).iterator();
        while (it.hasNext()) {
            try {
                ((IManagedConnectionListener)it.next()).aboutToClose(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        this.mConnection.close();
        this.mConnection = null;
        it = new ArrayList(this.mListeners).iterator();
        while (it.hasNext()) {
            try {
                ((IManagedConnectionListener)it.next()).closed(event);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    void dispose() {
        if (this.isConnected()) {
            try {
                this.close();
            }
            catch (Exception exception) {}
        }
        this.mListeners.clear();
        this.mProfile = null;
    }

    private class CloneConnectionJob
    extends Job
    implements IManagedConnection.ICloneConnectionJob {
        private IConnection mConnection;

        public CloneConnectionJob() {
            super(ConnectivityPlugin.getDefault().getResourceString("CreateConnectionJob.name", new Object[]{ManagedConnection.this.getConnectionFactoryProvider().getName(), ManagedConnection.this.getConnectionProfile().getName()}));
            this.setUser(true);
        }

        @Override
        public IConnection getConnection() {
            return this.mConnection;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            monitor.beginTask(this.getName(), -1);
            try {
                this.mConnection = ManagedConnection.this.isWorkingOffline() ? ManagedConnection.this.getConnectionFactoryProvider().createOfflineConnection(ManagedConnection.this.getConnectionProfile(), monitor) : ManagedConnection.this.getConnectionFactoryProvider().createConnection(ManagedConnection.this.getConnectionProfile());
                if (this.mConnection.getConnectException() != null) {
                    status = new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("CreateConnectionJob.error", new Object[]{ManagedConnection.this.getConnectionFactoryProvider().getName(), ManagedConnection.this.getConnectionProfile().getName(), this.mConnection.getConnectException().getMessage()}), this.mConnection.getConnectException());
                }
            }
            catch (Exception e) {
                status = new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("CreateConnectionJob.error", new Object[]{ManagedConnection.this.getConnectionFactoryProvider().getName(), ManagedConnection.this.getConnectionProfile().getName(), e.getMessage()}), (Throwable)e);
            }
            monitor.done();
            return status;
        }
    }

    private class RestrictedConnection
    implements IConnection {
        private RestrictedConnection() {
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Throwable getConnectException() {
            return ManagedConnection.this.mConnection.getConnectException();
        }

        @Override
        public IConnectionProfile getConnectionProfile() {
            return ManagedConnection.this.mConnection.getConnectionProfile();
        }

        @Override
        public Object getRawConnection() {
            return ManagedConnection.this.mConnection.getRawConnection();
        }
    }

    private class RestrictedVersionProviderConnection
    extends RestrictedConnection
    implements IServerVersionProvider {
        private RestrictedVersionProviderConnection() {
        }

        @Override
        public String getProviderName() {
            return ((IServerVersionProvider)((Object)ManagedConnection.this.mConnection)).getProviderName();
        }

        @Override
        public Version getProviderVersion() {
            return ((IServerVersionProvider)((Object)ManagedConnection.this.mConnection)).getProviderVersion();
        }

        @Override
        public String getTechnologyName() {
            return ((IServerVersionProvider)((Object)ManagedConnection.this.mConnection)).getTechnologyName();
        }

        @Override
        public Version getTechnologyVersion() {
            return ((IServerVersionProvider)((Object)ManagedConnection.this.mConnection)).getTechnologyVersion();
        }
    }
}

