/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal;

import com.ibm.ims.datatools.connectivity.IConnectionFactoryProvider;
import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import com.ibm.ims.datatools.connectivity.internal.ManagedConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CreateOfflineConnectionJob
extends Job {
    private ManagedConnection mManagedConnection;
    private Object mFamily;

    public CreateOfflineConnectionJob(ManagedConnection managedConnection, Object family) {
        super(ConnectivityPlugin.getDefault().getResourceString("CreateOfflineConnectionJob.name", new Object[]{managedConnection.getConnectionFactoryProvider().getName(), managedConnection.getConnectionProfile().getName()}));
        this.setUser(true);
        this.mManagedConnection = managedConnection;
        this.mFamily = family;
    }

    public ManagedConnection getManagedConnection() {
        return this.mManagedConnection;
    }

    private IConnectionFactoryProvider getConnectionFactoryProvider() {
        return this.mManagedConnection.getConnectionFactoryProvider();
    }

    private IConnectionProfile getConnectionProfile() {
        return this.mManagedConnection.getConnectionProfile();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(this.getName(), -1);
        try {
            if (this.mManagedConnection.canWorkOffline()) {
                this.mManagedConnection.workOffline(monitor);
            } else if (this.mManagedConnection.isConnected()) {
                this.mManagedConnection.close();
            }
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        catch (Exception e) {
            status = new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("CreateOfflineConnectionJob.error", new Object[]{this.getConnectionFactoryProvider().getName(), this.getConnectionProfile().getName(), e.getMessage()}), (Throwable)e);
        }
        monitor.done();
        return status;
    }

    public boolean belongsTo(Object family) {
        return this.mFamily != null && family == this.mFamily;
    }
}

