/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal;

import com.ibm.ims.datatools.connectivity.ConnectionProfileMigratorBase;
import com.ibm.ims.datatools.connectivity.ICategory;
import com.ibm.ims.datatools.connectivity.IConfigurationType;
import com.ibm.ims.datatools.connectivity.IConnectionFactoryProvider;
import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.IConnectionProfileMigrator;
import com.ibm.ims.datatools.connectivity.IConnectionProfileProvider;
import com.ibm.ims.datatools.connectivity.IPropertiesPersistenceHook;
import com.ibm.ims.datatools.connectivity.PropertiesPersistenceHook;
import com.ibm.ims.datatools.connectivity.internal.ConnectionFactoryProvider;
import com.ibm.ims.datatools.connectivity.internal.ConnectionProfileManager;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import com.ibm.ims.datatools.connectivity.internal.InternalProfileManager;
import com.ibm.ims.datatools.connectivity.internal.ProfileExtensionProvider;
import com.ibm.ims.datatools.connectivity.internal.services.PluginResourceLocatorImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ConnectionProfileProvider
implements IConnectionProfileProvider {
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_FILE_EXTENSION = "fileExtension";
    public static final String ATTR_CATEGORY = "category";
    public static final String ATTR_CONFIGURATION_TYPE = "configurationType";
    public static final String ATTR_MAINTAINCONNECTION = "maintainConnection";
    public static final String ATTR_PING_FACTORY = "pingFactory";
    public static final String ATTR_PROPERTIES_PERSISTENCE_HOOK = "propertiesPersistenceHook";
    public static final String ATTR_CLASS = "class";
    public static final String ELEM_MIGRATION = "migration";
    static final IPropertiesPersistenceHook DEFAULT_PROPERTIES_PERSISTENCE_HOOK = new PropertiesPersistenceHook();
    private String mName;
    private String mId;
    private URL mIconURL;
    private String mCategory;
    private String mConfigType;
    private String mFileExt;
    private Map mProfileExtensions;
    private Map mConnectionFactories;
    private IConfigurationElement mElement;
    private boolean mMaintainConnection = true;
    private IPropertiesPersistenceHook mPropertiesPersistenceHook;
    private IConnectionProfileMigrator mMigrator;
    private boolean mMigratorLoaded = false;

    public ConnectionProfileProvider(IConfigurationElement element) {
        this.init(element);
    }

    public ConnectionProfileProvider(String id) {
        this.mName = ConnectivityPlugin.getDefault().getResourceString("NullConnectionProfileProvider.name");
        this.mId = id;
        this.mIconURL = null;
        this.mCategory = "com.ibm.ims.datatools.connectivity.category.unknown";
        this.mConfigType = null;
        this.mFileExt = null;
        this.mProfileExtensions = Collections.EMPTY_MAP;
        this.mConnectionFactories = Collections.EMPTY_MAP;
        this.mElement = null;
        this.mMaintainConnection = false;
        this.mPropertiesPersistenceHook = DEFAULT_PROPERTIES_PERSISTENCE_HOOK;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public URL getIconURL() {
        return this.mIconURL;
    }

    @Override
    public IConnectionFactoryProvider getConnectionFactory(String type) {
        return (IConnectionFactoryProvider)this.mConnectionFactories.get(type);
    }

    @Override
    public Map getConnectionFactories() {
        return new HashMap(this.mConnectionFactories);
    }

    @Override
    public IConfigurationType getConfigurationType() {
        return ConnectionProfileManager.getInstance().getConfigurationType(this.mConfigType);
    }

    @Override
    public ICategory getCategory() {
        return InternalProfileManager.getInstance().getCategory(this.mCategory);
    }

    @Override
    public String getFileExtension() {
        return this.mFileExt;
    }

    @Override
    public Map getProfileExtensions() {
        return new HashMap(this.mProfileExtensions);
    }

    public void addProfileExtension(IConfigurationElement element) {
        ProfileExtensionProvider pe = new ProfileExtensionProvider(element);
        if (this.mProfileExtensions == Collections.EMPTY_MAP) {
            this.mProfileExtensions = new HashMap();
        }
        Assert.isTrue((!this.mProfileExtensions.containsKey(pe.getId()) ? 1 : 0) != 0, (String)ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile", new Object[]{element.toString()}));
        this.mProfileExtensions.put(pe.getId(), pe);
    }

    public void addConnectionFactory(IConfigurationElement element) {
        this.addConnectionFactory(new ConnectionFactoryProvider(element));
    }

    public void addConnectionFactory(IConnectionFactoryProvider icfap) {
        String newFactoryPriority;
        IConnectionFactoryProvider currentFactory;
        String currentFactoryPriority;
        if (this.mConnectionFactories == Collections.EMPTY_MAP) {
            this.mConnectionFactories = new HashMap();
        }
        if (icfap != null && icfap.getId() != null && !this.mConnectionFactories.containsKey(icfap.getId())) {
            this.mConnectionFactories.put(icfap.getId(), icfap);
        } else if (icfap == null || icfap.getId() == null) {
            ConnectivityPlugin.getDefault().log(ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile.nullFactory", new Object[]{icfap.getName(), icfap.getId()}));
        } else if (this.mConnectionFactories.containsKey(icfap.getId()) && this.comparePriority(currentFactoryPriority = (currentFactory = (IConnectionFactoryProvider)this.mConnectionFactories.get(icfap.getId())).getPriority(), newFactoryPriority = icfap.getPriority()) <= 0) {
            if (this.comparePriority(currentFactoryPriority, newFactoryPriority) < 0) {
                this.mConnectionFactories.remove(icfap.getId());
                this.mConnectionFactories.put(icfap.getId(), icfap);
            } else {
                ConnectivityPlugin.getDefault().log(ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile.duplicateFactory", new Object[]{icfap.getId()}));
            }
        }
    }

    private int comparePriority(String priority1, String priority2) {
        int GREATER_THAN = 1;
        int EQUALS = 0;
        int LESS_THAN = -1;
        int result = EQUALS;
        if (priority1 == null && priority2 == null) {
            result = EQUALS;
        } else if (priority1 != null && priority2 == null) {
            result = GREATER_THAN;
        } else if (priority1 == null && priority2 != null) {
            result = LESS_THAN;
        } else if (priority1 != null && priority2 != null) {
            int priority1IntValue = 0;
            int priority2IntValue = 0;
            try {
                priority1IntValue = Integer.parseInt(priority1);
            }
            catch (Exception exception) {}
            try {
                priority2IntValue = Integer.parseInt(priority2);
            }
            catch (Exception exception) {}
            result = priority1IntValue > priority2IntValue ? GREATER_THAN : (priority1IntValue < priority2IntValue ? LESS_THAN : EQUALS);
        }
        return result;
    }

    public IPropertiesPersistenceHook getPropertiesPersistenceHook() {
        this.loadPropertiesPersistenceHook();
        return this.mPropertiesPersistenceHook;
    }

    private void loadPropertiesPersistenceHook() {
        block4: {
            if (this.mPropertiesPersistenceHook == null) {
                this.mPropertiesPersistenceHook = DEFAULT_PROPERTIES_PERSISTENCE_HOOK;
                if (this.mElement != null && this.mElement.getAttribute(ATTR_PROPERTIES_PERSISTENCE_HOOK) != null) {
                    try {
                        this.mPropertiesPersistenceHook = (IPropertiesPersistenceHook)this.mElement.createExecutableExtension(ATTR_PROPERTIES_PERSISTENCE_HOOK);
                    }
                    catch (CoreException e) {
                        if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block4;
                        System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHook", new Object[]{this.mId, this.mId}));
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void init(IConfigurationElement element) {
        Assert.isTrue((boolean)"connectionProfile".equals(element.getName()));
        this.mProfileExtensions = new HashMap();
        this.mConnectionFactories = new HashMap();
        this.mElement = element;
        this.mId = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mFileExt = element.getAttribute(ATTR_FILE_EXTENSION);
        this.mCategory = element.getAttribute(ATTR_CATEGORY);
        this.mConfigType = element.getAttribute(ATTR_CONFIGURATION_TYPE);
        if (element.getAttribute(ATTR_MAINTAINCONNECTION) != null) {
            this.mMaintainConnection = Boolean.valueOf(element.getAttribute(ATTR_MAINTAINCONNECTION));
        }
        if (element.getAttribute(ATTR_PING_FACTORY) != null) {
            ConnectionFactoryProvider cfp = new ConnectionFactoryProvider(element, "com.ibm.ims.datatools.connectivity.connectionFactory.pingFactory", this.getId(), ATTR_PING_FACTORY, null);
            this.mConnectionFactories.put("com.ibm.ims.datatools.connectivity.connectionFactory.pingFactory", cfp);
        }
        this.processIconAttr();
    }

    private void processIconAttr() {
        String iconAttr;
        String string = iconAttr = this.mElement == null ? null : this.mElement.getAttribute(ATTR_ICON);
        if (iconAttr != null && iconAttr.trim().length() > 0) {
            if (iconAttr.startsWith("platform:/")) {
                try {
                    this.mIconURL = new URL(iconAttr);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                this.mIconURL = PluginResourceLocatorImpl.getPluginEntry(this.mElement, iconAttr);
            }
        }
    }

    @Override
    public boolean needsMaintainConnection() {
        return this.mMaintainConnection;
    }

    public IConnectionProfileMigrator getMigrator() {
        this.loadMigrator();
        return this.mMigrator;
    }

    private void loadMigrator() {
        block9: {
            if (!this.mMigratorLoaded) {
                this.mMigratorLoaded = true;
                if (this.mElement == null) {
                    return;
                }
                IConfigurationElement[] migrationElements = this.mElement.getChildren(ELEM_MIGRATION);
                if (migrationElements == null || migrationElements.length == 0) {
                    return;
                }
                String migratorImpl = migrationElements[0].getAttribute(ATTR_CLASS);
                if (migratorImpl != null && migratorImpl.length() > 0) {
                    try {
                        this.mMigrator = (IConnectionProfileMigrator)migrationElements[0].createExecutableExtension(ATTR_CLASS);
                    }
                    catch (CoreException e) {
                        String error = ConnectivityPlugin.getDefault().getResourceString("trace.error.migration", new Object[]{this.mId, migratorImpl});
                        ConnectivityPlugin.getDefault().log(error);
                        if (ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) {
                            System.err.println(error);
                            e.printStackTrace();
                        }
                        break block9;
                    }
                }
                try {
                    ConnectionProfileMigratorBase migrator = new ConnectionProfileMigratorBase();
                    migrator.setInitializationData(migrationElements[0], null, null);
                    this.mMigrator = migrator;
                }
                catch (CoreException e) {
                    String error = ConnectivityPlugin.getDefault().getResourceString("trace.error.migration", new Object[]{this.mId, migratorImpl});
                    ConnectivityPlugin.getDefault().log(error);
                    if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block9;
                    System.err.println(error);
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean compatibleWithRepository(IConnectionProfile repository) {
        return true;
    }
}

