/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal;

import com.ibm.ims.datatools.connectivity.IConnection;
import com.ibm.ims.datatools.connectivity.IConnectionFactory;
import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.IOfflineConnection;
import com.ibm.ims.datatools.connectivity.IOfflineConnectionFactory;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import com.ibm.ims.datatools.connectivity.internal.InternalConnectionFactoryProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

public class ConnectionFactoryAdapterProvider
implements InternalConnectionFactoryProvider {
    public static final String ATTR_FACTORY = "factory";
    public static final String ATTR_ID = "id";
    public static final String ATTR_PROFILE = "profile";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CLASS = "class";
    private String mFactoryId;
    private String mName;
    private String mId;
    private String mProfileOverride;
    private IConnectionFactory mConnectionFactory;
    private IConfigurationElement mElement;

    public ConnectionFactoryAdapterProvider(IConfigurationElement element) {
        this.init(element);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.mElement;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public boolean isDefault() {
        return this.mProfileOverride == null || this.mProfileOverride.length() == 0;
    }

    public String getFactoryId() {
        return this.mFactoryId;
    }

    public String getProfileOverride() {
        return this.mProfileOverride;
    }

    @Override
    public Class getConnectionFactoryClass() {
        this.initFactory();
        if (this.mConnectionFactory == null) {
            return null;
        }
        return this.mConnectionFactory.getClass();
    }

    @Override
    public IConnection createConnection(IConnectionProfile profile) {
        this.initFactory();
        if (this.mConnectionFactory == null) {
            return null;
        }
        if (this.supportsWorkOfflineMode()) {
            return this.createConnection(profile, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.mConnectionFactory.createConnection(profile);
    }

    @Override
    public IConnection createConnection(IConnectionProfile profile, String uid, String pwd) {
        this.initFactory();
        if (this.mConnectionFactory == null) {
            return null;
        }
        return this.mConnectionFactory.createConnection(profile, uid, pwd);
    }

    @Override
    public boolean supportsWorkOfflineMode() {
        this.initFactory();
        return this.mConnectionFactory != null && this.mConnectionFactory instanceof IOfflineConnectionFactory;
    }

    @Override
    public boolean canWorkOffline(IConnectionProfile profile) {
        return this.supportsWorkOfflineMode() && ((IOfflineConnectionFactory)this.mConnectionFactory).canWorkOffline(profile);
    }

    @Override
    public IOfflineConnection createConnection(IConnectionProfile profile, IProgressMonitor monitor) {
        if (this.supportsWorkOfflineMode()) {
            return ((IOfflineConnectionFactory)this.mConnectionFactory).createConnection(profile, monitor);
        }
        return null;
    }

    @Override
    public IOfflineConnection createOfflineConnection(IConnectionProfile profile, IProgressMonitor monitor) {
        if (this.supportsWorkOfflineMode()) {
            return ((IOfflineConnectionFactory)this.mConnectionFactory).createOfflineConnection(profile, monitor);
        }
        return null;
    }

    private void init(IConfigurationElement element) {
        this.mElement = element;
        this.mName = element.getAttribute(ATTR_NAME);
        this.mFactoryId = element.getAttribute(ATTR_FACTORY);
        this.mId = element.getAttribute(ATTR_ID);
        this.mProfileOverride = element.getAttribute(ATTR_PROFILE);
    }

    private void initFactory() {
        if (this.mConnectionFactory != null) {
            return;
        }
        final IConnectionFactory[] result = new IConnectionFactory[1];
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                result[0] = (IConnectionFactory)ConnectionFactoryAdapterProvider.this.mElement.createExecutableExtension(ConnectionFactoryAdapterProvider.ATTR_CLASS);
            }

            public void handleException(Throwable exception) {
                ConnectivityPlugin.getDefault().log((IStatus)new Status(4, ConnectivityPlugin.getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("dialog.title.error.loadconnectionfactory", new Object[]{ConnectionFactoryAdapterProvider.this.mElement.getContributor().getName()}), exception));
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        this.mConnectionFactory = result[0];
    }

    @Override
    public String getPriority() {
        return null;
    }
}

