/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal;

import com.ibm.ims.datatools.connectivity.internal.ConnectionFactoryAdapterProvider;
import com.ibm.ims.datatools.connectivity.internal.ConnectionProfileManager;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import java.util.HashMap;
import java.util.Map;

public class ConnectionFactoryAdapter {
    private ConnectionFactoryAdapterProvider mDefaultFactoryAdapter;
    private Map mFactoryAdapterOverrides;
    private final String mId;
    private final String mFactoryId;

    public ConnectionFactoryAdapter(String id, String factoryId) {
        this.mId = id;
        this.mFactoryId = factoryId;
        this.mFactoryAdapterOverrides = new HashMap();
    }

    public String getId() {
        return this.mId;
    }

    public String getFactoryId() {
        return this.mFactoryId;
    }

    public ConnectionFactoryAdapterProvider getDefault() {
        return this.mDefaultFactoryAdapter;
    }

    public ConnectionFactoryAdapterProvider getOverride(String profileId) {
        if (this.mFactoryAdapterOverrides.containsKey(profileId)) {
            return (ConnectionFactoryAdapterProvider)this.mFactoryAdapterOverrides.get(profileId);
        }
        return null;
    }

    public void addAdapter(ConnectionFactoryAdapterProvider adapter) {
        if (adapter.isDefault()) {
            if (this.mDefaultFactoryAdapter == null) {
                this.mDefaultFactoryAdapter = adapter;
            } else if (ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) {
                System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.multipleDefaultConnectionAdapters", new Object[]{this.mId, this.mFactoryId}));
            }
        } else if (this.mFactoryAdapterOverrides.containsKey(adapter.getProfileOverride())) {
            if (ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) {
                System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.multipleConnectionAdapterOverrides", new Object[]{this.mId, this.mFactoryId, adapter.getProfileOverride()}));
            }
        } else {
            this.mFactoryAdapterOverrides.put(adapter.getProfileOverride(), adapter);
        }
    }
}

