/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal;

import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class ClassLoaderCacheManager {
    private static ClassLoaderCacheManager sm_instance = null;
    private boolean m_isActive = false;
    private Map<ClassPathKey, SoftReference<ClassLoader>> m_classLoaders = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassLoaderCacheManager getInstance() {
        if (sm_instance != null) return sm_instance;
        Class<ClassLoaderCacheManager> clazz = ClassLoaderCacheManager.class;
        synchronized (ClassLoaderCacheManager.class) {
            if (sm_instance != null) return sm_instance;
            sm_instance = new ClassLoaderCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance() {
        if (sm_instance == null) {
            return;
        }
        Class<ClassLoaderCacheManager> clazz = ClassLoaderCacheManager.class;
        synchronized (ClassLoaderCacheManager.class) {
            if (sm_instance != null) {
                sm_instance.reset();
                sm_instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private ClassLoaderCacheManager() {
    }

    private void reset() {
        this.m_classLoaders = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ClassPathKey, SoftReference<ClassLoader>> getClassLoaders() {
        if (this.m_classLoaders == null) {
            ClassLoaderCacheManager classLoaderCacheManager = this;
            synchronized (classLoaderCacheManager) {
                if (this.m_classLoaders == null) {
                    this.m_classLoaders = Collections.synchronizedMap(new TreeMap());
                }
            }
        }
        return this.m_classLoaders;
    }

    public ClassLoader getDriverClassLoader(URL[] classLoaderURLs) {
        if (classLoaderURLs == null || classLoaderURLs.length == 0) {
            return null;
        }
        return this.getDriverClassLoader(new ClassPathKey(classLoaderURLs));
    }

    private ClassLoader getDriverClassLoader(ClassPathKey classPaths) {
        if (classPaths == null || classPaths.getURLCount() == 0) {
            return null;
        }
        SoftReference<ClassLoader> classLdrRef = this.getClassLoaders().get(classPaths);
        return classLdrRef != null ? classLdrRef.get() : null;
    }

    public void addURLClassLoader(URLClassLoader driverClassLoader) {
        if (driverClassLoader == null) {
            return;
        }
        URL[] classLoaderURLs = driverClassLoader.getURLs();
        if (classLoaderURLs == null || classLoaderURLs.length == 0) {
            return;
        }
        ClassLoader cachedClassLoader = this.getDriverClassLoader(classLoaderURLs);
        if (cachedClassLoader != null && driverClassLoader.equals(cachedClassLoader)) {
            return;
        }
        this.getClassLoaders().put(new ClassPathKey(classLoaderURLs), new SoftReference<URLClassLoader>(driverClassLoader));
    }

    public void setIsActive(boolean isActive) {
        this.m_isActive = isActive;
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    private class ClassPathKey
    implements Comparable<ClassPathKey> {
        private URL[] m_classPathURLs;

        ClassPathKey(URL[] classPathURLs) {
            this.m_classPathURLs = classPathURLs == null ? new URL[]{} : classPathURLs;
        }

        private URL[] getclassPathURLs() {
            return this.m_classPathURLs;
        }

        private int getURLCount() {
            return this.m_classPathURLs.length;
        }

        @Override
        public int compareTo(ClassPathKey obj) {
            int objHashCode;
            if (this == obj) {
                return 0;
            }
            if (this.getURLCount() < obj.getURLCount()) {
                return -1;
            }
            if (this.getURLCount() > obj.getURLCount()) {
                return 1;
            }
            if (this.hasMatchingURLs(obj)) {
                return 0;
            }
            int thisHashCode = this.hashCode();
            return thisHashCode < (objHashCode = obj.hashCode()) ? -1 : 1;
        }

        private boolean hasMatchingURLs(ClassPathKey obj) {
            if (this.getURLCount() != obj.getURLCount()) {
                return false;
            }
            URL[] thisURLs = this.getclassPathURLs();
            URL[] objURLs = obj.getclassPathURLs();
            int i = 0;
            while (i < thisURLs.length) {
                URL thisURL = thisURLs[i];
                boolean hasMatchingURL = false;
                int j = 0;
                while (j < objURLs.length) {
                    URL objURL = objURLs[j];
                    if (thisURL.equals(objURL)) {
                        hasMatchingURL = true;
                        break;
                    }
                    ++j;
                }
                if (!hasMatchingURL) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassPathKey)) {
                return false;
            }
            return this.compareTo((ClassPathKey)obj) == 0;
        }

        public int hashCode() {
            int hash = 0;
            URL[] thisURLs = this.getclassPathURLs();
            int i = 0;
            while (i < thisURLs.length) {
                hash += thisURLs[i].hashCode();
                ++i;
            }
            return hash;
        }
    }
}

