/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.internal;

import com.ibm.ims.datatools.connectivity.ICategory;
import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.ProfileManager;
import com.ibm.ims.datatools.connectivity.internal.CategoryProvider;
import com.ibm.ims.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.PlatformObject;

public class Category
extends PlatformObject
implements ICategory {
    private CategoryProvider mProvider;
    private IConnectionProfileRepository mRepository;

    public Category(CategoryProvider provider) {
        this(provider, null);
    }

    public Category(CategoryProvider provider, IConnectionProfileRepository repository) {
        this.mProvider = provider;
        this.mRepository = repository;
    }

    @Override
    public List getAssociatedProfiles() {
        if (this.mRepository == null) {
            return Arrays.asList(ProfileManager.getInstance().getProfilesByCategory(this.getId()));
        }
        return Arrays.asList(this.mRepository.getProfilesByCategory(this.getId()));
    }

    @Override
    public List getChildCategories() {
        List allChildCats = this.mProvider.getChildCategories();
        ArrayList<ICategory> childCats = new ArrayList<ICategory>(allChildCats.size());
        for (CategoryProvider provider : allChildCats) {
            if (this.mRepository != null && !this.mRepository.supportsCategory(provider.getId())) continue;
            childCats.add(provider.createCategory(this.mRepository));
        }
        return childCats;
    }

    @Override
    public String getId() {
        return this.mProvider.getId();
    }

    @Override
    public String getName() {
        return this.mProvider.getName();
    }

    @Override
    public ICategory getParent() {
        CategoryProvider cp = this.mProvider.getParent();
        return cp == null ? null : cp.createCategory(this.mRepository);
    }

    public IConnectionProfile getRepositoryProfile() {
        return this.mRepository == null ? null : this.mRepository.getRepositoryProfile();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Category) {
            Category other = (Category)obj;
            return this.getId().equals(other.getId()) && (this.mRepository == null && other.mRepository == null || this.mRepository != null && other.mRepository != null && this.mRepository.getRepositoryProfile().equals(other.mRepository.getRepositoryProfile()));
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

