/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.drivers.models;

import com.ibm.icu.text.Collator;
import com.ibm.ims.datatools.connectivity.drivers.DriverMgmtMessages;
import com.ibm.ims.datatools.connectivity.drivers.models.MySafeRunnable;
import com.ibm.ims.datatools.connectivity.drivers.models.TemplateDescriptor;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;

public class CategoryDescriptor
implements Comparable {
    public static final String DRIVERTYPE_TAG = "driverExtension";
    private static final String EXTENSION_POINT_NAME = "driverExtension";
    private static final String CATEGORY_ELEMENT_TAG = "category";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PARENTCATEGORY_ATTRIBUTE = "parentCategory";
    private static CategoryDescriptor[] fgCategoryDescriptors;
    private IConfigurationElement fElement;

    protected CategoryDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isNotNull((Object)this.getId(), (String)DriverMgmtMessages.getString("CategoryDescriptor.msg.id_missing"));
        Assert.isNotNull((Object)this.getName(), (String)DriverMgmtMessages.getString("CategoryDescriptor.msg.name_missing"));
    }

    public static CategoryDescriptor[] getCategoryDescriptors() {
        if (fgCategoryDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityPlugin.getSymbolicName(), "driverExtension");
            fgCategoryDescriptors = CategoryDescriptor.createCategoryDescriptors(elements);
        }
        return fgCategoryDescriptors;
    }

    public static CategoryDescriptor getCategoryDescriptor(String id) {
        if (fgCategoryDescriptors == null) {
            fgCategoryDescriptors = CategoryDescriptor.getCategoryDescriptors();
        }
        int i = 0;
        while (i < fgCategoryDescriptors.length) {
            CategoryDescriptor desc = fgCategoryDescriptors[i];
            if (desc.getId().equals(id)) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public static CategoryDescriptor[] getRootCategories() {
        List<CategoryDescriptor> col = Arrays.asList(CategoryDescriptor.getCategoryDescriptors());
        ArrayList<CategoryDescriptor> cats = new ArrayList<CategoryDescriptor>(col.size());
        for (CategoryDescriptor cat : col) {
            if (cat.getParent() != null) continue;
            cats.add(cat);
        }
        return cats.toArray(new CategoryDescriptor[cats.size()]);
    }

    public CategoryDescriptor getParent() {
        if (this.getParentCategory() != null) {
            List<CategoryDescriptor> col = Arrays.asList(CategoryDescriptor.getCategoryDescriptors());
            for (CategoryDescriptor cat : col) {
                if (!cat.getId().equals(this.getParentCategory())) continue;
                return cat;
            }
        }
        return null;
    }

    public List getChildCategories() {
        List<CategoryDescriptor> col = Arrays.asList(CategoryDescriptor.getCategoryDescriptors());
        ArrayList<CategoryDescriptor> cats = new ArrayList<CategoryDescriptor>(col.size());
        for (CategoryDescriptor cat : col) {
            if (cat.getParent() == null || !cat.getParentCategory().equals(this.getId())) continue;
            cats.add(cat);
        }
        return cats;
    }

    public List getAssociatedDriverTypes() {
        List<TemplateDescriptor> col = Arrays.asList(TemplateDescriptor.getDriverTemplateDescriptors());
        ArrayList<TemplateDescriptor> dts = new ArrayList<TemplateDescriptor>(col.size());
        for (TemplateDescriptor dt : col) {
            if (dt.getParentCategory() == null || !dt.getParentCategory().equals(this.getId()) || dt.getRemoveFlag()) continue;
            dts.add(dt);
        }
        return dts;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getParentCategory() {
        return this.fElement.getAttribute(PARENTCATEGORY_ATTRIBUTE);
    }

    public IConfigurationElement getElement() {
        return this.fElement;
    }

    public String getName() {
        String name = this.fElement.getAttribute(NAME_ATTRIBUTE);
        if (name == null && this.getId() != null) {
            name = this.getId();
        }
        return name;
    }

    public String getDescription() {
        String description = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (description == null) {
            description = "";
        }
        return description;
    }

    public int compareTo(Object o) {
        if (o instanceof CategoryDescriptor) {
            return Collator.getInstance().compare(this.getName(), ((CategoryDescriptor)o).getName());
        }
        return Integer.MIN_VALUE;
    }

    private static CategoryDescriptor[] createCategoryDescriptors(IConfigurationElement[] elements) {
        ArrayList<CategoryDescriptor> result = new ArrayList<CategoryDescriptor>(5);
        HashSet<String> descIds = new HashSet<String>(5);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (CATEGORY_ELEMENT_TAG.equals(element.getName())) {
                CategoryDescriptor[] desc = new CategoryDescriptor[1];
                SafeRunner.run((ISafeRunnable)new MySafeRunnable(desc, element));
                if (desc[0] != null && !descIds.contains(desc[0].getId())) {
                    result.add(desc[0]);
                    descIds.add(desc[0].getId());
                }
            }
            ++i;
        }
        Collections.sort(result);
        return result.toArray(new CategoryDescriptor[result.size()]);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryDescriptor) {
            CategoryDescriptor compare = (CategoryDescriptor)obj;
            return this.getId().equals(compare.getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }
}

