/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.drivers.jdbc;

import com.ibm.ims.datatools.connectivity.DriverConnectionBase;
import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.Version;
import com.ibm.ims.datatools.connectivity.drivers.DriverInstance;
import com.ibm.ims.datatools.connectivity.drivers.DriverMgmtMessages;
import com.ibm.ims.datatools.connectivity.drivers.DriverValidator;
import com.ibm.ims.datatools.connectivity.drivers.IDriverMgmtConstants;
import com.ibm.ims.datatools.connectivity.internal.ClassLoaderCacheManager;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class JDBCConnection
extends DriverConnectionBase {
    public static final String TECHNOLOGY_ROOT_KEY = "jdbc";
    public static final String TECHNOLOGY_NAME = ConnectivityPlugin.getDefault().getResourceString("JDBCConnection.technologyName");
    public static final String PROPS_DELIMITER = ",";
    public static final String NAME_VALUE_EQUALS = "=";
    private Version mTechVersion = Version.NULL_VERSION;
    private Version mServerVersion = Version.NULL_VERSION;
    private String mServerName;
    private boolean mHasDriverDefn = true;
    private URL[] m_jdbcJars;

    public JDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
        URL[] jdbcJars = this.getJdbcDriverJars(profile);
        if (jdbcJars != null && jdbcJars.length > 0) {
            this.m_jdbcJars = jdbcJars;
        }
    }

    @Override
    public void open() {
        if (this.mConnection != null) {
            this.close();
        }
        this.mConnection = null;
        this.mConnectException = null;
        boolean hasDriver = false;
        try {
            DriverInstance di = this.getDriverDefinition();
            if (di != null) {
                DriverValidator validator = new DriverValidator(di);
                if (!validator.isValid(false)) {
                    String causeMsgId = "DriverConnectionBase.error.driverDefinitionNotFound";
                    throw new Exception(validator.getMessage(), new Throwable(causeMsgId));
                }
                hasDriver = true;
                super.open();
            }
        }
        catch (Exception e) {
            String exceptionCauseMsg;
            String string = exceptionCauseMsg = e.getCause() != null ? e.getCause().getMessage() : null;
            if (exceptionCauseMsg != null && (exceptionCauseMsg.equalsIgnoreCase("DriverConnectionBase.error.driverDefinitionNotSpecified") || exceptionCauseMsg.equalsIgnoreCase("DriverConnectionBase.error.driverDefinitionNotFound"))) {
                if (this.profileHasDriverDetails()) {
                    this.mHasDriverDefn = false;
                    ConnectivityPlugin.getDefault().logInfo(ConnectivityPlugin.getDefault().getResourceString("JDBCConnection.invalidDriverDefinition", new Object[]{e.getLocalizedMessage(), this.getDriverDefinitionId()}));
                } else {
                    e.printStackTrace();
                }
            }
            e.printStackTrace();
        }
        if (!hasDriver) {
            this.internalCreateConnection();
        }
        this.cacheConnectionClassLoader(this.getRawConnection());
    }

    public String[] getJarListAsArray(String jarList) {
        if (jarList != null) {
            if (jarList.length() == 0) {
                return new String[0];
            }
            String[] paths = this.parseString(jarList, IDriverMgmtConstants.PATH_DELIMITER);
            return paths;
        }
        return null;
    }

    public ClassLoader createClassLoader(ClassLoader parentCL) throws Exception {
        Properties props = this.getConnectionProfile().getBaseProperties();
        String jarList = props.getProperty("jarList");
        if (jarList == null || jarList.trim().length() == 0) {
            throw new Exception(DriverMgmtMessages.getString("DriverInstance.error.jarListNotDefined"));
        }
        String[] jarStrings = this.getJarListAsArray(jarList);
        URL[] jars = new URL[jarStrings.length];
        int index = 0;
        int count = jars.length;
        while (index < count) {
            try {
                jars[index] = new File(jarStrings[index]).toURL();
            }
            catch (MalformedURLException e) {
                throw new Exception(DriverMgmtMessages.getString("DriverInstance.error.invalidClassPath"), e);
            }
            ++index;
        }
        if (parentCL == null) {
            return URLClassLoader.newInstance(jars);
        }
        return URLClassLoader.newInstance(jars, parentCL);
    }

    protected URL[] getJdbcDriverJars() {
        return this.m_jdbcJars;
    }

    protected URL[] getJdbcDriverJars(IConnectionProfile profile) {
        String[] connJarArray = this.getDriverDefinitionJarPaths(true);
        if (connJarArray == null || connJarArray.length == 0) {
            if (profile == null) {
                return null;
            }
            String profileJarList = profile.getBaseProperties().getProperty("jarList");
            connJarArray = this.getJarListAsArray(profileJarList);
            if (connJarArray == null || connJarArray.length == 0) {
                return null;
            }
        }
        ArrayList<URL> jdbcJarURLs = new ArrayList<URL>(connJarArray.length);
        int i = 0;
        while (i < connJarArray.length) {
            String jarPath = connJarArray[i];
            try {
                URL jarPathURL = new File(jarPath).toURL();
                jdbcJarURLs.add(jarPathURL);
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        return jdbcJarURLs.toArray(new URL[jdbcJarURLs.size()]);
    }

    protected String[] getDriverDefinitionJarPaths() {
        return this.getDriverDefinitionJarPaths(false);
    }

    private String[] getDriverDefinitionJarPaths(boolean validateDriver) {
        DriverInstance driver;
        try {
            driver = this.getDriverDefinition();
        }
        catch (Exception exception) {
            return null;
        }
        if (driver == null) {
            return null;
        }
        if (validateDriver && !new DriverValidator(driver).isValid(false)) {
            return null;
        }
        return driver.getJarListAsArray();
    }

    private void internalCreateConnection() {
        try {
            ClassLoader parentCL = this.getParentClassLoader();
            ClassLoader driverCL = this.createClassLoader(parentCL);
            this.mConnection = this.createConnection(driverCL);
            if (this.mConnection == null) {
                throw new Exception(ConnectivityPlugin.getDefault().getResourceString("DriverConnectionBase.error.unknown"));
            }
            this.initVersions();
            this.updateVersionCache();
        }
        catch (Throwable t) {
            this.mConnectException = t;
            this.clearVersionCache();
        }
    }

    @Override
    protected ClassLoader getParentClassLoader() {
        ClassLoader parentClassLoader = ClassLoaderCacheManager.getInstance().getDriverClassLoader(this.m_jdbcJars);
        ClassLoaderCacheManager.getInstance().setIsActive(true);
        return parentClassLoader != null ? parentClassLoader : super.getParentClassLoader();
    }

    protected void cacheConnectionClassLoader(Object sqlConnection) {
        if (sqlConnection == null) {
            return;
        }
        if (!ClassLoaderCacheManager.getInstance().isActive() || this.getParentClassLoader() != null) {
            return;
        }
        ClassLoader jdbcDriverCL = sqlConnection.getClass().getClassLoader();
        if (jdbcDriverCL instanceof URLClassLoader) {
            ClassLoaderCacheManager.getInstance().addURLClassLoader((URLClassLoader)jdbcDriverCL);
        }
    }

    private boolean profileHasDriverDetails() {
        Properties props = this.getConnectionProfile().getBaseProperties();
        String driverClass = props.getProperty("com.ibm.ims.datatools.connectivity.db.driverClass");
        String jarList = props.getProperty("jarList");
        return driverClass != null && jarList != null;
    }

    @Override
    protected Object createConnection(ClassLoader cl) throws Throwable {
        Properties props = this.getConnectionProfile().getBaseProperties();
        Properties connectionProps = new Properties();
        String driverClass = null;
        driverClass = this.mHasDriverDefn ? this.getDriverDefinition().getProperty("com.ibm.ims.datatools.connectivity.db.driverClass") : props.getProperty("com.ibm.ims.datatools.connectivity.db.driverClass");
        String connectURL = props.getProperty("com.ibm.ims.datatools.connectivity.db.URL");
        String uid = props.getProperty("com.ibm.ims.datatools.connectivity.db.username");
        String pwd = props.getProperty("com.ibm.ims.datatools.connectivity.db.password");
        String nameValuePairs = props.getProperty("com.ibm.ims.datatools.connectivity.db.connectionProperties");
        String propDelim = PROPS_DELIMITER;
        if (uid != null) {
            connectionProps.setProperty("user", uid);
        }
        if (pwd != null) {
            connectionProps.setProperty("password", pwd);
        }
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            String[] pairs = this.parseString(nameValuePairs, PROPS_DELIMITER);
            Object addPairs = "";
            int i = 0;
            while (i < pairs.length) {
                String[] namevalue = this.parseString(pairs[i], NAME_VALUE_EQUALS);
                connectionProps.setProperty(namevalue[0], namevalue[1]);
                if (i == 0 || i < pairs.length - 1) {
                    addPairs = (String)addPairs + propDelim;
                }
                addPairs = (String)addPairs + pairs[i];
                ++i;
            }
        }
        Driver jdbcDriver = (Driver)cl.loadClass(driverClass).newInstance();
        return jdbcDriver.connect(connectURL, connectionProps);
    }

    @Override
    public void close() {
        Connection connection = (Connection)this.getRawConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getProviderName() {
        return this.mServerName;
    }

    @Override
    public Version getProviderVersion() {
        return this.mServerVersion;
    }

    @Override
    protected String getTechnologyRootKey() {
        return TECHNOLOGY_ROOT_KEY;
    }

    @Override
    public String getTechnologyName() {
        return TECHNOLOGY_NAME;
    }

    @Override
    public Version getTechnologyVersion() {
        return this.mTechVersion;
    }

    @Override
    protected void initVersions() {
        try {
            DatabaseMetaData dbmd = ((Connection)this.getRawConnection()).getMetaData();
            try {
                this.mServerName = dbmd.getDatabaseProductName();
            }
            catch (Throwable throwable) {}
            try {
                String[] versionComps;
                Object versionString = dbmd.getDatabaseProductVersion();
                if (((String)versionString).indexOf(47) > 0 && (versionComps = ((String)versionString).split("/", 4)).length > 2) {
                    versionString = versionComps[1];
                    if (versionComps.length > 3) {
                        versionString = (String)versionString + "." + (versionComps[2].startsWith("EBF") ? versionComps[2].substring(3).trim() : versionComps[2]);
                    }
                    if (versionComps[0].length() > 0 && !versionComps[0].equals(this.mServerName)) {
                        this.mServerName = versionComps[0];
                    }
                }
                this.mServerVersion = Version.valueOf((String)versionString);
            }
            catch (Throwable throwable) {}
            try {
                this.mTechVersion = new Version(dbmd.getJDBCMajorVersion(), dbmd.getJDBCMinorVersion(), 0, new String());
            }
            catch (Throwable throwable) {}
        }
        catch (SQLException sQLException) {}
    }

    protected String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }
}

