/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.drivers;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.ims.datatools.connectivity.drivers.IPropertySet;
import com.ibm.ims.datatools.connectivity.drivers.PropertySetImpl;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLFileManager {
    private static final String FILENAME = "PropertySets.xml";
    private static final String ROOTNAME = "DataTools.PropertySets";
    private static final String CHILDNAME = "propertySet";
    private static final String PROPSETNAME = "name";
    private static final String PROPSETID = "iD";
    private static final String PROPSETKEYS = "keys";
    private static final String PROPPREFIX = "prop_";
    private static final String PROPDELIM = " ";
    private static IPath storageLocation = null;
    private static String mFileName = null;
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder documentBuilder = null;
    private static TransformerFactory transFactory = null;
    private static Transformer transformer = null;

    public XMLFileManager() {
        mFileName = FILENAME;
    }

    private static String keysToString(Enumeration enu) {
        StringBuffer keys = new StringBuffer();
        while (enu.hasMoreElements()) {
            keys.append((String)enu.nextElement() + PROPDELIM);
        }
        return keys.toString();
    }

    private static Properties keysToProperties(Element elem) {
        Properties props = new Properties();
        String keys = elem.getAttribute(PROPSETKEYS);
        StringTokenizer st = new StringTokenizer(keys, PROPDELIM);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            String value = elem.getAttribute(PROPPREFIX + key);
            props.put(key, value);
        }
        return props;
    }

    public static synchronized void saveNamedPropertySet(IPropertySet[] pss) throws CoreException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement(ROOTNAME);
            document.appendChild(rootElement);
            Element child = null;
            IPath path = XMLFileManager.getStorageLocation();
            path = path.append(mFileName);
            File file = path.toFile();
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream outs = new FileOutputStream(file);
            Writer writer = null;
            try {
                OutputStreamWriter outw = new OutputStreamWriter((OutputStream)outs, "UTF-8");
                writer = new BufferedWriter(outw);
                int i = 0;
                while (i < pss.length) {
                    IPropertySet ps = pss[i];
                    if (ps != null) {
                        child = document.createElement(CHILDNAME);
                        child.setAttribute(PROPSETNAME, ps.getName());
                        child.setAttribute(PROPSETID, ps.getID());
                        Properties props = ps.getBaseProperties();
                        String keys = XMLFileManager.keysToString(props.keys());
                        child.setAttribute(PROPSETKEYS, keys);
                        Enumeration<?> enu = props.propertyNames();
                        while (enu.hasMoreElements()) {
                            String key = (String)enu.nextElement();
                            String value = props.getProperty(key);
                            child.setAttribute(PROPPREFIX + key, value);
                        }
                        rootElement.appendChild(child);
                    }
                    ++i;
                }
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(outw);
                XMLFileManager.getTransformer().transform(source, result);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (outs != null) {
                    ((OutputStream)outs).close();
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ims.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.savedriversxml"), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ims.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.savedriversxml"), (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ims.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.savedriversxml"), (Throwable)e));
        }
    }

    public static synchronized IPropertySet[] loadPropertySets() throws CoreException {
        InputStream fis = null;
        try {
            IPath path = XMLFileManager.getStorageLocation();
            path = path.append(mFileName);
            File file = path.toFile();
            if (!file.exists()) {
                IPropertySet[] iPropertySetArray = new IPropertySet[]{};
                return iPropertySetArray;
            }
            fis = new FileInputStream(file);
            InputSource source = new InputSource(fis);
            source.setEncoding("UTF-8");
            Document document = XMLFileManager.getDocumentBuilder().parse(source);
            ArrayList<PropertySetImpl> pss = new ArrayList<PropertySetImpl>();
            NodeList nl = document.getElementsByTagName(CHILDNAME);
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node instanceof Element) {
                    Element elem = (Element)node;
                    String name = elem.getAttribute(PROPSETNAME);
                    String id = elem.getAttribute(PROPSETID);
                    Properties props = XMLFileManager.keysToProperties(elem);
                    PropertySetImpl ps = new PropertySetImpl(name, id);
                    ps.setBaseProperties(props);
                    pss.add(ps);
                }
                ++i;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.ims.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
                }
            }
            IPropertySet[] iPropertySetArray = pss.toArray(new IPropertySet[0]);
            return iPropertySetArray;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ims.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ims.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.ims.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loaddriversxml"), (Throwable)e));
                }
            }
        }
    }

    public static IPath getStorageLocation() {
        if (storageLocation == null) {
            return ConnectivityPlugin.getStorageLocation();
        }
        return storageLocation;
    }

    public static void setStorageLocation(IPath location) {
        storageLocation = location;
    }

    public static String getFileName() {
        return mFileName;
    }

    public static void setFileName(String name) {
        mFileName = name;
    }

    public static String getFileDateTimeStamp() {
        IPath path = XMLFileManager.getStorageLocation();
        File file = (path = path.append(mFileName)).toFile();
        if (!file.exists()) {
            return null;
        }
        Long modified = file.lastModified();
        return modified.toString();
    }

    private static DocumentBuilder getDocumentBuilder() {
        if (documentBuilder == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return documentBuilder;
    }

    private static Transformer getTransformer() {
        if (transformer == null) {
            transFactory = TransformerFactory.newInstance();
            try {
                transformer = transFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return transformer;
    }
}

