/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.drivers;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.ims.datatools.connectivity.drivers.DriverInstance;
import com.ibm.ims.datatools.connectivity.drivers.DriverMgmtMessages;
import com.ibm.ims.datatools.connectivity.drivers.DriverValidator;
import com.ibm.ims.datatools.connectivity.drivers.IDriverMgmtConstants;
import com.ibm.ims.datatools.connectivity.drivers.IDriverValuesProvider;
import com.ibm.ims.datatools.connectivity.drivers.IPropertySet;
import com.ibm.ims.datatools.connectivity.drivers.PropertySetImpl;
import com.ibm.ims.datatools.connectivity.drivers.XMLFileManager;
import com.ibm.ims.datatools.connectivity.drivers.models.CategoryDescriptor;
import com.ibm.ims.datatools.connectivity.drivers.models.OverrideTemplateDescriptor;
import com.ibm.ims.datatools.connectivity.drivers.models.TemplateDescriptor;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;
import com.ibm.ims.datatools.connectivity.services.PluginResourceLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class DriverManager {
    private static DriverManager sInstance;
    private static HashMap mDriverInstanceMap;
    private static boolean refreshDriverMap;
    private static String DRIVER_MARKER_FILE_NAME;
    private static final String EMPTY_STRING = "";
    private static boolean mDebug;

    static {
        refreshDriverMap = false;
        DRIVER_MARKER_FILE_NAME = "driverManagerPreferences.xml";
        mDebug = ConnectivityPlugin.getDefault().isDebugging();
    }

    public static synchronized DriverManager getInstance() {
        if (sInstance == null) {
            sInstance = new DriverManager();
        }
        return sInstance;
    }

    private synchronized void loadAllInstances() {
        this.loadAllInstances(true);
    }

    private synchronized void loadAllInstances(boolean migrate) {
        DriverManager.debug("loadAllInstances: migrate = " + migrate);
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            IPropertySet[] psets = XMLFileManager.loadPropertySets();
            if (psets.length > 0) {
                boolean changed = false;
                int i = 0;
                while (i < psets.length) {
                    IPropertySet pset = psets[i];
                    DriverInstance ndi = new DriverInstance(pset);
                    if (migrate) {
                        changed = ndi.migrate();
                    }
                    if (changed) {
                        IPropertySet migratedPset = ndi.getPropertySet();
                        DriverManager.debug("loadAllInstances: migrated di = " + migratedPset.getID());
                        psets[i] = migratedPset;
                        DriverInstance mndi = new DriverInstance(migratedPset);
                        mDriverInstanceMap.put(mndi.getId(), mndi);
                        this.saveChanges(psets);
                        refreshDriverMap = true;
                    } else {
                        mDriverInstanceMap.put(ndi.getId(), ndi);
                    }
                    ++i;
                }
                return;
            }
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    private void saveChanges(IPropertySet[] psets) {
        DriverManager.debug("saveChanges");
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            XMLFileManager.saveNamedPropertySet(psets);
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    private DriverManager() {
        this.resetDefaultInstances(true);
    }

    private DriverInstance getDriverInstanceFromMapByName(String name) {
        for (DriverInstance di : mDriverInstanceMap.values()) {
            if (!di.getName().equals(name)) continue;
            return di;
        }
        return null;
    }

    private DriverInstance getDriverInstanceFromMapByID(String id) {
        return (DriverInstance)mDriverInstanceMap.get(id);
    }

    private DriverInstance[] getDriverInstancesFromMapByCategoryID(String categoryid) {
        Iterator iter = mDriverInstanceMap.values().iterator();
        ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
        while (iter.hasNext()) {
            CategoryDescriptor templateParent;
            DriverInstance di = (DriverInstance)iter.next();
            TemplateDescriptor template = di.getTemplate();
            if (template == null || (templateParent = template.getParent()) == null || !templateParent.getId().equals(categoryid)) continue;
            list.add(di);
        }
        return list.toArray(new DriverInstance[list.size()]);
    }

    private DriverInstance[] getDriverInstancesFromMapForTemplateID(String templateid) {
        Iterator iter = mDriverInstanceMap.values().iterator();
        ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            TemplateDescriptor template = di.getTemplate();
            if (template == null || !template.getId().equals(templateid)) continue;
            list.add(di);
        }
        return list.toArray(new DriverInstance[list.size()]);
    }

    public DriverInstance getDriverInstanceByID(String id) {
        DriverInstance di = this.getDriverInstanceFromMapByID(id);
        if (di == null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    int i = 0;
                    while (i < psets.length) {
                        IPropertySet pset = psets[i];
                        if (pset.getID().equals(id)) {
                            di = new DriverInstance(pset);
                            mDriverInstanceMap.put(di.getId(), di);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return di;
    }

    public DriverInstance[] getDriverInstancesByCategory(String categoryid) {
        return this.getDriverInstancesFromMapByCategoryID(categoryid);
    }

    public DriverInstance[] getDriverInstancesByTemplate(String templateid) {
        return this.getDriverInstancesFromMapForTemplateID(templateid);
    }

    public DriverInstance getDriverInstanceByName(String name) {
        DriverInstance di = this.getDriverInstanceFromMapByName(name);
        if (di == null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    int i = 0;
                    while (i < psets.length) {
                        IPropertySet pset = psets[i];
                        if (pset.getName().equals(name)) {
                            di = new DriverInstance(pset);
                            mDriverInstanceMap.put(di.getId(), di);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return di;
    }

    public DriverInstance[] getDriverInstancesByName(String name) {
        Vector<DriverInstance> driverInstanceCollection = new Vector<DriverInstance>();
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            IPropertySet[] psets = XMLFileManager.loadPropertySets();
            if (psets.length > 0) {
                int i = 0;
                while (i < psets.length) {
                    IPropertySet pset = psets[i];
                    if (pset.getName().equals(name)) {
                        DriverInstance driver = new DriverInstance(pset);
                        driverInstanceCollection.add(new DriverInstance(pset));
                        mDriverInstanceMap.put(driver.getId(), driver);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
        Object[] driverInstanceArray = new DriverInstance[driverInstanceCollection.size()];
        driverInstanceCollection.copyInto(driverInstanceArray);
        return driverInstanceArray;
    }

    public String getFullJarList() {
        Object[] drivers = mDriverInstanceMap.values().toArray();
        Object fullList = EMPTY_STRING;
        int x = 0;
        while (x < drivers.length) {
            DriverInstance di = (DriverInstance)drivers[x];
            if (di.getJarList() != null) {
                String jarlist = di.getJarList().trim();
                if (((String)fullList).trim().length() > 0) {
                    fullList = (String)fullList + IDriverMgmtConstants.PATH_DELIMITER;
                }
                fullList = (String)fullList + jarlist + IDriverMgmtConstants.PATH_DELIMITER;
            }
            if (((String)fullList).substring(((String)fullList).length() - 1, ((String)fullList).length()).equals(IDriverMgmtConstants.PATH_DELIMITER)) {
                fullList = ((String)fullList).substring(0, ((String)fullList).length() - 1);
            }
            ++x;
        }
        if (((String)fullList).trim().length() > 0) {
            String[] paths = this.parseString((String)fullList, IDriverMgmtConstants.PATH_DELIMITER);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < paths.length) {
                File testFile = new File(paths[i]);
                if (testFile.exists() && !list.contains(paths[i])) {
                    list.add(paths[i]);
                }
                ++i;
            }
            Object newList = EMPTY_STRING;
            Iterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                newList = (String)newList + String.valueOf(iter2.next()) + IDriverMgmtConstants.PATH_DELIMITER;
            }
            if (((String)newList).length() > 0 && ((String)newList).substring(((String)newList).length() - 1, ((String)newList).length()).equals(IDriverMgmtConstants.PATH_DELIMITER)) {
                newList = ((String)newList).substring(0, ((String)newList).length() - 1);
            }
            return newList;
        }
        return null;
    }

    public String[] getFullJarListAsArray() {
        if (this.getFullJarList() != null) {
            if (this.getFullJarList().length() == 0) {
                return new String[0];
            }
            String[] paths = this.parseString(this.getFullJarList(), IDriverMgmtConstants.PATH_DELIMITER);
            return paths;
        }
        return null;
    }

    public DriverInstance[] getValidDriverInstances() {
        DriverInstance[] array = new DriverInstance[]{};
        Iterator iter = mDriverInstanceMap.values().iterator();
        ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            DriverValidator validator = new DriverValidator(di);
            if (!validator.isValid()) continue;
            list.add(di);
        }
        array = new DriverInstance[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = (DriverInstance)list.get(i);
            ++i;
        }
        return array;
    }

    public DriverInstance[] getAllDriverInstances() {
        return mDriverInstanceMap.values().toArray(new DriverInstance[mDriverInstanceMap.values().size()]);
    }

    private IPropertySet[] getPropertySetsFromMap() {
        Iterator iter = mDriverInstanceMap.values().iterator();
        ArrayList<IPropertySet> list = new ArrayList<IPropertySet>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            list.add(di.getPropertySet());
        }
        return list.toArray(new IPropertySet[list.size()]);
    }

    public DriverInstance createNewDriverInstance(String templateID, String name, String jarList, String driverClass) {
        if (templateID == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        IPropertySet pset = this.createDefaultInstance(templateID);
        if (pset == null) {
            return null;
        }
        if (name != null) {
            pset.setName(name);
        }
        String prefix = DriverMgmtMessages.getString("NewDriverDialog.text.id_prefix");
        String id = prefix + templateID + "." + name;
        pset.setID(id);
        Properties props = pset.getBaseProperties();
        if (jarList != null) {
            props.setProperty("jarList", jarList);
        }
        props.setProperty("com.ibm.ims.datatools.connectivity.db.driverClass", driverClass);
        this.addDriverInstance(pset);
        return this.getDriverInstanceByID(pset.getID());
    }

    public DriverInstance createNewDriverInstance(String templateID, String name, String jarList) {
        if (templateID == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        IPropertySet pset = this.createDefaultInstance(templateID);
        if (pset == null) {
            return null;
        }
        if (name != null) {
            pset.setName(name);
        }
        String prefix = DriverMgmtMessages.getString("NewDriverDialog.text.id_prefix");
        String id = prefix + templateID + "." + name;
        pset.setID(id);
        Properties props = pset.getBaseProperties();
        if (jarList != null) {
            props.setProperty("jarList", jarList);
        }
        this.addDriverInstance(pset);
        return this.getDriverInstanceByID(pset.getID());
    }

    public boolean removeDriverInstance(String id) {
        boolean rtnFlag = false;
        if (this.getDriverInstanceByID(id) != null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    IPropertySet[] newPsets = new IPropertySet[psets.length - 1];
                    int counter = 0;
                    int i = 0;
                    while (i < psets.length) {
                        IPropertySet pset = psets[i];
                        if (pset.getID().equals(id)) {
                            rtnFlag = true;
                            DriverValidator.removeOldProblemMarkers(pset.getName());
                        } else {
                            newPsets[counter] = pset;
                            ++counter;
                        }
                        ++i;
                    }
                    if (rtnFlag) {
                        XMLFileManager.saveNamedPropertySet(newPsets);
                        mDriverInstanceMap = new HashMap();
                        this.loadAllInstances();
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return rtnFlag;
    }

    public void addDriverInstance(DriverInstance di) {
        mDriverInstanceMap.put(di.getId(), di);
        IPropertySet[] psets = this.getPropertySetsFromMap();
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            XMLFileManager.saveNamedPropertySet(psets);
            mDriverInstanceMap = new HashMap();
            this.loadAllInstances();
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    public void addDriverInstance(IPropertySet pset) {
        DriverInstance di = new DriverInstance(pset);
        this.addDriverInstance(di);
    }

    public void addDriverInstances(IPropertySet[] propertySets) {
        int i = 0;
        while (i < propertySets.length) {
            DriverInstance di = new DriverInstance(propertySets[i]);
            mDriverInstanceMap.put(di.getId(), di);
            ++i;
        }
        IPropertySet[] psets = this.getPropertySetsFromMap();
        this.saveChanges(psets);
        mDriverInstanceMap = new HashMap();
        this.loadAllInstances();
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean wereDefaultDriversCreated() {
        IPath metadataPath = ConnectivityPlugin.getWorkspaceFilePath(DRIVER_MARKER_FILE_NAME);
        File file = metadataPath.toFile();
        if (!file.exists()) return false;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                ConnectivityPlugin.getDefault().loadPreferences(fis);
                return true;
            }
            catch (FileNotFoundException e) {
                ConnectivityPlugin.getDefault().log(e);
                if (fis == null) return true;
                try {
                    fis.close();
                    return true;
                }
                catch (IOException e2) {
                    ConnectivityPlugin.getDefault().log(e2);
                }
                return true;
            }
            catch (IOException e) {
                ConnectivityPlugin.getDefault().log(e);
                if (fis == null) return true;
                try {
                    fis.close();
                    return true;
                }
                catch (IOException e3) {
                    ConnectivityPlugin.getDefault().log(e3);
                }
                return true;
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    ConnectivityPlugin.getDefault().log(e);
                }
            }
        }
    }

    private boolean createDefaultDriversMarker() {
        IPath metadataPath = ConnectivityPlugin.getWorkspaceFilePath(DRIVER_MARKER_FILE_NAME);
        File file = metadataPath.toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private boolean wasDefaultCreatedBefore(TemplateDescriptor td) {
        return ConnectivityPlugin.getDefault().getPreferenceBooleanValue(td.getId());
    }

    public void resetDefaultInstances() {
        this.resetDefaultInstances(false);
    }

    public void resetDefaultInstances(boolean batchUpdate) {
        DriverManager.debug("resetDefaultInstances");
        ArrayList<IPropertySet> psets_list = new ArrayList<IPropertySet>();
        TemplateDescriptor[] types = TemplateDescriptor.getDriverTemplateDescriptors();
        XMLFileManager.setFileName("driverStorage.xml");
        if (mDriverInstanceMap == null || refreshDriverMap) {
            DriverManager.debug("resetDefaultInstances: loading hash map");
            mDriverInstanceMap = new HashMap();
            this.loadAllInstances(true);
            if (refreshDriverMap) {
                refreshDriverMap = false;
            }
        }
        this.wereDefaultDriversCreated();
        DriverManager.debug("resetDefaultInstances: checking for drivers to create by default");
        IPropertySet[] psets = this.getPropertySetsFromMap();
        ArrayList<IPropertySet> pendingPropertySets = null;
        ArrayList<TemplateDescriptor> pendingDefaultsCreated = null;
        boolean updatePending = false;
        if (batchUpdate) {
            pendingPropertySets = new ArrayList<IPropertySet>();
            pendingDefaultsCreated = new ArrayList<TemplateDescriptor>();
        }
        int i = 0;
        while (i < types.length) {
            IPropertySet newPset;
            String value;
            String value2;
            TemplateDescriptor type = types[i];
            boolean alreadyExists = false;
            if (psets.length > 0) {
                int j = 0;
                while (j < psets.length) {
                    String category;
                    IPropertySet pset = psets[j];
                    if (pset.getBaseProperties().getProperty("com.ibm.ims.datatools.connectivity.drivers.defnType") != null && (category = pset.getBaseProperties().getProperty("com.ibm.ims.datatools.connectivity.drivers.defnType")).equalsIgnoreCase(type.getId())) {
                        alreadyExists = true;
                        psets_list.add(pset);
                    }
                    ++j;
                }
            }
            boolean defaultExists = this.wasDefaultCreatedBefore(type);
            boolean createDefaultValue = false;
            if (type.getValuesProviderClass() != null && (value2 = type.getValuesProviderClass().createDefaultValue("createDefault")) != null) {
                createDefaultValue = Boolean.valueOf(value2);
            }
            IDriverValuesProvider overrideDriverValsProvider = null;
            OverrideTemplateDescriptor[] otds = OverrideTemplateDescriptor.getByDriverTemplate(type.getId());
            if (otds != null && otds.length > 0 && (overrideDriverValsProvider = otds[0].getValuesProviderClass()) != null && (value = overrideDriverValsProvider.createDefaultValue("createDefault")) != null) {
                createDefaultValue = Boolean.valueOf(value);
            }
            DriverManager.debug("Default already exists for " + type.getId() + ": " + defaultExists);
            if ((createDefaultValue || type.getCreateDefaultFlag()) && !defaultExists && !alreadyExists && (newPset = this.createDefaultInstance(type)) != null) {
                if (batchUpdate) {
                    pendingPropertySets.add(newPset);
                    pendingDefaultsCreated.add(type);
                    updatePending = true;
                } else {
                    this.addDriverInstance(newPset);
                    this.setDefaultCreated(type.getId(), true);
                }
            }
            ++i;
        }
        if (batchUpdate && updatePending) {
            this.addDriverInstances(pendingPropertySets.toArray(new IPropertySet[0]));
            this.setDefaultCreated(pendingDefaultsCreated.toArray(new TemplateDescriptor[0]), true);
        }
        boolean markerCreated = this.createDefaultDriversMarker();
        DriverManager.debug("Marker created: " + markerCreated);
    }

    private void setDefaultCreated(TemplateDescriptor[] types, boolean isDefaultCreated) {
        TemplateDescriptor[] templateDescriptorArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateDescriptor type = templateDescriptorArray[n2];
            ConnectivityPlugin.getDefault().setPreferenceValue(type.getId(), isDefaultCreated);
            ++n2;
        }
        this.savePreferences();
    }

    private void setDefaultCreated(String driverTemplateId, boolean isDefaultCreated) {
        ConnectivityPlugin.getDefault().setPreferenceValue(driverTemplateId, isDefaultCreated);
        this.savePreferences();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void savePreferences() {
        IPath metadataPath = ConnectivityPlugin.getWorkspaceFilePath(DRIVER_MARKER_FILE_NAME);
        File file = metadataPath.toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {}
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                ConnectivityPlugin.getDefault().storePreferences(fos, "DriverManager.Preferences");
                return;
            }
            catch (FileNotFoundException e) {
                ConnectivityPlugin.getDefault().log(e);
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException e2) {
                    ConnectivityPlugin.getDefault().log(e2);
                }
                return;
            }
            catch (IOException e) {
                ConnectivityPlugin.getDefault().log(e);
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException e3) {
                    ConnectivityPlugin.getDefault().log(e3);
                }
                return;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    ConnectivityPlugin.getDefault().log(e);
                }
            }
        }
    }

    public IPropertySet createDefaultInstance(String id) {
        TemplateDescriptor template = TemplateDescriptor.getDriverTemplateDescriptor(id);
        IPropertySet pset = this.createInstance(template);
        return pset;
    }

    private IPropertySet createInstance(TemplateDescriptor template) {
        return this.createDefaultInstance(template, true);
    }

    private IPropertySet createDefaultInstance(TemplateDescriptor template) {
        return this.createDefaultInstance(template, false);
    }

    private IPropertySet createDefaultInstance(TemplateDescriptor template, boolean override) {
        String overrideValsCreateDefault;
        String valsCreateDefault;
        IDriverValuesProvider driverValsProvider = null;
        IDriverValuesProvider overrideDriverValsProvider = null;
        OverrideTemplateDescriptor[] otds = null;
        if (template != null) {
            DriverManager.debug("Creating Default Instance of " + template.getId());
            otds = OverrideTemplateDescriptor.getByDriverTemplate(template.getId());
            if (otds != null && otds.length > 0 && (overrideDriverValsProvider = otds[0].getValuesProviderClass()) != null) {
                DriverManager.debug("Have a driver values provider from the override");
            }
            if ((driverValsProvider = template.getValuesProviderClass()) != null) {
                DriverManager.debug("Have a driver values provider from the template");
            }
        }
        boolean createDefault = template != null ? template.getCreateDefaultFlag() : false;
        DriverManager.debug("Create Default from the template is " + createDefault);
        if (driverValsProvider != null && (valsCreateDefault = driverValsProvider.createDefaultValue("createDefault")) != null) {
            createDefault = Boolean.valueOf(valsCreateDefault);
            DriverManager.debug("Create Default was reset to " + valsCreateDefault + " by the driver values provider");
        }
        if (overrideDriverValsProvider != null && (overrideValsCreateDefault = overrideDriverValsProvider.createDefaultValue("createDefault")) != null) {
            createDefault = Boolean.valueOf(overrideValsCreateDefault);
            DriverManager.debug("Create Default was reset to " + overrideValsCreateDefault + " by the override driver values provider");
        }
        if (template != null && (createDefault || override)) {
            String prefix = DriverMgmtMessages.getString("NewDriverDialog.text.id_prefix");
            String suffix = DriverMgmtMessages.getString("DriverMgmtPlugin.default_instance_suffix");
            Object name = template.getDefaultDefinitionName() + " " + suffix;
            String id = prefix + template.getId() + "." + (String)name;
            DriverManager.debug("Default driver name from the template is " + (String)name);
            if (driverValsProvider != null) {
                String driverValsDefaultDefinitionName;
                String driverValsName = driverValsProvider.createDefaultValue("name");
                if (driverValsName != null) {
                    name = driverValsName;
                    DriverManager.debug("Driver name was reset to " + driverValsName + " by the driver values provider");
                }
                if ((driverValsDefaultDefinitionName = driverValsProvider.createDefaultValue("defaultDefinitionName")) != null) {
                    name = driverValsDefaultDefinitionName;
                    DriverManager.debug("Driver name was reset to " + driverValsDefaultDefinitionName + " (Default Definition Name) by the driver values provider");
                }
            }
            if (overrideDriverValsProvider != null) {
                String overrideDriverValsDefaultDefinitionName;
                String overrideDriverValsName = overrideDriverValsProvider.createDefaultValue("name");
                if (overrideDriverValsName != null) {
                    name = overrideDriverValsName;
                    DriverManager.debug("Driver name was reset to " + overrideDriverValsName + " by the override driver values provider");
                }
                if ((overrideDriverValsDefaultDefinitionName = overrideDriverValsProvider.createDefaultValue("defaultDefinitionName")) != null) {
                    name = overrideDriverValsDefaultDefinitionName;
                    DriverManager.debug("Driver name was reset to " + overrideDriverValsDefaultDefinitionName + " (Default Definition Name) by the override driver values provider");
                }
            }
            PropertySetImpl propset = new PropertySetImpl(id, template.getName());
            propset.setID(id);
            propset.setName((String)name);
            Properties props = new Properties();
            String jarList = EMPTY_STRING;
            String valsJarList = null;
            String overrideValsJarList = null;
            if (driverValsProvider != null && (valsJarList = driverValsProvider.createDefaultValue("jarList")) != null) {
                jarList = valsJarList;
                DriverManager.debug("Jar list was reset to " + valsJarList + " by the driver values provider");
            }
            if (overrideDriverValsProvider != null && (overrideValsJarList = overrideDriverValsProvider.createDefaultValue("jarList")) != null) {
                jarList = overrideValsJarList;
                DriverManager.debug("Jar list was reset to " + overrideValsJarList + " by the override driver values provider");
            }
            if (valsJarList == null && overrideValsJarList == null) {
                jarList = this.updatePluginJarList(template);
                DriverManager.debug("Default jar list from the template is " + jarList);
            }
            props.setProperty("jarList", jarList);
            props.setProperty("com.ibm.ims.datatools.connectivity.drivers.defnType", template.getId());
            IConfigurationElement[] templateprops = template.getProperties();
            if (props != null && templateprops.length > 0) {
                int i = 0;
                while (i < templateprops.length) {
                    String overrideValsPropValue;
                    String valsPropValue;
                    IConfigurationElement prop = templateprops[i];
                    String propid = prop.getAttribute("id");
                    String propvalue = prop.getAttribute("value");
                    DriverManager.debug("Default Value of property " + propid + " from the template is " + propvalue);
                    boolean removeIt = false;
                    if (driverValsProvider != null && (valsPropValue = driverValsProvider.createDefaultValue(propid)) != null) {
                        propvalue = valsPropValue;
                        DriverManager.debug("Value of property " + propid + " was reset to " + valsPropValue + " by the driver values provider");
                    }
                    if (otds != null && otds.length > 0) {
                        String temp = otds[0].getPropertyValueFromId(propid);
                        if (temp != null && temp.length() > 0) {
                            propvalue = temp;
                            DriverManager.debug("Value of property " + propid + " was reset to " + temp + " by a driver override");
                        }
                        if (otds[0].getPropertyRemoveFlagFromID(propid)) {
                            removeIt = true;
                            DriverManager.debug("Property " + propid + " was removed by a driver override");
                        }
                    }
                    if (overrideDriverValsProvider != null && (overrideValsPropValue = overrideDriverValsProvider.createDefaultValue(propid)) != null) {
                        propvalue = overrideValsPropValue;
                        DriverManager.debug("Value of property " + propid + " was reset to " + overrideValsPropValue + " by the override driver values provider");
                    }
                    if (!removeIt) {
                        props.setProperty(propid, propvalue == null ? new String() : propvalue);
                    } else {
                        props.remove(propid);
                    }
                    ++i;
                }
            }
            propset.setBaseProperties(props);
            return propset;
        }
        return null;
    }

    public boolean removeInvalidDefaultInstance(String driverTemplateId, boolean resetDefaultCreated) {
        if (driverTemplateId == null || driverTemplateId.length() == 0) {
            return false;
        }
        TemplateDescriptor driverTemplate = TemplateDescriptor.getDriverTemplateDescriptor(driverTemplateId);
        if (driverTemplate == null) {
            return false;
        }
        String defaultDefnName = driverTemplate.getDefaultDefinitionName();
        if (defaultDefnName == null || defaultDefnName.length() == 0) {
            return false;
        }
        DriverInstance defaultInstance = this.getDriverInstanceByName(defaultDefnName);
        if (defaultInstance == null) {
            return false;
        }
        if (new DriverValidator(defaultInstance).isValid(false)) {
            return false;
        }
        boolean isRemoved = this.removeDriverInstance(defaultInstance.getId());
        if (isRemoved && resetDefaultCreated) {
            this.setDefaultCreated(driverTemplateId, false);
        }
        return isRemoved;
    }

    public String updatePluginJarList(TemplateDescriptor template) {
        Object jarList = template.getJarList();
        if (((String)jarList).indexOf("[") > -1) {
            int index = ((String)jarList).indexOf(IDriverMgmtConstants.PATH_DELIMITER, 0);
            if (index <= 0) {
                index = ((String)jarList).indexOf(",", 0);
                if (index > 0) {
                    jarList = ((String)jarList).replace(',', IDriverMgmtConstants.PATH_DELIMITER_CHAR);
                } else {
                    index = ((String)jarList).indexOf(";", 0);
                    if (index > 0) {
                        jarList = ((String)jarList).replace(';', IDriverMgmtConstants.PATH_DELIMITER_CHAR);
                    }
                }
            }
            index = ((String)jarList).indexOf("[");
            while (index > -1) {
                String toReplace = ((String)jarList).substring(index, ((String)jarList).indexOf("]", index) + 1);
                String pluginId = null;
                pluginId = toReplace.toUpperCase().equals("[PLUGIN]") ? template.getElement().getContributor().getName() : toReplace.substring(1, toReplace.length() - 1);
                String restOfPath = null;
                restOfPath = ((String)jarList).indexOf(IDriverMgmtConstants.PATH_DELIMITER, index) > 0 ? ((String)jarList).substring(((String)jarList).indexOf("]", index) + 1, ((String)jarList).indexOf(IDriverMgmtConstants.PATH_DELIMITER, index)) : (((String)jarList).indexOf(",", index) > 0 ? ((String)jarList).substring(((String)jarList).indexOf("]", index) + 1, ((String)jarList).indexOf(",", index)) : (((String)jarList).indexOf(";", index) > 0 ? ((String)jarList).substring(((String)jarList).indexOf("]", index) + 1, ((String)jarList).indexOf(";", index)) : ((String)jarList).substring(((String)jarList).indexOf("]", index) + 1, ((String)jarList).length())));
                if (Platform.getBundle((String)pluginId) != null || !ConnectivityPlugin.isRunningOSGiPlatform()) {
                    IPath path = null;
                    if (restOfPath == null || restOfPath.trim().length() == 0) {
                        path = PluginResourceLocator.getPluginRootPath(pluginId);
                    } else {
                        String entry = File.separator + restOfPath + File.separator;
                        path = PluginResourceLocator.getPluginEntryPath(pluginId, entry);
                    }
                    if (path != null) {
                        int totalLength = toReplace.length() + restOfPath.length();
                        jarList = ((String)jarList).substring(0, index) + path.toOSString() + ((String)jarList).substring(index + totalLength, ((String)jarList).length());
                    } else {
                        Object[] strs = new String[]{pluginId + restOfPath};
                        String msg = DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs);
                        System.err.println(msg);
                        ConnectivityPlugin.getDefault().log(msg);
                    }
                } else {
                    Object[] strs = new String[]{pluginId};
                    System.err.println(DriverMgmtMessages.format("DriverMgmtPlugin.BundleMissing", strs));
                    ConnectivityPlugin.getDefault().log(DriverMgmtMessages.format("DriverMgmtPlugin.BundleMissing", strs));
                }
                index = ((String)jarList).indexOf(IDriverMgmtConstants.PATH_DELIMITER, index);
                if (index <= 0) continue;
                ++index;
                index = ((String)jarList).indexOf("[", index);
            }
        } else {
            int index = ((String)jarList).indexOf(IDriverMgmtConstants.PATH_DELIMITER, 0);
            if (index > 0) {
                return jarList;
            }
            index = ((String)jarList).indexOf(",", 0);
            if (index > 0) {
                jarList = ((String)jarList).replace(',', IDriverMgmtConstants.PATH_DELIMITER_CHAR);
            } else {
                index = ((String)jarList).indexOf(";", 0);
                if (index > 0) {
                    jarList = ((String)jarList).replace(';', IDriverMgmtConstants.PATH_DELIMITER_CHAR);
                }
            }
        }
        return jarList;
    }

    public static void debug(String msg) {
        if (mDebug) {
            System.out.println("Debug: " + msg);
        }
    }
}

