/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity;

import com.ibm.ims.datatools.connectivity.IConnectionProfile;
import com.ibm.ims.datatools.connectivity.VersionProviderConnection;
import com.ibm.ims.datatools.connectivity.drivers.DriverInstance;
import com.ibm.ims.datatools.connectivity.drivers.DriverManager;
import com.ibm.ims.datatools.connectivity.internal.ConnectivityPlugin;

public abstract class DriverConnectionBase
extends VersionProviderConnection {
    protected DriverInstance mDriver;
    protected Object mConnection;
    protected Throwable mConnectException;

    public DriverConnectionBase(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    public void open() {
        if (this.mConnection != null) {
            this.close();
        }
        this.mConnection = null;
        this.mConnectException = null;
        this.internalCreateConnection();
    }

    @Override
    public Object getRawConnection() {
        return this.mConnection;
    }

    @Override
    public Throwable getConnectException() {
        return this.mConnectException;
    }

    protected abstract Object createConnection(ClassLoader var1) throws Throwable;

    protected abstract void initVersions();

    protected ClassLoader getParentClassLoader() {
        return null;
    }

    private void internalCreateConnection() {
        try {
            DriverInstance driver = this.getDriverDefinition();
            ClassLoader parentCL = this.getParentClassLoader();
            ClassLoader driverCL = parentCL == null ? driver.getClassLoader() : driver.createClassLoader(parentCL);
            this.mConnection = this.createConnection(driverCL);
            if (this.mConnection == null) {
                throw new Exception(ConnectivityPlugin.getDefault().getResourceString("DriverConnectionBase.error.unknown"));
            }
            this.initVersions();
            this.updateVersionCache();
        }
        catch (Throwable t) {
            this.mConnectException = t;
            this.clearVersionCache();
        }
    }

    protected DriverInstance getDriverDefinition() throws Exception {
        if (this.mDriver == null) {
            String driverID = this.getDriverDefinitionId();
            if (driverID == null) {
                String messageId = "DriverConnectionBase.error.driverDefinitionNotSpecified";
                throw new Exception(ConnectivityPlugin.getDefault().getResourceString(messageId), new Throwable(messageId));
            }
            this.mDriver = DriverManager.getInstance().getDriverInstanceByID(driverID);
            if (this.mDriver == null) {
                String messageId = "DriverConnectionBase.error.driverDefinitionNotFound";
                throw new Exception(ConnectivityPlugin.getDefault().getResourceString(messageId), new Throwable(messageId));
            }
        }
        return this.mDriver;
    }

    protected String getDriverDefinitionId() {
        IConnectionProfile profile = this.getConnectionProfile();
        if (profile == null) {
            return null;
        }
        return profile.getBaseProperties().getProperty("com.ibm.ims.datatools.connectivity.driverDefinitionID");
    }
}

