/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual;

import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.ICreationInfoProvider;
import com.ibm.ims.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class CreationInfoRegistry {
    public static CreationInfoRegistry INSTANCE = new CreationInfoRegistry();
    private Map providers = new HashMap();
    private ICreationInfoProvider nullProvider = new ICreationInfoProvider(){

        @Override
        public boolean isCreateActionSupported(IVirtualNode virtualNode) {
            return true;
        }

        @Override
        public boolean isCreateDistinctType() {
            return true;
        }

        @Override
        public boolean isCreateRowTypeSupported() {
            return true;
        }
    };

    public ICreationInfoProvider getProvider(DatabaseDefinition definition) {
        if (!this.providers.containsKey(definition)) {
            this.providers.put(definition, this.loadProvider(definition));
        }
        return (ICreationInfoProvider)this.providers.get(definition);
    }

    private Object loadProvider(DatabaseDefinition def) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.ims.datatools.connectivity.sqm.core.ui", "creationInfoProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String version;
                String product;
                if (configElements[j].getName().equals("provider") && (product = configElements[j].getAttribute("product")).equals(def.getProduct()) && (version = configElements[j].getAttribute("version")).equals(def.getVersion())) {
                    try {
                        return (ICreationInfoProvider)configElements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        return this.nullProvider;
    }
}

