/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.internal.ui.util;

import com.ibm.ims.datatools.connectivity.sqm.core.internal.ui.services.IElementIDProvider;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.resources.IDataResource;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ElementIDUtil {
    public static final ElementIDUtil INSTANCE = new ElementIDUtil();
    public List providerList = new LinkedList();

    private ElementIDUtil() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.ims.datatools.connectivity.sqm.core.ui", "elementID");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("provider")) {
                    try {
                        Object provider = configElements[j].createExecutableExtension("class");
                        this.providerList.add(provider);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public String getElementId(Object current) {
        if (current instanceof EObject) {
            EObject currentEObject = (EObject)current;
            Resource resource = currentEObject.eResource();
            if (resource instanceof IDataResource) {
                return ((IDataResource)resource).getID(currentEObject);
            }
            for (IElementIDProvider provider : this.providerList) {
                String id = provider.getElementID(currentEObject);
                if (id == null) continue;
                return id;
            }
        } else if (current instanceof IResource) {
            return ((IResource)current).getName();
        }
        return null;
    }
}

