/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.internal.ui.explorer.helpers;

import com.ibm.ims.datatools.connectivity.sqm.core.internal.ui.services.IColumnHelperService;
import com.ibm.ims.datatools.connectivity.sqm.core.internal.ui.services.IForeignKeyHelperService;
import com.ibm.ims.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.modelbase.sql.constraints.ForeignKey;
import com.ibm.ims.datatools.modelbase.sql.constraints.UniqueConstraint;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.EAnnotation;

public class ForeignKeyHelper
implements IForeignKeyHelperService {
    private IColumnHelperService columnHelper = IDataToolsUIServiceManager.INSTANCE.getColumnHelperService();

    @Override
    public boolean isIdentifyingConstraint(ForeignKey constraint) {
        EAnnotation eAnnotation = constraint.getEAnnotation(RDBCorePlugin.FK_MODELING_RELATIONSHIP);
        if (eAnnotation != null) {
            return Boolean.valueOf((String)eAnnotation.getDetails().get((Object)RDBCorePlugin.FK_IS_IDENTIFYING_RELATIONSHIP));
        }
        return true;
    }

    @Override
    public boolean isNonIdentifyingConstraint(ForeignKey constraint) {
        return !this.isIdentifyingConstraint(constraint);
    }

    @Override
    public Table getTarget(ForeignKey fk) {
        UniqueConstraint constraint = fk.getUniqueConstraint();
        if (constraint != null) {
            return constraint.getBaseTable();
        }
        if (fk.getUniqueIndex() != null) {
            return fk.getUniqueIndex().getTable();
        }
        return fk.getReferencedTable();
    }
}

