/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.internal.ui.explorer.helpers;

import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import com.ibm.ims.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import com.ibm.ims.datatools.connectivity.sqm.core.internal.ui.services.IColumnHelperService;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.modelbase.sql.constraints.Constraint;
import com.ibm.ims.datatools.modelbase.sql.constraints.ForeignKey;
import com.ibm.ims.datatools.modelbase.sql.constraints.PrimaryKey;
import com.ibm.ims.datatools.modelbase.sql.constraints.ReferenceConstraint;
import com.ibm.ims.datatools.modelbase.sql.datatypes.DataType;
import com.ibm.ims.datatools.modelbase.sql.datatypes.PredefinedDataType;
import com.ibm.ims.datatools.modelbase.sql.schema.Catalog;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.tables.BaseTable;
import com.ibm.ims.datatools.modelbase.sql.tables.Column;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class ColumnHelper
implements IColumnHelperService {
    private DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
    private static final String BLANK = "";

    private ReferenceConstraint[] getConstraints(Column column, Class type) {
        Table parentTable = column.getTable();
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        if (parentTable instanceof BaseTable) {
            EList constraints = ((BaseTable)parentTable).getConstraints();
            for (Constraint constraint : constraints) {
                if (!type.isAssignableFrom(constraint.getClass())) continue;
                list.add(constraint);
            }
        }
        return list.toArray(new ReferenceConstraint[list.size()]);
    }

    private ReferenceConstraint getConstraint(Column column, Class type) {
        ReferenceConstraint[] constraints = this.getConstraints(column, type);
        int i = 0;
        int n = constraints.length;
        while (i < n) {
            Iterator iterator = constraints[i].getMembers().iterator();
            while (iterator.hasNext()) {
                if (!column.equals(iterator.next())) continue;
                return constraints[i];
            }
            ++i;
        }
        return null;
    }

    public Table getParentTableOfForeignKey(Column column) {
        ForeignKey constraint = (ForeignKey)this.getConstraint(column, ForeignKey.class);
        return constraint.getUniqueConstraint().getBaseTable();
    }

    @Override
    public boolean isPrimaryKey(Column column) {
        return this.getConstraint(column, PrimaryKey.class) != null;
    }

    @Override
    public boolean isForeignKey(Column column) {
        return this.getConstraint(column, ForeignKey.class) != null;
    }

    private void removeConstraint(Column column, ReferenceConstraint constraint) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            ((BaseTable)table).getConstraints().remove((Object)constraint);
        }
    }

    @Override
    public String getDataType(Column column) {
        Database database;
        Catalog catalog;
        Schema schema;
        DataType datatype = column.getDataType();
        Table table = column.getTable();
        if (table != null && (schema = table.getSchema()) != null && ((catalog = schema.getCatalog()) != null && (database = catalog.getDatabase()) != null || (database = schema.getDatabase()) != null)) {
            DatabaseDefinition definition = this.dbRegistry.getDefinition(database);
            if (datatype != null && datatype.getName() != null) {
                if (datatype instanceof PredefinedDataType) {
                    return definition.getPredefinedDataTypeFormattedName((PredefinedDataType)datatype);
                }
                return datatype.getName();
            }
        }
        return BLANK;
    }

    @Override
    public void updateConstraintsOnColumnDeleted(Column column) {
        ReferenceConstraint[] constraints = this.getConstraints(column, ReferenceConstraint.class);
        int i = 0;
        int n = constraints.length;
        while (i < n) {
            ReferenceConstraint constraint = constraints[i];
            EList members = constraint.getMembers();
            int j = 0;
            while (j < members.size()) {
                Column currentColumn = (Column)members.get(j);
                if (currentColumn.equals(column)) {
                    members.remove((Object)currentColumn);
                    break;
                }
                ++j;
            }
            if (members.size() == 0) {
                this.removeConstraint(column, constraint);
            }
            ++i;
        }
    }
}

