/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.connectivity.sqm.core.internal.ui.explorer.filter;

import com.ibm.ims.datatools.connectivity.sqm.core.containment.ContainmentService;
import com.ibm.ims.datatools.connectivity.sqm.core.internal.ui.explorer.filter.IFilterNode;
import com.ibm.ims.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import com.ibm.ims.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EObject;

public class FilterUtil {
    private static final ContainmentService containment = RDBCorePlugin.getDefault().getContainmentService();

    private static Database getDatabase(SQLObject sqlObject) {
        while (sqlObject != null && !(sqlObject instanceof Database) && !((sqlObject = (SQLObject)containment.getContainer((EObject)sqlObject)) instanceof Database)) {
        }
        return sqlObject instanceof Database ? (Database)sqlObject : null;
    }

    private static SQLObject getFilterParent(Object parent) {
        while (parent != null && !(parent instanceof SQLObject) && !((parent = ((IVirtualNode)parent).getParent()) instanceof SQLObject)) {
        }
        return parent instanceof SQLObject ? (SQLObject)parent : null;
    }

    public static boolean hasFilter(IFilterNode filterNode) {
        Database database = FilterUtil.getDatabase(FilterUtil.getFilterParent(filterNode));
        ConnectionInfo connectionInfo = database != null ? DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(database) : null;
        return connectionInfo != null && connectionInfo.getFilter(filterNode.getFilterName()) != null;
    }
}

