/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.utils;

import com.ibm.zcc.ws.rd.resource.ResourceUtility;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class AnnotationUtil {
    public static void addGeneratedSourceFolder(IVirtualComponent comp) throws CoreException {
        IResource resource = comp.getRootFolder().getUnderlyingResource();
        IContainer compRoot = resource.getParent();
        AnnotationUtil.addGeneratedSourceFolder(compRoot, comp.getName());
    }

    public static void addGeneratedSourceFolder(IContainer container) throws CoreException {
        AnnotationUtil.addGeneratedSourceFolder(container, null);
    }

    public static void addGeneratedSourceFolder(IContainer container, String compName) throws CoreException {
        IFolder genSrc;
        IFolder gen = container.getFolder((IPath)new Path("/gen"));
        if (AnnotationUtil.createFolders(gen, genSrc = container.getFolder((IPath)new Path("/gen/src")))) {
            AnnotationUtil.updateClasspath(container.getProject(), genSrc.getFullPath(), compName);
        }
    }

    private static boolean createFolders(IFolder gen, IFolder genSrc) throws CoreException {
        boolean created = false;
        if (!gen.exists()) {
            gen.create(false, true, null);
            gen.setDerived(true);
            created = true;
        }
        if (!genSrc.exists()) {
            genSrc.create(false, true, null);
            genSrc.setDerived(true);
            created = true;
        }
        return created;
    }

    private static void updateClasspath(IProject project, IPath genSrcFolder, String compName) throws JavaModelException {
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp.exists()) {
            IClasspathEntry[] originalEntries = jp.getRawClasspath();
            int i = 0;
            while (i < originalEntries.length) {
                if (originalEntries[i].getEntryKind() == 3 && genSrcFolder.equals((Object)originalEntries[i].getPath())) {
                    jp.setRawClasspath(originalEntries, null);
                    return;
                }
                ++i;
            }
            IClasspathEntry genSrcCpEntry = null;
            genSrcCpEntry = compName != null ? JavaCore.newSourceEntry((IPath)genSrcFolder, (IPath[])new IPath[0], (IPath)new Path("/" + project.getName() + "/.deployables/" + compName)) : JavaCore.newSourceEntry((IPath)genSrcFolder, (IPath[])new IPath[0], null);
            IClasspathEntry[] finalEntries = ResourceUtility.getMergedClasspathEntries(originalEntries, new IClasspathEntry[]{genSrcCpEntry});
            jp.setRawClasspath(finalEntries, null);
        }
    }
}

