/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.resource.javautil;

import com.ibm.zcc.ccl.annotations.resource.Messages;
import com.ibm.zcc.ccl.annotations.resource.ResourcePlugin;
import com.ibm.zcc.ws.rd.resource.WRDResourceUtil;
import com.ibm.zcc.ws.rd.resource.javautil.Comment;
import com.ibm.zcc.ws.rd.resource.javautil.DisabledTagSets;
import com.ibm.zcc.ws.rd.resource.javautil.InitialCommentScanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

public class WRDJavaFileUtil {
    public static final WRDJavaFileUtil INST = new WRDJavaFileUtil();

    protected WRDJavaFileUtil() {
    }

    private DisabledTagSets disabledFor(IBuffer buf) {
        String first = buf.getText(0, Math.min(buf.getLength(), 8192));
        InitialCommentScanner ics = new InitialCommentScanner(first.toCharArray());
        DisabledTagSets retval = new DisabledTagSets();
        retval.aboutToParse();
        Comment com = ics.nextComment();
        while (com != null) {
            retval.parseTagsFrom(com.getRawComment(), com.getStart());
            com = ics.nextComment();
        }
        retval.finishedParsing();
        return retval;
    }

    public DisabledTagSets disabledFor(ICompilationUnit icu) {
        try {
            return this.disabledFor(icu.getBuffer());
        }
        catch (JavaModelException e) {
            IStatus status = ResourcePlugin.createStatus(4, 0, NLS.bind((String)Messages.Problem_getting_disabled_tag_set, (Object)icu.getResource().getLocation()), (Exception)((Object)e));
            ResourcePlugin.log(status);
            DisabledTagSets retval = new DisabledTagSets();
            retval.disable("*");
            return retval;
        }
    }

    private void saveDisabledTagSet(IBuffer buf, DisabledTagSets dts, ICompilationUnit cu) throws JavaModelException {
        String dstring = "@annotations-disabled " + dts.getTagAttributes();
        if (dts.hasFirstTagPosition()) {
            buf.replace(dts.getFirstTagPos(), dts.getFirstTagLength(), dstring);
        } else {
            buf.replace(0, 0, "// " + dstring + cu.findRecommendedLineSeparator());
        }
        cu.commitWorkingCopy(true, null);
    }

    public IStatus disableAnnotations(ICompilationUnit cu, String tagSetName, String[] tagSetNames) {
        try {
            IBuffer buf = cu.getBuffer();
            DisabledTagSets dts = this.disabledFor(buf);
            if (dts.allTagsAreDisabled()) {
                return Status.OK_STATUS;
            }
            if (tagSetNames != null) {
                int i = 0;
                while (i < tagSetNames.length && !dts.allTagsAreDisabled()) {
                    dts.disable(tagSetNames[i]);
                    ++i;
                }
            }
            if (tagSetName != null) {
                dts.disable(tagSetName);
            }
            if (!dts.noTagsAreDisabled()) {
                this.saveDisabledTagSet(buf, dts, cu);
            }
            this.unmarkDerivedResources(cu);
            return Status.OK_STATUS;
        }
        catch (JavaModelException e) {
            return new Status(2, "com.ibm.zcc.ccl.annotations.resource", 0, NLS.bind((String)Messages.Problem_while_disabling_annotation, (Object)cu.getResource().getLocation()), (Throwable)e);
        }
    }

    public IStatus disableAnnotations(ICompilationUnit cu) {
        return this.disableAnnotations(cu, "*", null);
    }

    public void unmarkDerivedResources(ICompilationUnit cu) {
        IResource resource = cu.getResource();
        IResource[] derived = WRDResourceUtil.getGeneratedParts(resource);
        int i = 0;
        while (i < derived.length) {
            if (derived[i].getFileExtension() != null && derived[i].getFileExtension().equals("java")) {
                try {
                    derived[i].setDerived(false);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else if (derived[i].getFileExtension() != null) {
                try {
                    derived[i].delete(false, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public boolean isAnnotationEnabled(ICompilationUnit cu) {
        try {
            IBuffer buf = cu.getBuffer();
            DisabledTagSets dts = this.disabledFor(buf);
            return !dts.allTagsAreDisabled();
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }

    public boolean isAnnotationEnabled(IFile javaSource) {
        if (javaSource == null || !javaSource.exists()) {
            return false;
        }
        ICompilationUnit icu = JavaCore.createCompilationUnitFrom((IFile)javaSource);
        if (icu != null) {
            return this.isAnnotationEnabled(icu);
        }
        return false;
    }

    public boolean isAnnotationEnabled(ICompilationUnit cu, String tagSet) {
        try {
            IBuffer buf = cu.getBuffer();
            DisabledTagSets dts = this.disabledFor(buf);
            return !dts.isDisabled(tagSet);
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }

    public boolean anyTagsetsDisabled(ICompilationUnit cu) {
        try {
            IBuffer buf = cu.getBuffer();
            DisabledTagSets dts = this.disabledFor(buf);
            return !dts.noTagsAreDisabled();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean anyTagsetsDisabled(IFile javaSource) {
        if (javaSource == null || !javaSource.exists()) {
            return false;
        }
        ICompilationUnit icu = JavaCore.createCompilationUnitFrom((IFile)javaSource);
        if (icu != null) {
            return this.anyTagsetsDisabled(icu);
        }
        return false;
    }
}

