/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.resource.javautil;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jst.common.internal.annotations.core.AnnotationTagParser;
import org.eclipse.jst.common.internal.annotations.core.TagParseEventHandler;
import org.eclipse.jst.common.internal.annotations.core.Token;

public class DisabledTagSets {
    private static final Set ALL_DISABLED = new HashSet();
    private static final String WILDCARD = "*";
    protected static final String DISABLE_TAG = "annotations-disabled";
    protected static final String TAGSET_ATTR = "tagSet";
    Set disabled;
    ATDParser atParse;
    int fs = -1;
    int fe = -1;

    public boolean allTagsAreDisabled() {
        return this.disabled == ALL_DISABLED;
    }

    public boolean noTagsAreDisabled() {
        return this.disabled == null;
    }

    public void disable(String tagSetName) {
        if (this.allTagsAreDisabled() || tagSetName == null) {
            return;
        }
        if (tagSetName.equals(WILDCARD)) {
            this.disabled = ALL_DISABLED;
            return;
        }
        if (this.disabled == null) {
            this.disabled = new HashSet();
        }
        this.disabled.add(tagSetName.toLowerCase());
    }

    public boolean isDisabled(String tagSetName) {
        if (this.allTagsAreDisabled()) {
            return true;
        }
        if (this.noTagsAreDisabled()) {
            return false;
        }
        if (tagSetName != null) {
            return this.disabled.contains(tagSetName.toLowerCase());
        }
        return false;
    }

    public void aboutToParse() {
        this.atParse = new ATDParser(this);
    }

    public void finishedParsing() {
        this.atParse = null;
    }

    public void parseTagsFrom(char[] commentTxt, int cmtStartPos) {
        if (commentTxt != null && !this.allTagsAreDisabled()) {
            this.atParse.parse(commentTxt, cmtStartPos);
        }
    }

    public boolean hasFirstTagPosition() {
        return this.fs != -1 && this.fe != -1;
    }

    public void setFirstTagPos(int s) {
        this.fs = s;
    }

    public int getFirstTagPos() {
        return this.fs;
    }

    public void setFirstTagEnd(int e) {
        this.fe = e;
    }

    public int getFirstTagEnd() {
        return this.fe;
    }

    public int getFirstTagLength() {
        return this.fe - this.fs;
    }

    public String getTagAttributes() throws IllegalStateException {
        if (this.noTagsAreDisabled()) {
            throw new IllegalStateException("Can not call getTagAttributes() for an empty disabled tag set.");
        }
        if (this.allTagsAreDisabled()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(256);
        Iterator i = this.disabled.iterator();
        while (i.hasNext()) {
            sb.append(TAGSET_ATTR);
            sb.append("=\"");
            sb.append((String)i.next());
            sb.append("\" ");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private class ATDParser
    implements TagParseEventHandler {
        AnnotationTagParser annotationTagParser = new AnnotationTagParser((TagParseEventHandler)this);
        DisabledTagSets parent;
        boolean inDisTag;
        boolean foundTagSet;
        int cmtStart;

        public ATDParser(DisabledTagSets dts) throws IllegalArgumentException {
            if (dts == null) {
                throw new IllegalArgumentException("Null disabled tag set.");
            }
            this.parent = dts;
        }

        public void parse(char[] cmtTxt, int cmtStartPos) {
            this.cmtStart = cmtStartPos;
            this.annotationTagParser.setParserInput(cmtTxt);
            this.annotationTagParser.parse();
        }

        public void annotationTag(Token tag) {
            this.inDisTag = false;
            this.foundTagSet = false;
            if (tag != null && tag.getText().equals(DisabledTagSets.DISABLE_TAG)) {
                this.inDisTag = true;
                if (!this.parent.hasFirstTagPosition()) {
                    this.parent.setFirstTagPos(tag.getBeginning() + this.cmtStart);
                }
            }
        }

        public void endOfTag(int pos) {
            if (this.inDisTag) {
                if (!this.foundTagSet) {
                    this.parent.disable(DisabledTagSets.WILDCARD);
                }
                if (!this.parent.hasFirstTagPosition()) {
                    this.parent.setFirstTagEnd(pos);
                }
            }
        }

        public void attribute(Token name, int equalsPosition, Token value) {
            if (this.inDisTag && equalsPosition != -1 && name.getText().equals(DisabledTagSets.TAGSET_ATTR)) {
                this.foundTagSet = true;
                this.parent.disable(value.getText());
            }
        }
    }
}

