/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.resource;

import com.ibm.zcc.ws.rd.resource.ResourceActionType;
import com.ibm.zcc.ws.rd.resource.WRDDerivedNode;
import com.ibm.zcc.ws.rd.resource.WRDDerivedNodeFactory;
import com.ibm.zcc.ws.rd.resource.WRDResourceAdapter;
import com.ibm.zcc.ws.rd.resource.WRDResourceRegistry;
import com.ibm.zcc.wsspi.rd.resources.IWRDResourceAdapter;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;

public class WRDResourceHelper {
    private WRDResourceHelper() {
    }

    public static void pushToRegistry(IResource key, IResource linkTarget, String destinationPath, ResourceActionType actionType) {
        WRDResourceHelper.pushToRegistry(key, linkTarget, WRDResourceHelper.getAdapter(key), destinationPath, actionType);
    }

    public static void pushToRegistry(IResource key, IResource linkTarget, ResourceActionType actionType) {
        WRDResourceHelper.pushToRegistry(key, linkTarget, WRDResourceHelper.getAdapter(key), null, actionType);
    }

    public static void pushToRegistry(Map m, ResourceActionType actionType) {
        Set s = m.keySet();
        for (IResource resource : s) {
            WRDResourceAdapter adapter = WRDResourceHelper.getAdapter(resource);
            IResource linkTarget = (IResource)m.get(resource);
            WRDResourceHelper.pushToRegistry(resource, linkTarget, adapter, null, actionType);
        }
    }

    private static void pushToRegistry(IResource key, IResource linkTarget, IWRDResourceAdapter adapter, String destinationPath, ResourceActionType actionType) {
        if (adapter == null) {
            return;
        }
        if (actionType.isMappingType()) {
            adapter.addMappedLocation(linkTarget);
        } else if (actionType.isMappingToJarType()) {
            adapter.addJarMappedLocation(destinationPath, linkTarget);
        } else if (actionType.isGenerationType()) {
            adapter.addGeneratedPart(linkTarget);
        }
        WRDDerivedNode dNode = WRDResourceRegistry.getDerivedNode(key);
        if (dNode != null) {
            dNode.setActionType(actionType);
            dNode.setAdapter(adapter);
            return;
        }
        WRDDerivedNode dNewNode = WRDDerivedNodeFactory.createInstance(key, adapter);
        dNewNode.setActionType(actionType);
        WRDResourceRegistry.addDerivedNode(key, dNewNode);
    }

    public static IResource[] getGeneratedParts(IResource resource) {
        WRDDerivedNode dNode = WRDResourceRegistry.getDerivedNode(resource);
        if (dNode != null) {
            return dNode.getAdapter().getGeneratedParts();
        }
        WRDResourceAdapter adapt = WRDResourceHelper.getAdapter(resource);
        if (adapt != null) {
            return adapt.getGeneratedParts();
        }
        return null;
    }

    public static IResource[] getMappedLocations(IResource resource) {
        WRDDerivedNode dNode = WRDResourceRegistry.getDerivedNode(resource);
        if (dNode != null) {
            return dNode.getAdapter().getMappedLocations();
        }
        return new IResource[0];
    }

    public static void removeMappedParts(IResource resource) {
        WRDDerivedNode dNode = WRDResourceRegistry.getDerivedNode(resource);
        if (dNode != null && dNode.getAdapter().removeMappedParts() && !dNode.getAdapter().hasAnyMappings()) {
            WRDResourceRegistry.removeResource(resource);
        }
    }

    public static void removeGeneratedParts(IResource resource) {
        IResource[] genParts = WRDResourceHelper.getGeneratedParts(resource);
        if (genParts != null) {
            int i = 0;
            while (i < genParts.length) {
                WRDResourceHelper.removeGeneratedParts(genParts[i]);
                ++i;
            }
        }
        WRDResourceHelper.doRemovedGeneratedParts(resource);
    }

    private static void doRemovedGeneratedParts(IResource resource) {
        WRDDerivedNode dNode = WRDResourceRegistry.getDerivedNode(resource);
        if (dNode != null && dNode.getAdapter().removeGeneratedParts() && !dNode.getAdapter().hasAnyMappings()) {
            WRDResourceRegistry.removeResource(resource);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static IResource getParentResource(IResource resource, boolean fromRoot) {
        block3: {
            dNode = WRDResourceRegistry.getDerivedNode(resource);
            if (dNode == null) break block3;
            if (fromRoot) ** GOTO lbl8
            parentNode = dNode.getParent();
            if (parentNode == null) break block3;
            return parentNode.getResource();
lbl-1000:
            // 1 sources

            {
                dNode = par;
lbl8:
                // 2 sources

                ** while ((par = dNode.getParent()) != null)
            }
lbl9:
            // 1 sources

            return dNode.getResource();
        }
        return null;
    }

    public static void setParentResource(IResource child, IResource parent) {
        WRDDerivedNode dNode = WRDResourceRegistry.getDerivedNode(child);
        if (dNode != null) {
            dNode.setParent(WRDResourceRegistry.getDerivedNode(parent));
        } else {
            WRDDerivedNode newNode = WRDDerivedNodeFactory.createInstance(child, WRDResourceHelper.getAdapter(child));
            WRDDerivedNode parentNode = WRDResourceRegistry.getDerivedNode(parent);
            if (parentNode != null) {
                newNode.setParent(parentNode);
                newNode.setActionType(parentNode.getActionType());
            }
            WRDResourceRegistry.addDerivedNode(child, newNode);
        }
    }

    private static WRDResourceAdapter getAdapter(IResource resource) {
        Object o = resource.getAdapter(IWRDResourceAdapter.class);
        if (o != null) {
            return (WRDResourceAdapter)o;
        }
        return WRDResourceAdapter.getWRDResourceAdapter(resource);
    }

    public static void removeCachedGeneratedPart(IResource generatedResource) {
        if (generatedResource == null) {
            return;
        }
        WRDDerivedNode node = WRDResourceRegistry.getDerivedNode(generatedResource);
        if (node != null) {
            IWRDResourceAdapter adapter;
            WRDDerivedNode parentNode = node.getParent();
            if (parentNode != null && (adapter = parentNode.getAdapter()).removeCachedGeneratedPart(generatedResource) && !adapter.hasAnyMappings() && !WRDResourceRegistry.removeResource(parentNode.getResource())) {
                parentNode.discard();
            }
            if (!node.getAdapter().hasAnyMappings()) {
                WRDResourceRegistry.removeResource(generatedResource);
            }
        }
    }
}

