/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.resource;

import com.ibm.zcc.ccl.annotations.resource.Messages;
import com.ibm.zcc.ccl.annotations.resource.ResourcePlugin;
import com.ibm.zcc.ws.rd.resource.WRDResourceAdapter;
import com.ibm.zcc.ws.rd.resource.WRDResourceUtil;
import com.ibm.zcc.ws.rd.save.ISaveComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WRDResourceAdapterSaveParticipant
implements ISaveComponent {
    private static final String MAPFILE_BASE = "resource.maps";
    private static final String GENFILE_BASE = "resource.gens";
    private static final String JARFILE_BASE = "resource.jar.loc";
    private static final int ADD_MAP_LINK = 0;
    private static final int ADD_GEN_LINK = 1;
    private static final int ADD_JAR_LINK = 2;
    private static final String id = "resourceadapter";

    @Override
    public String getID() {
        return id;
    }

    @Override
    public void load(ISavedState state) {
        if (state != null) {
            String mapsFileName = MAPFILE_BASE + Integer.toString(state.getSaveNumber());
            File mapsFile = ResourcePlugin.getDefault().getStateLocation().append(mapsFileName).toFile();
            String genFileName = GENFILE_BASE + Integer.toString(state.getSaveNumber());
            File genFile = ResourcePlugin.getDefault().getStateLocation().append(genFileName).toFile();
            String jarsFileName = JARFILE_BASE + Integer.toString(state.getSaveNumber());
            File jarsFile = ResourcePlugin.getDefault().getStateLocation().append(jarsFileName).toFile();
            this.retrieveFromFile(mapsFile, 0);
            this.retrieveFromFile(genFile, 1);
            this.retrieveFromFile(jarsFile, 2);
        }
    }

    public void retrieveFromFile(File file, int loadType) {
        Properties p = new Properties();
        try {
            if (file.exists()) {
                p.load(new FileInputStream(file));
                WRDResourceAdapterSaveParticipant.doLoad(p, loadType);
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static void doLoad(Properties maps, int type) {
        Set<Object> keySet = maps.keySet();
        for (String string : keySet) {
            String aValue = maps.getProperty(string);
            StringTokenizer tokenizer = new StringTokenizer(aValue, ";");
            IFile fileKey = WRDResourceAdapterSaveParticipant.getFile((IPath)new Path(string));
            if (fileKey == null || !fileKey.exists()) continue;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Path path = new Path(token);
                try {
                    switch (type) {
                        case 0: {
                            WRDResourceAdapterSaveParticipant.regenerateMapLinks(fileKey, (IPath)path);
                            break;
                        }
                        case 1: {
                            WRDResourceAdapterSaveParticipant.regenerateGenLinks(fileKey, (IPath)path);
                            break;
                        }
                        case 2: {
                            WRDResourceAdapterSaveParticipant.regenerateJarLinks(tokenizer, fileKey, (IPath)path);
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    private static void regenerateJarLinks(StringTokenizer tokenizer, IFile resource, IPath token) {
        IFile jarFile = WRDResourceAdapterSaveParticipant.getFile(token);
        if (jarFile != null && tokenizer.hasMoreTokens()) {
            String jarPath = tokenizer.nextToken();
            WRDResourceUtil.linkMappedLocationToJar((IResource)resource, jarPath, (IResource)jarFile);
        }
    }

    private static void regenerateGenLinks(IFile fileKey, IPath token) {
        IFile fileValue = WRDResourceAdapterSaveParticipant.getFile(token);
        if (fileValue != null && fileValue.exists()) {
            WRDResourceUtil.linkGeneratedPart((IResource)fileKey, (IResource)fileValue);
        } else {
            IContainer container = WRDResourceAdapterSaveParticipant.getContainer(token);
            if (container != null && container.exists()) {
                WRDResourceUtil.linkGeneratedPart((IResource)fileKey, (IResource)container);
            }
        }
    }

    private static void regenerateMapLinks(IFile fileKey, IPath token) {
        IFile fileValue = WRDResourceAdapterSaveParticipant.getFile(token);
        if (fileValue != null && fileValue.exists()) {
            WRDResourceUtil.linkMappedLocation((IResource)fileKey, (IResource)fileValue);
        }
    }

    private static IFile getFile(IPath path) {
        if (path.segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return null;
    }

    private static IContainer getContainer(IPath path) {
        if (path.getFileExtension() == null) {
            return ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        }
        return null;
    }

    public void doneSaving(ISaveContext context) {
        String mapsFileName = MAPFILE_BASE + Integer.toString(context.getPreviousSaveNumber());
        File mapsFile = ResourcePlugin.getDefault().getStateLocation().append(mapsFileName).toFile();
        mapsFile.delete();
        String gensFileName = GENFILE_BASE + Integer.toString(context.getPreviousSaveNumber());
        File gensFile = ResourcePlugin.getDefault().getStateLocation().append(gensFileName).toFile();
        gensFile.delete();
        String jarsFileName = JARFILE_BASE + Integer.toString(context.getPreviousSaveNumber());
        File jarsFile = ResourcePlugin.getDefault().getStateLocation().append(jarsFileName).toFile();
        jarsFile.delete();
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        if (context.getKind() != 1) {
            return;
        }
        String mapsFileName = MAPFILE_BASE + Integer.toString(context.getSaveNumber());
        File mapsFile = ResourcePlugin.getDefault().getStateLocation().append(mapsFileName).toFile();
        String genFileName = GENFILE_BASE + Integer.toString(context.getSaveNumber());
        File genFile = ResourcePlugin.getDefault().getStateLocation().append(genFileName).toFile();
        String jarLocFileName = JARFILE_BASE + Integer.toString(context.getSaveNumber());
        File jarLocFile = ResourcePlugin.getDefault().getStateLocation().append(jarLocFileName).toFile();
        FileOutputStream osMaps = null;
        FileOutputStream osGens = null;
        OutputStream osJars = null;
        try {
            try {
                osMaps = new FileOutputStream(mapsFile);
                osGens = new FileOutputStream(genFile);
                osJars = new FileOutputStream(jarLocFile);
                this.traverseAdapters(osMaps, osGens, (FileOutputStream)osJars);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                context.needSaveNumber();
                try {
                    if (osMaps != null) {
                        osMaps.flush();
                        osMaps.close();
                    }
                    if (osGens != null) {
                        osGens.flush();
                        osGens.close();
                    }
                    if (osJars != null) {
                        osJars.flush();
                        ((FileOutputStream)osJars).close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            context.needSaveNumber();
            try {
                if (osMaps != null) {
                    osMaps.flush();
                    osMaps.close();
                }
                if (osGens != null) {
                    osGens.flush();
                    osGens.close();
                }
                if (osJars != null) {
                    osJars.flush();
                    ((FileOutputStream)osJars).close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void traverseAdapters(FileOutputStream osMaps, FileOutputStream osGens, FileOutputStream osJars) {
        Collection adapters = WRDResourceAdapter.getAdapters();
        Iterator i = adapters.iterator();
        Properties mapProps = new Properties();
        Properties genProps = new Properties();
        Properties jarProps = new Properties();
        while (i.hasNext()) {
            String[][] jarMaps;
            WRDResourceAdapter adapter = (WRDResourceAdapter)i.next();
            String key = adapter.getResource().getFullPath().toOSString();
            IResource[] mappedParts = adapter.getMappedLocations();
            String mapValue = new String();
            int j = 0;
            while (j < mappedParts.length) {
                String resourcePath = mappedParts[j].getFullPath().toOSString();
                mapValue = String.valueOf(mapValue) + resourcePath;
                if (j + 1 != mappedParts.length) {
                    mapValue = String.valueOf(mapValue) + ";";
                }
                ++j;
            }
            if (adapter.getMappedLocations().length > 0) {
                mapProps.put(key, mapValue);
            }
            IResource[] generatedParts = adapter.getGeneratedParts();
            String genValue = new String();
            int j2 = 0;
            while (j2 < generatedParts.length) {
                String resourcePath = generatedParts[j2].getFullPath().toOSString();
                genValue = String.valueOf(genValue) + resourcePath;
                if (j2 + 1 != generatedParts.length) {
                    genValue = String.valueOf(genValue) + ";";
                }
                ++j2;
            }
            if (adapter.getGeneratedParts().length > 0) {
                genProps.put(key, genValue);
            }
            if ((jarMaps = adapter.getJarMappedLocations()) == null) continue;
            int j3 = 0;
            while (j3 < jarMaps.length) {
                String id1 = adapter.getResource().getFullPath().toOSString();
                String id2 = jarMaps[j3][1];
                String id3 = jarMaps[j3][0];
                jarProps.put(id1, String.valueOf(id2) + ";" + id3);
                ++j3;
            }
        }
        try {
            mapProps.store(osMaps, Messages.WRDResourceAdapterSaveParticipant_Resource_Mappings);
            genProps.store(osGens, Messages.WRDResourceAdapterSaveParticipant_Resource_Generations);
            jarProps.store(osJars, Messages.WRDResourceAdapterSaveParticipant_Jar_Mappings);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

