/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class ResourceUtility {
    public static IPath[] getSourceFolderEntries(IJavaProject javaProject) throws JavaModelException {
        ArrayList<IPath> sourceEntries = new ArrayList<IPath>();
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3) {
                sourceEntries.add(entries[i].getPath());
            }
            ++i;
        }
        return sourceEntries.toArray(new IPath[sourceEntries.size()]);
    }

    private static boolean doesContainEntry(List l, IClasspathEntry c) {
        int i = 0;
        while (i < l.size()) {
            IClasspathEntry cpe = (IClasspathEntry)l.get(i);
            if (cpe.getPath().toOSString().equals(c.getPath().toOSString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IClasspathEntry[] getMergedClasspathEntries(IClasspathEntry[] oldEntries, IClasspathEntry[] newEntries) {
        IClasspathEntry cpEntry;
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        int j = 0;
        while (j < oldEntries.length) {
            cpEntry = oldEntries[j];
            if (!ResourceUtility.doesContainEntry(result, cpEntry)) {
                result.add(cpEntry);
            }
            ++j;
        }
        int i = 0;
        while (i < newEntries.length) {
            cpEntry = newEntries[i];
            if (cpEntry.getExclusionPatterns().length > 0) {
                ResourceUtility.replaceExistingClasspathEntry(result, cpEntry);
            }
            if (!ResourceUtility.doesContainEntry(result, cpEntry)) {
                result.add(cpEntry);
            }
            ++i;
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    private static void replaceExistingClasspathEntry(List container, IClasspathEntry cpEntry) {
        IClasspathEntry removeCandidate = null;
        int i = 0;
        while (i < container.size()) {
            IClasspathEntry entry = (IClasspathEntry)container.get(i);
            if (entry.getPath().toOSString().equals(cpEntry.getPath().toOSString())) {
                removeCandidate = entry;
                break;
            }
            ++i;
        }
        if (removeCandidate != null) {
            container.remove(removeCandidate);
            container.add(cpEntry);
        }
    }
}

