/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.io.services;

import com.ibm.zcc.ccl.annotations.resource.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.eclipse.core.resources.IFile;

public class JARUtil {
    public static final int TRANSFER_BUFFER_SIZE = 32768;
    protected static Vector transferBuffers = new Vector();
    protected static Vector availableBuffers = new Vector();

    public static void removeFileFromJar(IFile filename, String pathToFile, IFile jarname) {
        String fn = filename.getLocation().toOSString();
        String jn = jarname.getLocation().toOSString();
        JARUtil.removeFileFromJar(fn, pathToFile, jn);
    }

    public static void removeFileFromJar(String filename, String pathToFile, String jarname) {
        filename = JARUtil.convertFileSeparators(filename);
        jarname = JARUtil.convertFileSeparators(jarname);
        pathToFile = JARUtil.convertFileSeparators(pathToFile);
        pathToFile = JARUtil.endWithFileSeparator(pathToFile);
        JarEntry jarentry = null;
        if (filename.equals(jarname)) {
            return;
        }
        jarentry = pathToFile != null ? new JarEntry(String.valueOf(pathToFile) + new File(filename).getName()) : new JarEntry(filename);
        FileInputStream outputJarFile = JARUtil.openFileToRead(jarname);
        if (outputJarFile == null) {
            return;
        }
        try {
            boolean found = false;
            FileOutputStream tempJarStream = new FileOutputStream(String.valueOf(jarname) + ".tmp");
            JarInputStream jarInputStream = JARUtil.openJar(outputJarFile);
            JarOutputStream tempJarOutputStream = new JarOutputStream((OutputStream)tempJarStream, jarInputStream.getManifest());
            JarEntry current = JARUtil.getNext(jarInputStream);
            while (current != null) {
                if (current.getName().equals(jarentry.getName())) {
                    found = true;
                } else {
                    JARUtil.putNext(tempJarOutputStream, current);
                    JARUtil.baseTransfer(Messages.Jar_Current, jarInputStream, Messages.Temp_Jar_File, tempJarOutputStream);
                    tempJarOutputStream.closeEntry();
                }
                current = JARUtil.getNext(jarInputStream);
            }
            tempJarOutputStream.close();
            jarInputStream.close();
            tempJarStream.close();
            File outdated = new File(jarname);
            outdated.delete();
            File temp = new File(String.valueOf(jarname) + ".tmp");
            temp.renameTo(outdated);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static JarInputStream openJar(InputStream input) {
        try {
            return new JarInputStream(input);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static JarEntry getNext(JarInputStream jarInput) {
        try {
            return jarInput.getNextJarEntry();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void putNext(JarOutputStream jarOutput, JarEntry entry) {
        try {
            jarOutput.putNextEntry(entry);
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] allocateBuffer() {
        byte[] buffer;
        Vector vector = availableBuffers;
        synchronized (vector) {
            if (availableBuffers.size() == 0) {
                buffer = new byte[32768];
                transferBuffers.add(buffer);
            } else {
                buffer = (byte[])availableBuffers.elementAt(0);
                availableBuffers.removeElementAt(0);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void releaseBuffer(byte[] buffer) {
        Vector vector = availableBuffers;
        synchronized (vector) {
            if (transferBuffers.contains(buffer)) {
                availableBuffers.addElement(buffer);
            } else {
                System.out.println(Messages.Jar_Force_Discard);
            }
        }
    }

    private static long baseTransfer(String inputPath, InputStream input, String outputPath, OutputStream output) {
        byte[] transferBuffer = JARUtil.allocateBuffer();
        long totRead = 0L;
        try {
            boolean keepReading = true;
            while (keepReading) {
                int bytesRead = 0;
                try {
                    bytesRead = input.read(transferBuffer);
                }
                catch (IOException iOException) {}
                if (bytesRead > 0) {
                    totRead += (long)bytesRead;
                    try {
                        output.write(transferBuffer, 0, bytesRead);
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                keepReading = false;
            }
        }
        finally {
            byte[] useBuffer = transferBuffer;
            transferBuffer = null;
            JARUtil.releaseBuffer(useBuffer);
        }
        return totRead;
    }

    private static String convertFileSeparators(String fileName) {
        return fileName.replace(File.separatorChar, '/');
    }

    private static String endWithFileSeparator(String fileName) {
        if (!fileName.endsWith("/")) {
            fileName = String.valueOf(fileName) + "/";
        }
        return fileName;
    }

    private static FileInputStream openFileToRead(String fileName) {
        try {
            return new FileInputStream(fileName);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

