/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.parsers.sql;

import com.ibm.ims.datatools.modelbase.sql.query.CallStatement;
import com.ibm.ims.datatools.modelbase.sql.query.QueryStatement;
import com.ibm.ims.datatools.modelbase.sql.query.SQLQueryObject;
import com.ibm.ims.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import com.ibm.ims.datatools.modelbase.sql.statements.SQLStatement;
import com.ibm.ims.datatools.sqltools.parsers.sql.AbstractSQLParser;
import com.ibm.ims.datatools.sqltools.parsers.sql.SQLParseErrorInfo;
import com.ibm.ims.datatools.sqltools.parsers.sql.SQLParseResult;
import com.ibm.ims.datatools.sqltools.parsers.sql.SQLParser;
import com.ibm.ims.datatools.sqltools.parsers.sql.SQLParserException;
import com.ibm.ims.datatools.sqltools.parsers.sql.SQLParserInternalException;
import com.ibm.ims.datatools.sqltools.parsers.sql.lexer.AbstractSQLLexer;
import com.ibm.ims.datatools.sqltools.parsers.sql.lexer.SQLCharacterKindMap;
import com.ibm.ims.datatools.sqltools.parsers.sql.postparse.PostParseProcessor;
import com.ibm.ims.datatools.sqltools.parsers.sql.postparse.PostParseProcessorConfiguration;
import com.ibm.ims.datatools.sqltools.parsers.sql.util.EObjectPrinter;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.emf.ecore.EObject;

public abstract class SQLParserManager {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public int statementCount = 0;
    public int astElementCount = 0;
    public int byteCount = 0;
    public int timeCount = 0;
    boolean debug = false;
    public boolean debugPerformance = false;
    private SQLQuerySourceFormat sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
    private List postParseProcessors = this.getInternalDefaultPostParseProcessorList();
    public static final int ERROR_DIAGNOSING_NONE = 0;
    public static final int ERROR_DIAGNOSING_UNLIMITED = Integer.MAX_VALUE;
    public static final int ERROR_DIAGNOSING_TIME_MAX_DEFAULT = 1500;
    public static final int ERROR_DIAGNOSING_NUMBER_MAX_DEFAULT = 5;
    private int errorDiagnosingTimeMax = 1500;
    private int errorDiagnosingNumberMax = 5;
    private SQLCharacterKindMap characterKindMap = new SQLCharacterKindMap();
    protected AbstractSQLLexer lexer = null;
    protected AbstractSQLParser parser = null;
    public EObjectPrinter PRINTER = new EObjectPrinter();
    private long timeBeforeLexerInit;
    private long timeBeforeParserInit;
    private long timeParserInit;
    private long timeLexerInit;
    private long timeAfterParserInit;
    private long timeAfterLexerInit;
    private long timeBeforeLexing;
    private long timeAfterLexing;
    private long timeLexing;
    private long timeBeforeParsing;
    private long timeAfterParsing;
    private long timeParsing;

    public abstract List getDefaultPostParseProcessorList();

    public abstract List copyDefaultPostParseProcessorList();

    protected abstract List getInternalDefaultPostParseProcessorList();

    protected void setCharacterKindMap(SQLCharacterKindMap characterKindMap) {
        if (characterKindMap == null) {
            characterKindMap = new SQLCharacterKindMap();
        }
        this.characterKindMap = characterKindMap;
        this.setupCharacterKindMap(this.getSourceFormat());
    }

    protected SQLCharacterKindMap getCharacterKindMap() {
        if (this.characterKindMap == null) {
            this.setCharacterKindMap(new SQLCharacterKindMap());
        }
        return this.characterKindMap;
    }

    protected final void setVariableCharacterKind(char character, int charKind) {
        this.getCharacterKindMap().setTokenKind((int)character, charKind);
    }

    protected void setupCharacterKindMap(SQLQuerySourceFormat p_format) {
        this.setVariableCharacterKind(p_format.getStatementTerminator(), 78);
        this.setVariableCharacterKind(p_format.getHostVariablePrefix(), 60);
        this.setVariableCharacterKind(p_format.getParameterMarker(), 59);
        this.setVariableCharacterKind(p_format.getDelimitedIdentifierQuote(), 48);
    }

    public final List getPostParseProcessors() {
        if (this.postParseProcessors == this.getInternalDefaultPostParseProcessorList()) {
            return null;
        }
        return this.postParseProcessors;
    }

    public final void setPostParseProcessors(List postParseProcessors) {
        if (postParseProcessors == null || postParseProcessors.size() == 0) {
            postParseProcessors = this.getInternalDefaultPostParseProcessorList();
        }
        this.postParseProcessors = postParseProcessors;
    }

    public SQLQuerySourceFormat getSourceFormat() {
        if (this.sourceFormat == SQLQuerySourceFormat.SQL_SOURCE_FORMAT_DEFAULT || this.sourceFormat == null) {
            this.sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
        }
        return this.sourceFormat;
    }

    public void setSourceFormat(SQLQuerySourceFormat sourceFormat) {
        if (sourceFormat == SQLQuerySourceFormat.SQL_SOURCE_FORMAT_DEFAULT || sourceFormat == null) {
            sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
        }
        this.sourceFormat = sourceFormat;
        this.setupCharacterKindMap(sourceFormat);
    }

    public void configParser(SQLQuerySourceFormat sourceFormat, List postParseProcessors) {
        this.setSourceFormat(sourceFormat);
        this.setPostParseProcessors(postParseProcessors);
    }

    public void configPostParseProcessors(PostParseProcessorConfiguration config) {
        if (this.postParseProcessors == null || this.postParseProcessors == this.getInternalDefaultPostParseProcessorList()) {
            this.setPostParseProcessors(this.copyDefaultPostParseProcessorList());
        }
        List p3s = this.getPostParseProcessors();
        for (PostParseProcessor p3 : p3s) {
            p3.config(config);
        }
    }

    protected abstract SQLParser createParser(AbstractSQLLexer var1, boolean var2) throws SQLParserInternalException;

    protected abstract AbstractSQLLexer createLexer(String var1);

    protected abstract SQLParseResult createParseResult(SQLStatement var1, List var2);

    protected abstract SQLParseResult createControlParseResult(SQLStatement var1, List var2);

    public SQLParserManager() {
        this.configParser(SQLQuerySourceFormat.copyDefaultFormat(), this.getInternalDefaultPostParseProcessorList());
    }

    public SQLParserManager(SQLQuerySourceFormat sourceFormat, List postParseProcessors) {
        this.configParser(sourceFormat, postParseProcessors);
    }

    protected AbstractSQLLexer getLexer(String input) {
        this.lexer = this.createLexer(input);
        return this.lexer;
    }

    protected AbstractSQLParser getParser(AbstractSQLLexer lexer, boolean syntaxCheckOnly) throws SQLParserInternalException {
        if (this.parser == null) {
            this.parser = this.createParser(lexer, syntaxCheckOnly);
        } else {
            this.parser.resetParser((LexStream)lexer);
            this.parser.setCheckStmtOnly(syntaxCheckOnly);
        }
        return this.parser;
    }

    protected synchronized List makeAST(String input, boolean syntaxCheckOnly) throws SQLParserException, SQLParserInternalException {
        List resultList = new ArrayList();
        if (input == null || input.trim().length() == 0) {
            return resultList;
        }
        input = input.concat(String.valueOf(this.sourceFormat.getStatementTerminator()));
        if (this.debugPerformance) {
            this.timeBeforeLexerInit = System.currentTimeMillis();
        }
        AbstractSQLLexer lexer = this.getLexer(input);
        if (this.debugPerformance) {
            this.timeAfterLexerInit = System.currentTimeMillis();
        }
        if (this.debugPerformance) {
            this.timeBeforeParserInit = this.timeAfterLexerInit;
        }
        AbstractSQLParser sqlmodelParser = this.getParser(lexer, syntaxCheckOnly);
        if (this.debugPerformance) {
            this.timeAfterParserInit = System.currentTimeMillis();
        }
        if (this.debugPerformance) {
            this.timeLexerInit = this.timeBeforeParserInit - this.timeBeforeLexerInit;
            this.timeParserInit = this.timeAfterParserInit - this.timeBeforeParserInit;
            System.out.println("[init time Lexer: " + this.timeLexerInit + ", Parser: " + this.timeParserInit + "]");
        }
        this.byteCount += input.length();
        sqlmodelParser.setErrorDiagnosingTimeMax(this.getErrorDiagnosingTimeMax());
        sqlmodelParser.setErrorDiagnosingNumberMax(this.getErrorDiagnosingNumberMax());
        try {
            this.timeBeforeLexing = this.timeAfterParserInit;
            lexer.lexer((PrsStream)sqlmodelParser);
            if (this.debug) {
                this.parser.dumpTokens();
            }
            if (this.debugPerformance) {
                this.timeAfterLexing = System.currentTimeMillis();
            }
            if (this.debugPerformance) {
                this.timeLexing = this.timeAfterLexing - this.timeBeforeLexing;
            }
            if (this.debugPerformance) {
                this.timeBeforeParsing = this.timeAfterLexing;
            }
            List script = sqlmodelParser.parser();
            long time = 0L;
            if (this.debugPerformance) {
                this.timeAfterParsing = System.currentTimeMillis();
                this.timeParsing = this.timeAfterParsing - this.timeBeforeParsing;
                System.out.println("[time lexing: " + this.timeLexing + ", parsing: " + this.timeParsing + ", input size (byte): " + input.length() + "]");
                time = this.timeAfterParsing - this.timeBeforeLexing;
                this.timeCount = (int)((long)this.timeCount + time);
                this.statementCount += script.size();
            }
            if (this.debug) {
                logger.info("Successful parse of:                                            " + (String)(this.debugPerformance ? "(" + time + "ms)" : ""), new Object[0]);
                if (script != null) {
                    this.printAST(script);
                }
            }
            resultList = script;
            if (syntaxCheckOnly) {
                return script;
            }
            List queryElements = sqlmodelParser.getASTElementList();
            this.astElementCount += queryElements.size();
            if (this.postParseProcessors != null) {
                try {
                    resultList = this.executePostParseProcessorList(script, queryElements, this.postParseProcessors);
                }
                catch (Exception e1) {
                    if (this.postParseProcessors != this.getInternalDefaultPostParseProcessorList()) {
                        if (e1 instanceof SQLParserException) {
                            throw (SQLParserException)e1;
                        }
                        e1.printStackTrace();
                    }
                    resultList = this.wrapQueryStmtListInParseResults(script);
                }
            }
            return resultList;
        }
        catch (Exception e) {
            if (e instanceof SQLParserException) {
                throw (SQLParserException)e;
            }
            if (e instanceof SQLParserInternalException) {
                throw (SQLParserInternalException)e;
            }
            SQLParserInternalException pre = new SQLParserInternalException();
            pre.initCause(e);
            throw pre;
        }
    }

    private List wrapQueryStmtListInParseResults(List script) {
        ArrayList<SQLParseResult> resultList = new ArrayList<SQLParseResult>();
        if (script != null) {
            for (SQLStatement stmt : script) {
                SQLParseResult parseResult = null;
                if (stmt instanceof QueryStatement) {
                    parseResult = this.createParseResult(stmt, null);
                } else if (stmt instanceof CallStatement) {
                    parseResult = this.createControlParseResult(stmt, null);
                }
                if (parseResult == null) continue;
                resultList.add(parseResult);
            }
        }
        return resultList;
    }

    private List executePostParseProcessorList(List queryStmtList, List queryElements, List postParseProcessors) throws SQLParserException {
        ArrayList<SQLParseResult> parseResultList = new ArrayList<SQLParseResult>();
        if (postParseProcessors != null) {
            for (SQLQueryObject queryStmt : queryStmtList) {
                List errorList = this.postParseProcess(queryStmt, queryElements, postParseProcessors);
                if (postParseProcessors == this.getInternalDefaultPostParseProcessorList()) {
                    errorList = null;
                }
                if (queryStmt instanceof QueryStatement) {
                    parseResultList.add(this.createParseResult((SQLStatement)((QueryStatement)queryStmt), errorList));
                    continue;
                }
                if (!(queryStmt instanceof CallStatement)) continue;
                parseResultList.add(this.createControlParseResult((SQLStatement)((CallStatement)queryStmt), errorList));
            }
        }
        return parseResultList;
    }

    private List postParseProcess(SQLQueryObject queryStatement, List queryElements, List postParseProcessors) throws SQLParserException {
        ArrayList errorList = new ArrayList();
        Iterator processIt = postParseProcessors.iterator();
        while (processIt.hasNext()) {
            Map queryElemSubstMap;
            PostParseProcessor ppp = (PostParseProcessor)processIt.next();
            boolean isLastProcessor = !processIt.hasNext();
            Iterator queryIt = queryElements.iterator();
            while (queryIt.hasNext()) {
                List elementErrors;
                SQLQueryObject queryObject;
                Object queryElement = queryIt.next();
                if (queryElement instanceof SQLQueryObject && this.isPostParseCandidate(queryObject = (SQLQueryObject)queryElement, ppp) && (elementErrors = ppp.process(queryObject)) != null) {
                    errorList.addAll(elementErrors);
                }
                if (isLastProcessor) {
                    queryIt.remove();
                }
                if (queryElement == queryStatement) break;
            }
            if ((queryElemSubstMap = ppp.getParsedObjectsReplacementMap()) != null) {
                Set elementsToSubstituteMappings = queryElemSubstMap.entrySet();
                for (Map.Entry elementToSubstitute : elementsToSubstituteMappings) {
                    Object oldElement = elementToSubstitute.getKey();
                    Object substitute = elementToSubstitute.getValue();
                    Collections.replaceAll(queryElements, oldElement, substitute);
                }
            }
            ppp.resetState();
        }
        return errorList;
    }

    private boolean isPostParseCandidate(Object queryElement, PostParseProcessor ppp) {
        boolean isCandidate = false;
        Class[] candidateTypes = ppp.getProcessCandidateTypes();
        int i = 0;
        while (i < candidateTypes.length) {
            Class candidate = candidateTypes[i];
            isCandidate = candidate.isAssignableFrom(queryElement.getClass());
            if (isCandidate) break;
            ++i;
        }
        return isCandidate;
    }

    public SQLParseResult parse(String stmt) throws SQLParserException, SQLParserInternalException {
        List resultList = null;
        resultList = this.makeAST(stmt, false);
        if (resultList.isEmpty()) {
            return null;
        }
        return (SQLParseResult)resultList.get(0);
    }

    public List parseScript(String script) throws SQLParserException, SQLParserInternalException {
        return this.makeAST(script, false);
    }

    public QueryStatement checkSyntax(String stmt) throws SQLParserException, SQLParserInternalException {
        List resultsList = this.makeAST(stmt, true);
        if (resultsList.isEmpty()) {
            return null;
        }
        return (QueryStatement)resultsList.get(0);
    }

    public List checkSyntaxScript(String script) throws SQLParserException, SQLParserInternalException {
        return this.makeAST(script, true);
    }

    public int getErrorDiagnosingNumberMax() {
        return this.errorDiagnosingNumberMax;
    }

    public void setErrorDiagnosingNumberMax(int errorDiagnosingNumberMax) {
        this.errorDiagnosingNumberMax = errorDiagnosingNumberMax;
    }

    public int getErrorDiagnosingTimeMax() {
        return this.errorDiagnosingTimeMax;
    }

    public void setErrorDiagnosingTimeMax(int errorDiagnosingTimeMax) {
        this.errorDiagnosingTimeMax = errorDiagnosingTimeMax;
    }

    public void printParseRuntimeException(SQLParserException e1) {
        e1.printParseRuntimeException();
    }

    public void printErrorList(SQLParseResult parseResult) {
        if (parseResult == null) {
            return;
        }
        List errorList = parseResult.getErrorList();
        SQLStatement sqlStmt = parseResult.getSQLStatement();
        if (errorList == null || errorList.isEmpty()) {
            return;
        }
        logger.error("Errors encountered during post parse processing of statement:", new Object[0]);
        logger.error(sqlStmt.getSQL(), new Object[0]);
        for (SQLParseErrorInfo errorInfo : errorList) {
            logger.error("   " + errorInfo.getParserErrorMessage() + " at line:column " + errorInfo.getLineNumberStart() + ":" + errorInfo.getColumnNumberStart() + " to line:column " + errorInfo.getLineNumberEnd() + ":" + errorInfo.getColumnNumberEnd() + " \"" + errorInfo.getErrorSourceText() + "\", expected: \"" + errorInfo.getExpectedText() + "\"", new Object[0]);
        }
    }

    public void printAST(List sqlStmts) {
        new StringBuffer();
        int i = 0;
        for (SQLStatement next : sqlStmts) {
            logger.info("\nStatement " + i + ": " + next.getSQL(), new Object[0]);
            this.printAST(next);
            ++i;
        }
    }

    public void printAST(SQLStatement p_Stmt) {
        this.PRINTER.printEObjectReferenceTree((EObject)p_Stmt);
    }

    public void printSQL(List sqlQueryStmts) {
        new StringBuffer();
        int i = 0;
        for (SQLQueryObject next : sqlQueryStmts) {
            logger.info("\n" + next.getClass().getName() + " " + i + ":\n" + next.getSQL(), new Object[0]);
            ++i;
        }
    }
}

