/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.properties.wrapper;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.properties.wrapper.BaseParent;
import com.ibm.adapter.emd.properties.wrapper.NodePropertyWrapper;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.ITreeProperty;
import com.ibm.propertygroup.spi.PropertyChangeSupport;
import commonj.connector.metadata.discovery.properties.NodeProperty;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.TreeProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TreePropertyWrapper
extends BaseParent
implements ITreeProperty,
PropertyChangeListener {
    protected TreeProperty emdProperty;
    protected NodeProperty emdRoot_ = null;
    protected NodePropertyWrapper emdRootWrapper_ = null;

    public TreePropertyWrapper(TreeProperty treeProperty, String emdVersion) {
        this.emdProperty = treeProperty;
        this.emdProperty.addPropertyChangeListener((PropertyChangeListener)this);
        this.propertyChanges = new PropertyChangeSupport((IPropertyDescriptor)this);
        this.emdVersion = emdVersion;
    }

    public boolean showRoot() {
        return this.emdProperty.showRoot();
    }

    public INodeProperty getRoot() {
        if (this.emdRoot_ == null || this.emdRoot_ != this.emdProperty.getRoot()) {
            this.emdRoot_ = this.emdProperty.getRoot();
            this.emdRootWrapper_ = new NodePropertyWrapper(this.emdRoot_, this.emdVersion);
            this.emdRootWrapper_.setParent((IPropertyDescriptor)this);
        }
        return this.emdRootWrapper_;
    }

    public String getDescription() {
        return this.emdProperty.getDescription();
    }

    public String getName() {
        return this.emdProperty.getName();
    }

    public String getDisplayName() {
        return this.emdProperty.getDisplayName();
    }

    public boolean isEnabled() {
        return this.emdProperty.isEnabled();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            TreePropertyWrapper clone = (TreePropertyWrapper)super.clone();
            clone.emdProperty = (TreeProperty)this.emdProperty.clone();
            clone.emdProperty.addPropertyChangeListener((PropertyChangeListener)clone);
            clone.propertyChanges = new PropertyChangeSupport((IPropertyDescriptor)clone);
            clone.emdRoot_ = clone.emdProperty.getRoot();
            clone.emdRootWrapper_ = new NodePropertyWrapper(clone.emdRoot_, this.emdVersion);
            clone.emdRootWrapper_.setParent((IPropertyDescriptor)clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChanges.addPropertyChangeListener(listener);
    }

    public void assignID(String id) throws CoreException {
        if (!"DEFAULT_PROPERTY_IDENTIFIER".equals(this.getID())) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_ID_SET, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        this.propertyID = id;
    }

    public String getID() {
        if (EMDDescriptor.isEMDSpecVersion11OrLater(this.emdVersion)) {
            return this.emdProperty.getID();
        }
        return this.propertyID;
    }

    public int getPropertyFlag() {
        return 264;
    }

    public boolean isSelectableTree() {
        if (EMDDescriptor.isEMDSpecVersion11OrLater(this.emdVersion)) {
            return this.emdProperty.selectableNodes();
        }
        return true;
    }

    public void propertyChange(PropertyEvent evt) {
        if (evt.getSource() == this.emdProperty) {
            int propertyChangeType = evt.getPropertyChangeType();
            if (propertyChangeType == 2) {
                this.propertyChanges.firePropertyEnabledChange(false);
            } else if (propertyChangeType == 1) {
                this.propertyChanges.firePropertyEnabledChange(true);
            } else if (propertyChangeType == 3) {
                this.propertyChanges.firePropertyValidValuesChanged();
            } else if (propertyChangeType == 0) {
                this.propertyChanges.firePropertyValueChange(evt.getOldValue(), evt.getNewValue());
            } else if (propertyChangeType == 4) {
                this.propertyChanges.firePropertyValid();
            } else if (propertyChangeType == 5) {
                this.propertyChanges.firePropertyInValid();
            }
        }
    }

    public TreeProperty getWrappedProperty() {
        return this.emdProperty;
    }

    public boolean isExpert() {
        if (EMDDescriptor.isEMDSpecVersion13OrLater(this.emdVersion)) {
            return this.emdProperty.isExpert();
        }
        return false;
    }
}

