/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.properties.wrapper;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.PropertyChangeSupport;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import commonj.connector.metadata.discovery.properties.extensions.FileProperty;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class FilePropertyWrapper
extends com.ibm.propertygroup.spi.common.FileProperty
implements PropertyChangeListener {
    protected SingleValuedProperty emdProperty;
    String emdVersion = null;
    protected PropertyChangeSupport propertyChanges_;

    public FilePropertyWrapper(FileProperty emdProperty, BasePropertyGroup parentGroup, String emdVersion) throws CoreException {
        this((SingleValuedProperty)emdProperty, parentGroup, emdProperty.getFileExtensions(), emdProperty.mustExist(), emdVersion);
        if (emdProperty.getID() != null) {
            this.propertyID = emdProperty.getID();
        }
    }

    public FilePropertyWrapper(SingleValuedProperty emdProperty, BasePropertyGroup parentGroup, String[] validFileExtensions) throws CoreException {
        this(emdProperty, parentGroup, validFileExtensions, true, EMDDescriptor.EMD_SPEC_VERSION_1_0);
    }

    FilePropertyWrapper(SingleValuedProperty emdProperty, BasePropertyGroup parentGroup, String[] validFileExtensions, boolean mustExist, String emdVersion) throws CoreException {
        super(emdProperty.getName(), emdProperty.getDisplayName(), emdProperty.getDescription(), parentGroup, validFileExtensions, mustExist);
        this.emdVersion = emdVersion;
        try {
            this.emdProperty = emdProperty;
            if (emdProperty.getPropertyType().getType() != File.class) {
                Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.MSG_ERROR_NOT_FILE_PROP, null);
                LogFacility.logErrorMessage((IStatus)status);
                throw new CoreException((IStatus)status);
            }
            this.setExpert(emdProperty.getPropertyType().isExpert());
            this.setEnabled(emdProperty.isEnabled());
            this.setHidden(emdProperty.getPropertyType().isHidden());
            this.setSensitive(emdProperty.getPropertyType().isSensitive());
            this.setReadOnly(emdProperty.getPropertyType().isReadOnly());
            this.setRequired(emdProperty.getPropertyType().isRequired());
            Object defaultValue = emdProperty.getPropertyType().getDefaultValue();
            if (defaultValue != null) {
                this.setDefaultValue(URI.createFileURI((String)defaultValue.toString()));
            }
            Object[] validValues = emdProperty.getPropertyType().getValidValues();
            this.setValidValues(validValues);
            if (emdProperty.getValue() != null) {
                this.setValue(URI.createFileURI((String)((File)emdProperty.getValue()).getPath()));
            }
            emdProperty.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (Throwable e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
    }

    public void propertyChange(PropertyEvent evt) {
        block17: {
            if (evt.getSource() == this.emdProperty) {
                int propertyChangeType = evt.getPropertyChangeType();
                if (propertyChangeType == 0) {
                    try {
                        if (evt.getNewValue() != null) {
                            String fileLocation = evt.getNewValue().toString();
                            URI uri = URI.createFileURI((String)fileLocation);
                            super.setValue((Object)uri);
                            break block17;
                        }
                        super.setValue(null);
                    }
                    catch (CoreException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                } else if (propertyChangeType == 2) {
                    this.setEnabled(false);
                } else if (propertyChangeType == 1) {
                    this.setEnabled(true);
                } else if (propertyChangeType == 3) {
                    try {
                        this.setValidValues((Object[])evt.getNewValue());
                    }
                    catch (CoreException e) {
                        LogFacility.logErrorMessage((IStatus)e.getStatus());
                    }
                } else if (propertyChangeType == 4) {
                    this.setValid(true, null);
                } else if (propertyChangeType == 5) {
                    this.setValid(false, this.emdProperty.getValidationMessage());
                }
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            FilePropertyWrapper clone = (FilePropertyWrapper)((Object)super.clone());
            clone.emdProperty = (SingleValuedProperty)this.emdProperty.clone();
            clone.emdProperty.addPropertyChangeListener((PropertyChangeListener)clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public void setValue(Object newValue) throws CoreException {
        Object oldValue = super.getValue();
        Object emdOldValue = this.emdProperty.getValue();
        try {
            try {
                this.emdProperty.removePropertyChangeListener((PropertyChangeListener)this);
                File file = null;
                if (newValue != null) {
                    String fileLocation = ((URI)newValue).toFileString();
                    file = new File(fileLocation);
                }
                this.emdProperty.setValue(file);
                super.setValue(newValue);
            }
            catch (MetadataException e) {
                super.setValue(oldValue);
                Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (CoreException e) {
                try {
                    this.emdProperty.setValue(emdOldValue);
                    throw e;
                }
                catch (MetadataException e1) {
                    Status status = new Status(4, "com.ibm.adapter.emd", 4, e1.getLocalizedMessage() == null ? "" : e1.getLocalizedMessage(), (Throwable)e1);
                    LogFacility.logErrorMessage((IStatus)status);
                    throw new CoreException((IStatus)status);
                }
            }
            catch (Throwable e) {
                super.setValue(oldValue);
                Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), e);
                LogFacility.logErrorMessage((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            this.emdProperty.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public SingleValuedProperty getWrappedProperty() {
        return this.emdProperty;
    }
}

