/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.properties.wrapper;

import com.ibm.adapter.emd.internal.LogFacility;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.extensions.BindingTypeProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BindingTypePropertyWrapper
extends com.ibm.propertygroup.spi.common.BindingTypeProperty
implements PropertyChangeListener {
    protected BindingTypeProperty emdProperty;
    static final String extensionID = "com.ibm.wbit.adapter.emd.ui.properties.BindingTypeProperty";
    String emdVersion = null;

    public BindingTypePropertyWrapper(BindingTypeProperty emdProperty, String emdVersion) throws CoreException {
        super(emdProperty.getName(), emdProperty.getDisplayName(), emdProperty.getDescription(), null, emdProperty.getTags() != null ? emdProperty.getTags().toArray(new String[0]) : null);
        this.emdVersion = emdVersion;
        this.propertyID = emdProperty.getID() != null ? emdProperty.getID() : extensionID;
        try {
            this.emdProperty = emdProperty;
            this.setExpert(emdProperty.getPropertyType().isExpert());
            this.setEnabled(emdProperty.isEnabled());
            this.setHidden(emdProperty.getPropertyType().isHidden());
            this.setSensitive(emdProperty.getPropertyType().isSensitive());
            this.setReadOnly(emdProperty.getPropertyType().isReadOnly());
            this.setRequired(emdProperty.getPropertyType().isRequired());
            Object defaultValue = emdProperty.getPropertyType().getDefaultValue();
            if (defaultValue != null) {
                this.setDefaultValue(defaultValue);
            }
            Object[] validValues = emdProperty.getPropertyType().getValidValues();
            this.setValidValues(validValues);
            if (emdProperty.getValue() != null) {
                this.setValue(emdProperty.getValue());
            }
            emdProperty.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (Throwable e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
    }

    public void propertyChange(PropertyEvent evt) {
        if (evt.getSource() == this.emdProperty) {
            int propertyChangeType = evt.getPropertyChangeType();
            if (propertyChangeType == 0) {
                try {
                    super.setValue(evt.getNewValue());
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                }
            } else if (propertyChangeType == 2) {
                this.setEnabled(false);
            } else if (propertyChangeType == 1) {
                this.setEnabled(true);
            } else if (propertyChangeType == 3) {
                try {
                    this.setValidValues((Object[])evt.getNewValue());
                }
                catch (CoreException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                }
            } else if (propertyChangeType == 4) {
                this.setValid(true, null);
            } else if (propertyChangeType == 5) {
                this.setValid(false, this.emdProperty.getValidationMessage());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            BindingTypePropertyWrapper clone = (BindingTypePropertyWrapper)((Object)super.clone());
            clone.emdProperty = (BindingTypeProperty)this.emdProperty.clone();
            clone.emdProperty.addPropertyChangeListener((PropertyChangeListener)clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    public void setValue(Object newValue) throws CoreException {
        try {
            this.emdProperty.setValue(newValue);
        }
        catch (MetadataException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        super.setValue(newValue);
    }

    public BindingTypeProperty getWrappedProperty() {
        return this.emdProperty;
    }
}

