/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.properties;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.discovery.MessageUtil;
import com.ibm.adapter.emd.internal.properties.AdapterTypeProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyType;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.build.MetadataBuild;
import commonj.connector.metadata.discovery.AdapterType;
import commonj.connector.metadata.discovery.AdapterTypeSummary;
import commonj.connector.metadata.discovery.MetadataDiscovery;
import commonj.connector.metadata.discovery.connection.ConnectionType;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;

public class ConnectionTypeProperty
extends BaseSingleValuedProperty {
    static final String CONNECTION_TYPE = "connectionType";
    private MetadataDiscovery discovery = null;
    private MetadataBuild build = null;
    private HashMap connectionTypes = new HashMap();
    private String description = null;
    boolean isOutboundFlow = true;
    private MessageUtil messageUtil;

    public ConnectionTypeProperty(BasePropertyGroup parentGroup, MetadataBuild metaDiscovery_Builder, boolean isOutboundFlow, MessageUtil messageUtil) throws CoreException {
        super(CONNECTION_TYPE, messageUtil.getMessage("CONNECTION_TYPE_PROP_DISPLAY_NAME"), null, ConnectionType.class, parentGroup);
        this.build = metaDiscovery_Builder;
        this.isOutboundFlow = isOutboundFlow;
        this.messageUtil = messageUtil;
        this.initialize();
    }

    public ConnectionTypeProperty(BasePropertyGroup parentGroup, MetadataDiscovery metaDiscovery_Builder, MessageUtil messageUtil) throws CoreException {
        super(CONNECTION_TYPE, messageUtil.getMessage("CONNECTION_TYPE_PROP_DISPLAY_NAME"), null, ConnectionType.class, parentGroup);
        this.discovery = metaDiscovery_Builder;
        this.messageUtil = messageUtil;
        this.initialize();
    }

    private void initialize() throws CoreException {
        this.setRequired(true);
        this.setValidValuesEditable(false);
        this.setEnabled(true);
        this.propertyType = new BasePropertyType(ConnectionType.class){

            public String[] getValidValuesAsStrings() {
                Object[] validValues = this.getValidValues();
                if (validValues != null) {
                    String[] validValuesStrings = new String[validValues.length];
                    int i = 0;
                    while (i < validValues.length) {
                        ConnectionType ct = (ConnectionType)validValues[i];
                        validValuesStrings[i] = ConnectionTypeProperty.this.getDisplayName(ct);
                        ++i;
                    }
                    return validValuesStrings;
                }
                return null;
            }
        };
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof AdapterTypeProperty && evt.getPropertyChangeType() == 0) {
            AdapterTypeProperty cfr_ignored_0 = (AdapterTypeProperty)((Object)evt.getSource());
            AdapterTypeSummary adapterTypeSummary = (AdapterTypeSummary)evt.getNewValue();
            if (adapterTypeSummary == null) {
                this.reiniitalizeProperty();
                this.setHidden(true);
                this.propertyChanges.firePropertyInValid();
            } else {
                AdapterType adapterType = null;
                try {
                    adapterType = this.discovery != null ? this.discovery.getAdapterType(adapterTypeSummary.getId()) : this.build.getAdapterType(adapterTypeSummary.getId());
                }
                catch (MetadataException e1) {
                    LogFacility.logErrorMessage((String)e1.getLocalizedMessage(), (Throwable)e1);
                }
                if (adapterType == null) {
                    this.reiniitalizeProperty();
                    this.setHidden(true);
                    this.propertyChanges.firePropertyInValid();
                } else {
                    OutboundConnectionType[] types;
                    StringBuffer description = new StringBuffer(this.messageUtil.getMessage("CONNECTION_TYPE_PROP_DESCRIPTION"));
                    if (this.discovery != null) {
                        types = adapterType.getOutboundConnectionTypes();
                        int i = 0;
                        while (i < types.length) {
                            if (types[i].isSupportedInMetadataService()) {
                                this.connectionTypes.put(this.getDisplayName((ConnectionType)types[i]), types[i]);
                                description.append("<").append(types[i].getDisplayName()).append(">:  ").append(types[i].getDescription()).append("\n");
                                if (this.getPropertyType().getDefaultValue() == null) {
                                    this.setDefaultValue(types[i]);
                                }
                            }
                            ++i;
                        }
                    } else if (this.isOutboundFlow) {
                        types = adapterType.getOutboundConnectionTypes();
                        int i = 0;
                        while (i < types.length) {
                            if (types[i].isSupportedAtRuntime()) {
                                this.connectionTypes.put(this.getDisplayName((ConnectionType)types[i]), types[i]);
                                description.append("<").append(types[i].getDisplayName()).append(">:  ").append(types[i].getDescription()).append("\n");
                                if (this.getPropertyType().getDefaultValue() == null) {
                                    this.setDefaultValue(types[i]);
                                }
                            }
                            ++i;
                        }
                    } else {
                        types = adapterType.getInboundConnectionTypes();
                        int i = 0;
                        while (i < types.length) {
                            this.connectionTypes.put(this.getDisplayName((ConnectionType)types[i]), types[i]);
                            description.append("<").append(types[i].getDisplayName()).append(">:  ").append(types[i].getDescription()).append("\n");
                            if (this.getPropertyType().getDefaultValue() == null) {
                                this.setDefaultValue(types[i]);
                            }
                            ++i;
                        }
                    }
                    if (this.getPropertyType().getDefaultValue() != null) {
                        this.setDescription(description.toString());
                        if (this.connectionTypes.size() == 1) {
                            this.setHidden(true);
                        } else {
                            this.setHidden(false);
                        }
                        try {
                            this.setValidValues(this.connectionTypes.values().toArray(new ConnectionType[0]));
                            this.setValue(this.getPropertyType().getDefaultValue());
                            this.propertyChanges.firePropertyValid();
                        }
                        catch (CoreException e) {
                            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                        }
                    } else {
                        this.reiniitalizeProperty();
                        this.propertyChanges.firePropertyInValid();
                    }
                }
            }
        }
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    private void reiniitalizeProperty() {
        this.setDescription(null);
        this.setDefaultValue(null);
        try {
            this.setValidValues(null);
        }
        catch (CoreException coreException) {}
        this.setValidNoNotify(true);
        this.value = null;
        this.connectionTypes.clear();
    }

    public String getValueAsString() {
        ConnectionType type = (ConnectionType)this.getValue();
        return this.getDisplayName(type);
    }

    public void setValueAsString(String newValue) throws CoreException {
        this.setValue(this.connectionTypes.get(newValue));
    }

    private String getDisplayName(ConnectionType ct) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ct.getId());
        buffer.append(":");
        buffer.append(ct.getDisplayName());
        return buffer.toString();
    }
}

