/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.discovery;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDResponse;
import com.ibm.adapter.emd.internal.discovery.EMDResultNode;
import com.ibm.adapter.emd.internal.discovery.EMDResultNodeSelection;
import com.ibm.adapter.emd.internal.discovery.EMDToolContext;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeResponse;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.spi.BaseSearchTree;
import com.ibm.propertygroup.IPropertyGroup;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.MetadataObjectResponse;
import commonj.connector.metadata.discovery.MetadataSelection;
import commonj.connector.metadata.discovery.MetadataTree;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class EMDSearchTree
extends BaseSearchTree {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private MetadataTree emdMetadataTree;
    private EMDToolContext activeContext;
    private String emdVersion = null;

    public EMDSearchTree(MetadataTree tree, EMDToolContext context, String emdVersion) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (tree == null) {
            BaseException e = BaseException.createException((String)MessageResource.MSG_ERROR_METADATA_TREE_NULL, null);
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            throw e;
        }
        this.emdMetadataTree = tree;
        switch (this.emdMetadataTree.getSelectionStyle()) {
            case 0: {
                this.setSelectionStyle(0);
                break;
            }
            case 1: {
                this.setSelectionStyle(1);
            }
        }
        this.activeContext = context;
        this.emdVersion = emdVersion;
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    public IResultNodeSelection createResultNodeSelection() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            EMDResultNodeSelection resultSelection;
            MetadataSelection selection = this.emdMetadataTree.createMetaDataSelection();
            EMDResultNodeSelection eMDResultNodeSelection = resultSelection = new EMDResultNodeSelection(selection, this.emdVersion);
            return eMDResultNodeSelection;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        return null;
    }

    public IPropertyGroup getFilterProperties() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            PropertyGroup group = this.emdMetadataTree.createFilterProperties();
            if (group != null) {
                PropertyGroupWrapper wrapper = new PropertyGroupWrapper(group.getName(), group.getDisplayName(), group.getDescription(), this.emdVersion);
                wrapper.addPropertiesToPropertyGroup(group);
                PropertyGroupWrapper propertyGroupWrapper = wrapper;
                return propertyGroupWrapper;
            }
            return null;
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        return null;
    }

    public IResultNode getResultNode(String location, IEnvironment environment) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            this.activeContext.setImportEnvironment(environment);
            EMDResultNode eMDResultNode = new EMDResultNode(this.emdMetadataTree.getMetadataObject(location), this.activeContext, this.emdVersion);
            return eMDResultNode;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_ANNONYMOUS_EMD_ERROR, (Object)e.getLocalizedMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public int getSelectionStyle() {
        return this.selectionStyle;
    }

    public IResultNodeResponse performQuery(IPropertyGroup searchParameters, IEnvironment environment) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            EMDResponse response;
            this.activeContext.setImportEnvironment(environment);
            if (searchParameters != null) {
                if (searchParameters instanceof PropertyGroupWrapper) {
                    EMDResponse response2;
                    MetadataObjectResponse emdResponse = this.emdMetadataTree.listMetadataObjects(((PropertyGroupWrapper)searchParameters).getWrappedPropertyGroup());
                    EMDResponse eMDResponse = response2 = new EMDResponse(emdResponse, this.activeContext, this.emdVersion);
                    return eMDResponse;
                }
                BaseException e = BaseException.createException((String)MessageResource.MSG_ERROR_INVALID_SEARCH_PARMS, null);
                LogFacility.logErrorMessage((IStatus)e.getStatus());
                throw e;
            }
            MetadataObjectResponse emdResponse = this.emdMetadataTree.listMetadataObjects(null);
            EMDResponse eMDResponse = response = new EMDResponse(emdResponse, this.activeContext, this.emdVersion);
            return eMDResponse;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_ANNONYMOUS_EMD_ERROR, (Object)e.getLocalizedMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }
}

