/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.discovery;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.discovery.EMDIterator;
import com.ibm.adapter.emd.internal.discovery.EMDToolContext;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeIterator;
import com.ibm.adapter.framework.IResultNodeResponse;
import commonj.connector.metadata.discovery.MetadataObjectIterator;
import commonj.connector.metadata.discovery.MetadataObjectResponse;
import org.eclipse.core.runtime.IStatus;

public class EMDResponse
implements IResultNodeResponse {
    private MetadataObjectResponse response;
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private EMDToolContext activeContext;
    private String emdVersion = null;

    public EMDResponse(MetadataObjectResponse objectResponse, EMDToolContext context, String emdVersion) {
        this.response = objectResponse;
        this.activeContext = context;
        this.emdVersion = emdVersion;
    }

    public String getMessage() {
        return this.response.getMessage();
    }

    public IResultNodeIterator getResultNodeIterator() {
        MetadataObjectIterator iter = this.response.getObjectIterator();
        try {
            return new EMDIterator(iter, this.activeContext, this.emdVersion);
        }
        catch (BaseException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            return new IResultNodeIterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    return null;
                }

                public IResultNode nextResultNode() {
                    return null;
                }

                public void remove() {
                }
            };
        }
    }

    public boolean hasContent() {
        try {
            return this.response.getObjectIterator().hasNext();
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }
}

