/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.discovery;

import com.ibm.adapter.emd.internal.EmdPlugin;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.build.EMDBuildAgent;
import com.ibm.adapter.emd.internal.discovery.EMDDiscoveryAgent;
import com.ibm.adapter.emd.internal.discovery.EMDToolContext;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.adapter.j2ca.internal.ResourceAdapterRegistry;
import com.ibm.adapter.j2ca.spi.util.BundleClassLoader;
import com.ibm.adapter.j2ca.spi.util.ConnectorProjectHelper;
import commonj.connector.metadata.build.BindingProvider;
import commonj.connector.metadata.build.MetadataBuild;
import commonj.connector.metadata.build.MetadataType;
import commonj.connector.metadata.discovery.AdapterConfiguration;
import commonj.connector.metadata.discovery.MetadataDiscovery;
import commonj.connector.metadata.discovery.MetadataEdit;
import commonj.connector.tool.ToolContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;

public class EMDDescriptor {
    public static String EMD_SPEC_VERSION_1_0 = "1.0";
    public static String EMD_SPEC_VERSION_1_1 = "1.1";
    public static String EMD_SPEC_VERSION_1_2 = "1.2";
    public static String EMD_SPEC_VERSION_1_3;
    public static String LATEST_EMD_SPEC_VERSION;
    private static Map<String, EMDDescriptor> descriptors;
    private static Map<String, List<UIOverride>> UIOverrideMap_;
    private boolean inizialized = false;
    private ClassLoader classLoader = null;
    private EMDDiscoveryAgent discoveryAgent = null;
    private EMDBuildAgent buildAgent = null;
    public static final EMDToolContext defaultContext;
    private ArrayList<ASI> asiSchemas = new ArrayList();
    private ArrayList<UIOverride> uiOverrides_ = new ArrayList();
    private IProject connectorProject;
    private String description;
    private MetadataDiscovery discoveryService;
    private String discoveryServiceClass;
    private String displayName;
    private MetadataEdit metadataEdit;
    private String metadataEditClass;
    private AdapterConfiguration adapterConfiguration;
    private String adapterConfigurationClass;
    private String specVersion;
    private String vendorName;
    private String version;
    private MetadataBuild metadataBuild;
    private String metadataBuildClass;
    private MetadataType metadataType;
    private String metadataTypeClass;
    private BindingProvider bindingProvider;
    private String bindingProviderClass;

    static {
        LATEST_EMD_SPEC_VERSION = EMD_SPEC_VERSION_1_3 = "1.3";
        descriptors = Collections.synchronizedMap(new HashMap());
        UIOverrideMap_ = Collections.synchronizedMap(new HashMap());
        defaultContext = new EMDToolContext(null, null, LogFacility.trace ? Level.FINEST : Level.SEVERE);
    }

    public void addASI(ASI anASI) {
        this.asiSchemas.add(anASI);
    }

    public void addUIOverride(UIOverride aUIOverride) {
        this.uiOverrides_.add(aUIOverride);
    }

    public IProject getConnectorProject() {
        return this.connectorProject;
    }

    public String getDescription() {
        return this.description;
    }

    public MetadataDiscovery getDiscoveryService() {
        if (!this.inizialized) {
            this.initialize();
        }
        return this.discoveryService;
    }

    public String getDiscoveryServiceClass() {
        return this.discoveryServiceClass;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MetadataEdit getMetadataEdit() {
        if (!this.inizialized) {
            this.initialize();
        }
        return this.metadataEdit;
    }

    public String getMetadataEditClass() {
        return this.metadataEditClass;
    }

    public ASI[] getSchemas() {
        return this.asiSchemas.toArray(new ASI[0]);
    }

    public List<UIOverride> getUIOverrides() {
        return this.uiOverrides_;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeASI(ASI anASI) {
        this.asiSchemas.remove(anASI);
    }

    public void removeUIOverride(UIOverride aUIOverride) {
        this.uiOverrides_.remove(aUIOverride);
    }

    public void setConnectorProject(IProject connectorProject) {
        this.connectorProject = connectorProject;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private void setDiscoveryService(MetadataDiscovery discoveryService) {
        this.discoveryService = discoveryService;
    }

    public void setDiscoveryServiceClass(String discoveryServiceClass) {
        this.discoveryServiceClass = discoveryServiceClass;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private void setMetadataEdit(MetadataEdit metadataEdit) {
        this.metadataEdit = metadataEdit;
    }

    public void setMetadataEditClass(String metadataEditClass) {
        this.metadataEditClass = metadataEditClass;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static Map<String, EMDDescriptor> getDescriptors() {
        return descriptors;
    }

    public static Map<String, List<UIOverride>> getAllUIOverrides() {
        return UIOverrideMap_;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                IResourceAdapterRegistry raRegistry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();
                IResourceAdapterDescriptor raDesc = raRegistry.getResourceAdapterForProject(this.getConnectorProject());
                if (raDesc != null) {
                    this.classLoader = raDesc.getClassLoader();
                } else {
                    URL[] classpathURLs = ConnectorProjectHelper.getURLsFromProject((IProject)this.getConnectorProject());
                    this.classLoader = new BundleClassLoader(EmdPlugin.getDefault().getBundle(), classpathURLs);
                }
                if (this.getDiscoveryServiceClass() != null) {
                    Class<?> metadataDiscoveryClass = null;
                    try {
                        metadataDiscoveryClass = this.classLoader.loadClass(this.getDiscoveryServiceClass());
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_METADATADISC_CLASS, (Object)this.getDiscoveryServiceClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                    }
                    if (metadataDiscoveryClass == null) {
                        throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_METADATAIMPL, (Object)this.getConnectorProject().getName()), null);
                    }
                    try {
                        this.discoveryService = (MetadataDiscovery)metadataDiscoveryClass.newInstance();
                        this.discoveryService.setToolContext((ToolContext)defaultContext);
                        this.setDiscoveryService(this.discoveryService);
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_METADATADISC_CLASS, (Object)this.getDiscoveryServiceClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                    }
                }
                Class<?> metadataEditClass = null;
                try {
                    metadataEditClass = this.classLoader.loadClass(this.getMetadataEditClass());
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_METADATAEDIT_CLASS, (Object)this.getDiscoveryServiceClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                }
                if (metadataEditClass == null) {
                    throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_METADATA_EDIT_IMPL, (Object)this.getConnectorProject().getName()), null);
                }
                try {
                    this.setMetadataEdit((MetadataEdit)metadataEditClass.newInstance());
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_METADATAEDIT_CLASS, (Object)this.getDiscoveryServiceClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                }
                if (this.getMetadataBuildClass() != null) {
                    Class<?> metadataBuildClassTemp = null;
                    try {
                        metadataBuildClassTemp = this.classLoader.loadClass(this.getMetadataBuildClass());
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_METADATABUILD_CLASS, (Object)this.getMetadataBuildClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                    }
                    if (metadataBuildClassTemp == null) {
                        throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_METADATA_BUILD_IMPL, (Object)this.getConnectorProject().getName()), null);
                    }
                    try {
                        this.metadataBuild = (MetadataBuild)metadataBuildClassTemp.newInstance();
                        this.metadataBuild.setToolContext((ToolContext)defaultContext);
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_METADATABUILD_CLASS, (Object)this.getMetadataBuildClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                    }
                }
                if (this.getMetadataTypeClass() != null) {
                    Class<?> metadataTypeClassTemp = null;
                    try {
                        metadataTypeClassTemp = this.classLoader.loadClass(this.getMetadataTypeClass());
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_METADATATYPE_CLASS, (Object)this.getMetadataTypeClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                    }
                    if (metadataTypeClassTemp == null) {
                        throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_METADATA_TYPE_IMPL, (Object)this.getConnectorProject().getName()), null);
                    }
                    try {
                        this.setMetadataType((MetadataType)metadataTypeClassTemp.newInstance());
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_METADATATYPE_CLASS, (Object)this.getMetadataTypeClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                    }
                }
                if (this.getAdapterConfigurationClass() != null) {
                    Class<?> adapterConfigClassTemp = null;
                    try {
                        adapterConfigClassTemp = this.classLoader.loadClass(this.getAdapterConfigurationClass());
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_ADAPTERCONFIG_CLASS, (Object)this.getAdapterConfigurationClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                    }
                    if (adapterConfigClassTemp == null) {
                        throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_ADAPTER_CONFIG_IMPL, (Object)this.getConnectorProject().getName()), null);
                    }
                    try {
                        this.setAdapterConfiguration((AdapterConfiguration)adapterConfigClassTemp.newInstance());
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_ADAPTERCONFIG_CLASS, (Object)this.getAdapterConfigurationClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                    }
                }
                if (this.getBindingProviderClass() == null) return;
                Class<?> bindingProviderClass = null;
                try {
                    bindingProviderClass = this.classLoader.loadClass(this.getBindingProviderClass());
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_BINDINGPROVIDER_CLASS, (Object)this.getBindingProviderClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                }
                if (bindingProviderClass == null) {
                    throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_NO_BINDING_PROVIDER_IMPL, (Object)this.getConnectorProject().getName()), null);
                }
                try {
                    this.setBindingProvider((BindingProvider)bindingProviderClass.newInstance());
                    return;
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_LOAD_BINDINGPROVIDER_CLASS, (Object)this.getAdapterConfigurationClass(), (Object)this.getConnectorProject().getName()), (Throwable)e);
                }
                return;
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                this.inizialized = true;
                if (!LogFacility.trace) return;
                LogFacility.TrcExit();
                return;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                this.inizialized = true;
                if (!LogFacility.trace) return;
                LogFacility.TrcExit();
                return;
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                this.inizialized = true;
                if (!LogFacility.trace) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                LogFacility.TrcExit();
                return;
            }
        }
        finally {
            this.inizialized = true;
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public void reset() {
        this.inizialized = false;
        this.classLoader = null;
        this.metadataEdit = null;
        this.discoveryService = null;
        this.adapterConfiguration = null;
        this.metadataType = null;
        this.metadataBuild = null;
        this.bindingProvider = null;
    }

    public ClassLoader getClassLoader() {
        if (!this.inizialized) {
            this.initialize();
        }
        return this.classLoader;
    }

    public EMDDiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(EMDDiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }

    public EMDBuildAgent getBuildAgent() {
        return this.buildAgent;
    }

    public void setBuildAgent(EMDBuildAgent buildAgent) {
        this.buildAgent = buildAgent;
    }

    public MetadataBuild getMetadataBuild() {
        if (!this.inizialized) {
            this.initialize();
        }
        return this.metadataBuild;
    }

    public void setMetadataBuild(MetadataBuild buildService) {
        this.metadataBuild = buildService;
    }

    public MetadataType getMetadataType() {
        if (!this.inizialized) {
            this.initialize();
        }
        return this.metadataType;
    }

    public void setMetadataType(MetadataType buildType) {
        this.metadataType = buildType;
    }

    public String getAdapterConfigurationClass() {
        return this.adapterConfigurationClass;
    }

    public void setAdapterConfigurationClass(String adapterConfigClass) {
        this.adapterConfigurationClass = adapterConfigClass;
    }

    public AdapterConfiguration getAdapterConfiguration() {
        if (!this.inizialized) {
            this.initialize();
        }
        return this.adapterConfiguration;
    }

    public void setAdapterConfiguration(AdapterConfiguration adapterConfig) {
        this.adapterConfiguration = adapterConfig;
    }

    public String getMetadataBuildClass() {
        return this.metadataBuildClass;
    }

    public void setMetadataBuildClass(String buildServiceClass) {
        this.metadataBuildClass = buildServiceClass;
    }

    public String getMetadataTypeClass() {
        return this.metadataTypeClass;
    }

    public void setMetadataTypeClass(String buildTypeClass) {
        this.metadataTypeClass = buildTypeClass;
    }

    public void setBindingProviderClass(String bindingProviderClass) {
        this.bindingProviderClass = bindingProviderClass;
    }

    public String getBindingProviderClass() {
        return this.bindingProviderClass;
    }

    public BindingProvider getBindingProvider() {
        if (!this.inizialized) {
            this.initialize();
        }
        return this.bindingProvider;
    }

    public void setBindingProvider(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public static boolean isEMDSpecVersion10(String emdVersion) {
        return EMD_SPEC_VERSION_1_0.equals(emdVersion);
    }

    public static boolean isEMDSpecVersion11(String emdVersion) {
        return EMD_SPEC_VERSION_1_1.equals(emdVersion);
    }

    public static boolean isEMDSpecVersion12(String emdVersion) {
        return EMD_SPEC_VERSION_1_2.equals(emdVersion);
    }

    public static boolean isEMDSpecVersion13(String emdVersion) {
        return EMD_SPEC_VERSION_1_3.equals(emdVersion);
    }

    public static boolean isEMDSpecVersion11OrLater(String emdVersion) {
        return EMDDescriptor.isEMDSpecVersion11(emdVersion) || EMDDescriptor.isEMDSpecVersion12OrLater(emdVersion);
    }

    public static boolean isEMDSpecVersion12OrLater(String emdVersion) {
        return EMDDescriptor.isEMDSpecVersion12(emdVersion) || EMDDescriptor.isEMDSpecVersion13OrLater(emdVersion);
    }

    public static boolean isEMDSpecVersion13OrLater(String emdVersion) {
        return EMDDescriptor.isEMDSpecVersion13(emdVersion);
    }

    public class ASI {
        private String description;
        private String displayName;
        private String namespaceURI;
        private String schemaLocation;

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getSchemaLocation() {
            return this.schemaLocation;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public void setNamespaceURI(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        public void setSchemaLocation(String schemaLocation) {
            this.schemaLocation = schemaLocation;
        }
    }

    public static class UIOverride {
        public static final int GROUP_TYPE = 1;
        public static final int PROPERTY_TYPE = 2;
        protected String propertyID_ = null;
        protected String className_ = null;
        protected int propertyType_ = 1;
        protected Object instanceObject_ = null;
        protected IResourceAdapterDescriptor raDesc_ = null;

        private UIOverride() {
        }

        public UIOverride(String propertyID, int propertyType, String className, IResourceAdapterDescriptor raDesc) {
            this();
            this.propertyID_ = propertyID;
            this.propertyType_ = propertyType;
            this.className_ = className;
            this.raDesc_ = raDesc;
        }

        public UIOverride(String propertyID, int propertyType, String className, IProject raProject) {
            this();
            this.propertyID_ = propertyID;
            this.propertyType_ = propertyType;
            this.className_ = className;
            this.raDesc_ = ResourceAdapterRegistry.getRegistry().getResourceAdapterForProject(raProject);
        }

        public String getPropertyID() {
            return this.propertyID_;
        }

        public int getPropertyType() {
            return this.propertyType_;
        }

        public String getClassName() {
            return this.className_;
        }

        public Object getInstanceObject() {
            return this.instanceObject_;
        }

        public void setInstanceObject(Object instanceObject) {
            this.instanceObject_ = instanceObject;
        }

        public IResourceAdapterDescriptor getResourceAdapterDescriptor() {
            return this.raDesc_;
        }
    }
}

