/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal;

import com.ibm.adapter.emd.internal.EmdPlugin;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.j2ca.spi.util.BundleClassLoader;
import com.ibm.adapter.j2ca.spi.util.ConnectorProjectHelper;
import commonj.connector.metadata.description.DataBindingGenerator;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class DataBindingGenRegistry {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static DataBindingGenRegistry _instance;

    private DataBindingGenRegistry() {
    }

    public static DataBindingGenRegistry getRegistry() {
        if (_instance == null) {
            DataBindingGenRegistry.initializeInstance();
        }
        return _instance;
    }

    private static synchronized void initializeInstance() {
        if (_instance == null) {
            _instance = new DataBindingGenRegistry();
        }
    }

    public DataBindingGenerator getDataBindingGenerator(IProject[] connectorProjects, String dbgClassName) {
        block7: {
            if (dbgClassName != null && !dbgClassName.equals("")) break block7;
            return null;
        }
        try {
            if (connectorProjects != null) {
                int i = 0;
                while (i < connectorProjects.length) {
                    DataBindingGenerator generator = this.loadGenerator(connectorProjects[i], dbgClassName);
                    if (generator != null) {
                        return generator;
                    }
                    ++i;
                }
            }
            return this.loadGeneratorFromPlugin(dbgClassName);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public DataBindingGenerator getDataBindingGenerator(String dbgClassName) {
        return this.getDataBindingGenerator(null, dbgClassName);
    }

    private DataBindingGenerator loadGenerator(IProject connectorProject, String className) {
        DataBindingGenerator generator = null;
        try {
            try {
                IJavaProject javaProject = JavaCore.create((IProject)connectorProject);
                IType javaType = javaProject.findType(className);
                if (javaType == null) {
                    URL[] classpathURLs = ConnectorProjectHelper.getURLsFromProject((IProject)connectorProject);
                    BundleClassLoader classLoader = new BundleClassLoader(EmdPlugin.getDefault().getBundle(), classpathURLs);
                    Class clazz = classLoader.loadClass(className);
                    generator = (DataBindingGenerator)clazz.newInstance();
                }
            }
            catch (JavaModelException e) {
                LogFacility.logErrorMessage((IStatus)e.getStatus());
            }
            catch (MalformedURLException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                LogFacility.logErrorMessage((IStatus)e.getStatus());
            }
            catch (ClassNotFoundException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {}
        return generator;
    }

    private DataBindingGenerator loadGeneratorFromPlugin(String className) {
        IExtension[] allExts;
        DataBindingGenerator generatorInstance;
        block12: {
            IExtensionPoint extPoint;
            block11: {
                generatorInstance = null;
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                extPoint = registry.getExtensionPoint("connector.metadata", "databinding_generator");
                if (extPoint != null) break block11;
                LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR_DBG_EXT_PT_NOT_FOUND, null);
                return null;
            }
            allExts = extPoint.getExtensions();
            if (allExts != null) break block12;
            LogFacility.logInfoMessage((String)MessageResource.MSG_INFO_NO_DBG_EXT_FOUND);
            return null;
        }
        try {
            int i = 0;
            while (i < allExts.length && generatorInstance == null) {
                IConfigurationElement[] configs = allExts[i].getConfigurationElements();
                if (configs != null) {
                    int j = 0;
                    while (j < configs.length && generatorInstance == null) {
                        String value;
                        IConfigurationElement cfg = configs[j];
                        if ("databinding_generator".equals(cfg.getName()) && className.equals(value = cfg.getAttribute("class"))) {
                            try {
                                generatorInstance = (DataBindingGenerator)cfg.createExecutableExtension("class");
                            }
                            catch (CoreException e) {
                                LogFacility.logErrorMessage((IStatus)e.getStatus());
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return generatorInstance;
    }
}

