/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.PropertyChangeSupport;
import com.ibm.adapter.emd.internal.MessageResource;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyType;
import java.math.BigDecimal;
import java.math.BigInteger;

public class PropertyTypeImpl
implements PropertyType {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected static final int BOOLEAN_OBJECT = 1;
    protected static final int BYTE_OBJECT = 2;
    protected static final int CHAR_OBJECT = 3;
    protected static final int DOUBLE_OBJECT = 4;
    protected static final int FLOAT_OBJECT = 5;
    protected static final int INT_OBJECT = 6;
    protected static final int LONG_OBJECT = 7;
    protected static final int OBJECT = 8;
    protected static final int STRING = 0;
    protected static final int SHORT_OBJECT = 9;
    protected static final int BIGINTEGER = 10;
    protected static final int BIGDECIMAL = 11;
    protected Object defaultValue = null;
    protected boolean defaultValueDerived = false;
    protected boolean expert = false;
    protected boolean hidden = false;
    protected boolean primitive = false;
    protected int propertyTypeIdentifier = 8;
    protected boolean readOnly = false;
    protected boolean required = false;
    protected boolean sensitive = false;
    protected Class type;
    protected String[] validStringValues = null;
    protected Object[] validValues = null;
    protected boolean validValuesEditable = false;

    public PropertyTypeImpl(Class propertyType, PropertyChangeSupport propertyChanges) throws MetadataException {
        if (propertyType == null) {
            throw new MetadataException(MessageResource.ERR_TYPE_NULL);
        }
        if (propertyType == Boolean.TYPE) {
            this.propertyTypeIdentifier = 1;
            this.type = Boolean.class;
            this.primitive = true;
        } else if (propertyType == Byte.TYPE) {
            this.propertyTypeIdentifier = 2;
            this.type = Byte.class;
            this.primitive = true;
        } else if (propertyType == Character.TYPE) {
            this.propertyTypeIdentifier = 3;
            this.type = Character.class;
            this.primitive = true;
        } else if (propertyType == Double.TYPE) {
            this.propertyTypeIdentifier = 4;
            this.type = Double.class;
            this.primitive = true;
        } else if (propertyType == Float.TYPE) {
            this.propertyTypeIdentifier = 5;
            this.type = Float.class;
            this.primitive = true;
        } else if (propertyType == Integer.TYPE) {
            this.propertyTypeIdentifier = 6;
            this.type = Integer.class;
            this.primitive = true;
        } else if (propertyType == Long.TYPE) {
            this.propertyTypeIdentifier = 7;
            this.type = Long.class;
            this.primitive = true;
        } else if (propertyType == Short.TYPE) {
            this.propertyTypeIdentifier = 9;
            this.type = Short.class;
            this.primitive = true;
        } else if (propertyType == String.class) {
            this.propertyTypeIdentifier = 0;
            this.type = propertyType;
        } else if (propertyType == Boolean.class) {
            this.propertyTypeIdentifier = 1;
            this.type = propertyType;
        } else if (propertyType == Byte.class) {
            this.propertyTypeIdentifier = 2;
            this.type = propertyType;
        } else if (propertyType == Character.class) {
            this.propertyTypeIdentifier = 3;
            this.type = propertyType;
        } else if (propertyType == Double.class) {
            this.propertyTypeIdentifier = 4;
            this.type = propertyType;
        } else if (propertyType == Float.class) {
            this.propertyTypeIdentifier = 5;
            this.type = propertyType;
        } else if (propertyType == Integer.class) {
            this.propertyTypeIdentifier = 6;
            this.type = propertyType;
        } else if (propertyType == Long.class) {
            this.propertyTypeIdentifier = 7;
            this.type = propertyType;
        } else if (propertyType == Short.class) {
            this.propertyTypeIdentifier = 9;
            this.type = propertyType;
        } else if (propertyType == BigInteger.class) {
            this.propertyTypeIdentifier = 10;
            this.type = propertyType;
        } else if (propertyType == BigDecimal.class) {
            this.propertyTypeIdentifier = 11;
            this.type = propertyType;
        } else {
            this.propertyTypeIdentifier = 8;
            this.type = propertyType;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PropertyTypeImpl returnObject = (PropertyTypeImpl)super.clone();
        returnObject.defaultValue = this.defaultValue;
        returnObject.defaultValueDerived = this.defaultValueDerived;
        returnObject.expert = this.expert;
        returnObject.hidden = this.hidden;
        returnObject.primitive = this.primitive;
        returnObject.propertyTypeIdentifier = this.propertyTypeIdentifier;
        returnObject.readOnly = this.readOnly;
        returnObject.sensitive = this.sensitive;
        returnObject.type = this.type;
        returnObject.validStringValues = this.validStringValues;
        returnObject.validValues = this.validValues;
        returnObject.validValuesEditable = this.validValuesEditable;
        return returnObject;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getPropertyTypeIdentifier() {
        return this.propertyTypeIdentifier;
    }

    public Class getType() {
        return this.type;
    }

    public Object[] getValidValues() {
        return this.validValues;
    }

    public String[] getValidValuesAsStrings() {
        return this.validStringValues;
    }

    public boolean isDefaultValueDerived() {
        return this.defaultValueDerived;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean isValidValuesEditable() {
        return this.validValuesEditable;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefaultValueDerived(boolean defaultValueDerived) {
        this.defaultValueDerived = defaultValueDerived;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public void setValidValues(Object[] values) throws MetadataException {
        int i;
        boolean valid = true;
        if (values != null) {
            i = values.length;
            while (--i >= 0) {
                if (this.getType().isAssignableFrom(values[i].getClass())) continue;
                valid = false;
                break;
            }
        }
        if (!valid) {
            throw new MetadataException(MessageResource.ERR_INVALID_PROPERTY_TYPE);
        }
        this.validValues = values;
        if (this.validValues != null && this.propertyTypeIdentifier != 8) {
            if (this.propertyTypeIdentifier == 0) {
                this.validStringValues = (String[])this.validValues;
            } else {
                this.validStringValues = new String[this.validValues.length];
                i = this.validValues.length;
                while (--i >= 0) {
                    this.validStringValues[i] = this.validValues[i].toString();
                }
            }
        }
    }

    public void setValidValuesEditable(boolean editable) {
        this.validValuesEditable = editable;
    }
}

