/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.IVetoableChangeListenerInterface;
import com.ibm.adapter.emd.extension.properties.PropertyChangeEvent;
import com.ibm.adapter.emd.extension.properties.PropertyVetoException;
import commonj.connector.metadata.discovery.properties.MultiValuedProperty;
import commonj.connector.metadata.discovery.properties.NodeProperty;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyDescriptor;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import commonj.connector.metadata.discovery.properties.TableProperty;
import java.util.Vector;

public class PropertyChangeSupport {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private Vector propertyChangeListeners = new Vector();
    private PropertyDescriptor source;
    private Vector vetoableChangeListeners = new Vector();

    public PropertyChangeSupport(PropertyDescriptor sourceProperty) {
        if (sourceProperty == null) {
            throw new NullPointerException();
        }
        this.source = sourceProperty;
    }

    public void fireTreePropertySelected() {
        if (this.source instanceof NodeProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, Boolean.TRUE, Boolean.FALSE, 10));
        }
    }

    public void fireTreePropertyDeselected() {
        if (this.source instanceof NodeProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, Boolean.FALSE, Boolean.TRUE, 11));
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public synchronized void addVetoableChangeListener(IVetoableChangeListenerInterface listener) {
        this.vetoableChangeListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(PropertyChangeEvent event) {
        Vector targets = null;
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            if (this.propertyChangeListeners != null) {
                targets = this.propertyChangeListeners;
            }
        }
        if (targets != null) {
            int i = targets.size();
            while (--i >= 0) {
                PropertyChangeListener target = (PropertyChangeListener)targets.elementAt(i);
                target.propertyChange((PropertyEvent)event);
            }
        }
    }

    public void firePropertyEnabledChange(boolean enabled) {
        if (enabled) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, null, null, 1));
        } else {
            this.firePropertyChange(new PropertyChangeEvent(this.source, null, null, 2));
        }
    }

    public void firePropertyGroupAddChild(PropertyDescriptor child) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, null, child, 6));
    }

    public void firePropertyGroupRemoveAll(PropertyDescriptor[] oldChildren) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, oldChildren, null, 9));
    }

    public void firePropertyGroupRemoveChild(PropertyDescriptor child) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, child, null, 7));
    }

    public void firePropertyGroupReplaceAll(PropertyDescriptor[] oldChildren, PropertyDescriptor[] newChildren) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, oldChildren, newChildren, 8));
    }

    public void firePropertyInValid() {
        this.firePropertyChange(new PropertyChangeEvent(this.source, null, null, 5));
    }

    public void firePropertyValid() {
        this.firePropertyChange(new PropertyChangeEvent(this.source, null, null, 4));
    }

    public void firePropertyValidValuesChanged() {
        this.firePropertyChange(new PropertyChangeEvent(this.source, null, null, 3));
    }

    public void firePropertyValueChange(Object oldValue, Object newValue) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, oldValue, newValue, 0));
    }

    public void fireVetoableChange(Object oldValue, Object newValue) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, oldValue, newValue, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        Vector targets = null;
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            if (this.vetoableChangeListeners != null) {
                targets = (Vector)this.vetoableChangeListeners.clone();
            }
        }
        if (targets != null) {
            PropertyVetoException warningException = null;
            int i = targets.size();
            while (--i >= 0) {
                IVetoableChangeListenerInterface target = (IVetoableChangeListenerInterface)targets.elementAt(i);
                try {
                    target.vetoableChange(event);
                }
                catch (PropertyVetoException e) {
                    if (e.getErrorCode() == 0) {
                        throw e;
                    }
                    if (e.getErrorCode() != 1) continue;
                    warningException = e;
                }
            }
            if (warningException != null) {
                throw warningException;
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public synchronized void removeVetoableChangeListener(IVetoableChangeListenerInterface listener) {
        this.vetoableChangeListeners.remove(listener);
    }

    public void fireTableRowAdd(SingleValuedProperty[] row) {
        if (this.source instanceof TableProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, row, null, 12));
        }
    }

    public void fireTableRowRemove(SingleValuedProperty[] row) {
        if (this.source instanceof TableProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, null, row, 13));
        }
    }

    public void fireTableRowMove(int to, int from) {
        if (this.source instanceof TableProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, new Integer(to), new Integer(from), 14));
        }
    }

    public void fireTableCleared() {
        if (this.source instanceof TableProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, null, null, 15));
        }
    }

    public void fireMultiValuePropertySelection(int[] oldSelection, int[] newSelection) {
        if (this.source instanceof MultiValuedProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, oldSelection, newSelection, 16));
        }
    }

    public void fireTreeNodeHighLighted() {
        if (this.source instanceof NodeProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, Boolean.TRUE, Boolean.FALSE, 17));
        }
    }

    public void fireTreeNodeDehighLighted() {
        if (this.source instanceof NodeProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, Boolean.FALSE, Boolean.TRUE, 18));
        }
    }
}

