/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.PropertyVetoException;
import com.ibm.adapter.emd.extension.properties.SingleTypedPropertyImpl;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.MultiValuedProperty;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class MultiValuedPropertyImpl
extends SingleTypedPropertyImpl
implements MultiValuedProperty {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected List values = new ArrayList();
    protected int[] selection = new int[0];
    private boolean duplicates = false;
    private int selectionStyle = 1;

    @Override
    public void vetoableChange(PropertyEvent evt) throws PropertyVetoException {
    }

    public MultiValuedPropertyImpl(String propertyName, Class propertyType) throws MetadataException {
        super(propertyName, propertyType);
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
            LogFacility.traceLogger.log(Level.FINEST, "Name : " + propertyName);
            LogFacility.TrcExit();
        }
    }

    public void setDuplicates(boolean duplicates) {
        this.duplicates = duplicates;
    }

    public void addValue(Object value) throws MetadataException {
        if (this.duplicates || !this.values.contains(value)) {
            this.addValue(value, this.values.size());
        }
    }

    public void addValue(Object value, int index) throws MetadataException, IndexOutOfBoundsException {
        if (!this.duplicates && this.values.contains(value)) {
            return;
        }
        if (index > this.values.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.isEnabled()) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_PG_IS_DISABLED, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new MetadataException(MessageResource.ERR_PG_IS_DISABLED);
        }
        if (this.propertyType.getType().isAssignableFrom(value.getClass())) {
            block7: {
                try {
                    this.vetoableChanges.fireVetoableChange(null, value);
                }
                catch (PropertyVetoException ex) {
                    if (ex.getErrorCode() == 0) {
                        throw new MetadataException(ex.getLocalizedMessage(), (Throwable)ex);
                    }
                    if (ex.getErrorCode() != 1) break block7;
                    this.values.add(value);
                    this.setSet(true);
                    this.propertyChanges.firePropertyValueChange(null, value);
                    throw new MetadataException(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            this.values.add(index, value);
            this.setSet(true);
            this.propertyChanges.firePropertyValueChange(null, value);
            return;
        }
        Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_INVALID_PROPERTY_TYPE, null);
        LogFacility.logErrorMessage((IStatus)status);
        throw new MetadataException(MessageResource.ERR_INVALID_PROPERTY_TYPE);
    }

    public void addValueAsString(String value) throws MetadataException {
        Object obj = this.convertStringValue(value);
        this.addValue(obj);
    }

    public void addValueAsString(String value, int index) throws MetadataException, IndexOutOfBoundsException {
        Object obj = this.convertStringValue(value);
        this.addValue(obj, index);
    }

    @Override
    public Object clone() {
        MultiValuedPropertyImpl prop = (MultiValuedPropertyImpl)super.clone();
        prop.values = new ArrayList();
        try {
            int i = 0;
            while (i < this.values.size()) {
                prop.addValue(this.values.get(i));
                ++i;
            }
        }
        catch (Exception exception) {}
        return prop;
    }

    public Object get(int index) throws IndexOutOfBoundsException {
        return Collections.unmodifiableList(this.values).get(index);
    }

    public Object[] getValues() {
        return Collections.unmodifiableList(this.values).toArray();
    }

    public String[] getValuesAsStrings() {
        Object[] currentValues = this.getValues();
        String[] stringValues = new String[currentValues.length];
        int i = currentValues.length;
        while (--i >= 0) {
            if (currentValues[i] == null) continue;
            stringValues[i] = currentValues[i].toString();
        }
        return stringValues;
    }

    public Object removeValue(int index) {
        return this.values.remove(index);
    }

    public boolean removeValue(Object value) {
        if (!this.isEnabled()) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_CANNOT_REMOVE, null);
            LogFacility.logErrorMessage((IStatus)status);
        }
        boolean returnValue = this.values.remove(value);
        if (this.values.isEmpty()) {
            this.setSet(false);
        } else {
            this.setSet(true);
        }
        return returnValue;
    }

    public boolean removeValueAsString(String value) {
        try {
            Object obj = this.convertStringValue(value);
            return this.values.remove(obj);
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public void unSet() {
        this.values.clear();
        this.setSet(false);
    }

    private Object convertStringValue(String newValue) throws MetadataException {
        if (this.propertyType.isPrimitive() && newValue == null) {
            throw new MetadataException(NLS.bind((String)MessageResource.ERR_PRIMITIVE_TYPE_CANNOT_BE_NULL, (Object)this.getDisplayName()));
        }
        switch (this.propertyType.getPropertyTypeIdentifier()) {
            case 1: {
                return new Boolean(newValue);
            }
            case 2: {
                try {
                    return new Byte(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 3: {
                if (newValue != null && newValue.length() >= 1) {
                    int charValue = UTF16.charAt((String)newValue, (int)0);
                    return new Character(UCharacter.toChars((int)charValue)[0]);
                }
                throw new MetadataException(MessageResource.ERR_INVALID_STRING);
            }
            case 4: {
                try {
                    return new Double(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 5: {
                try {
                    return new Float(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 6: {
                try {
                    return new Integer(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 7: {
                try {
                    return new Long(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 9: {
                try {
                    return new Short(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 11: {
                try {
                    return new BigDecimal(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 10: {
                try {
                    return new BigInteger(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 0: {
                return newValue;
            }
        }
        throw new MetadataException(MessageResource.ERR_SET_AS_STRING_NOT_SUPPORTED);
    }

    @Override
    public void propertyChange(PropertyEvent arg0) {
    }

    public boolean allowDuplicateValues() {
        return this.duplicates;
    }

    public void setSelection(int[] indices) {
        if (indices == null) {
            indices = new int[]{};
        }
        int[] oldSelection = this.selection;
        this.selection = indices;
        this.propertyChanges.fireMultiValuePropertySelection(oldSelection, this.selection);
    }

    public int[] getSelection() {
        return this.selection;
    }

    public int getSelectionStyle() {
        return this.selectionStyle;
    }

    public void setSelectionStyle(int selectionStyle) {
        this.selectionStyle = selectionStyle;
    }
}

