/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.BindingTypePropertyImpl;
import com.ibm.adapter.emd.extension.properties.MultiValuedPropertyImpl;
import com.ibm.adapter.emd.extension.properties.PropertyDescriptorImpl;
import com.ibm.adapter.emd.extension.properties.PropertyGroupImpl;
import com.ibm.adapter.emd.extension.properties.PropertyVetoException;
import com.ibm.adapter.emd.extension.properties.SingleTypedPropertyImpl;
import com.ibm.adapter.emd.extension.properties.SingleValuedPropertyImpl;
import com.ibm.adapter.emd.internal.LogFacility;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import commonj.connector.metadata.discovery.properties.extensions.BindingTypeBeanProperty;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JavaBeanPropertyGroup
extends PropertyGroupImpl {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static commonj.connector.metadata.discovery.properties.PropertyDescriptor[] getPropertyDescriptorArray(Class bean, PropertyGroup parentGroup) throws CoreException {
        List propertyDescriptors = JavaBeanPropertyGroup.getPropertyDescriptorList(bean, parentGroup);
        commonj.connector.metadata.discovery.properties.PropertyDescriptor[] descriptors = new commonj.connector.metadata.discovery.properties.PropertyDescriptor[propertyDescriptors.size()];
        propertyDescriptors.toArray(descriptors);
        return descriptors;
    }

    public static List getPropertyDescriptorList(Class bean, PropertyGroup parentGroup) throws CoreException {
        ArrayList<PropertyDescriptorImpl> propertyDescriptors = new ArrayList<PropertyDescriptorImpl>();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bean.getClassLoader());
        try {
            Object beanInstance = bean.newInstance();
            BeanInfo bInfo = Introspector.getBeanInfo(bean);
            PropertyDescriptor[] properties = bInfo.getPropertyDescriptors();
            if (properties.length > 0) {
                propertyDescriptors.ensureCapacity(properties.length);
                int i = 0;
                while (i < properties.length) {
                    if (properties[i].getReadMethod() != null && properties[i].getWriteMethod() != null) {
                        Object defaultValue = null;
                        try {
                            defaultValue = properties[i].getReadMethod().invoke(beanInstance, null);
                        }
                        catch (IllegalArgumentException e1) {
                            LogFacility.logErrorMessage((String)e1.getLocalizedMessage(), (Throwable)e1);
                        }
                        catch (IllegalAccessException e1) {
                            LogFacility.logErrorMessage((String)e1.getLocalizedMessage(), (Throwable)e1);
                        }
                        catch (InvocationTargetException e1) {
                            LogFacility.logErrorMessage((String)e1.getLocalizedMessage(), (Throwable)e1);
                        }
                        catch (RuntimeException e) {
                            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                        }
                        Class<?> typeClass = properties[i].getPropertyType();
                        Class<?> arrayType = null;
                        boolean isArray = false;
                        if (typeClass.isArray()) {
                            arrayType = typeClass;
                            typeClass = arrayType.getComponentType();
                            isArray = true;
                        }
                        if (typeClass != null) {
                            Class<?> propertyType = null;
                            if (typeClass.equals(String.class) || typeClass.equals(Integer.TYPE) || typeClass.equals(Integer.class) || typeClass.equals(Boolean.TYPE) || typeClass.equals(Boolean.class) || typeClass.equals(Byte.TYPE) || typeClass.equals(Byte.class) || typeClass.equals(Character.TYPE) || typeClass.equals(Character.class) || typeClass.equals(Double.TYPE) || typeClass.equals(Double.class) || typeClass.equals(Float.TYPE) || typeClass.equals(Float.class) || typeClass.equals(Long.TYPE) || typeClass.equals(Long.class) || typeClass.equals(Short.TYPE) || typeClass.equals(Short.class) || typeClass.equals(BigInteger.class) || typeClass.equals(BigDecimal.class)) {
                                propertyType = typeClass;
                            }
                            if (propertyType != null) {
                                SingleTypedPropertyImpl propertyDescriptor;
                                if (isArray) {
                                    propertyDescriptor = new JavaBeanArrayPropertyDescriptor(properties[i].getName(), properties[i].getDisplayName(), properties[i].getShortDescription(), propertyType, parentGroup);
                                    propertyDescriptor.setDefaultValue(defaultValue);
                                    ((JavaBeanArrayPropertyDescriptor)propertyDescriptor).setWriteMethod(properties[i].getWriteMethod());
                                    ((JavaBeanArrayPropertyDescriptor)propertyDescriptor).setBeanInstance(beanInstance);
                                    propertyDescriptors.add(propertyDescriptor);
                                } else {
                                    propertyDescriptor = new JavaBeanPropertyDescriptor(properties[i].getName(), properties[i].getDisplayName(), properties[i].getShortDescription(), propertyType, parentGroup);
                                    propertyDescriptor.setDefaultValue(defaultValue);
                                    ((JavaBeanPropertyDescriptor)propertyDescriptor).setWriteMethod(properties[i].getWriteMethod());
                                    ((JavaBeanPropertyDescriptor)propertyDescriptor).setBeanInstance(beanInstance);
                                    propertyDescriptors.add(propertyDescriptor);
                                }
                            } else if (typeClass.equals(BindingTypeBeanProperty.class)) {
                                BindingTypePropertyImpl btp = new BindingTypePropertyImpl(properties[i].getName());
                                BindingTypeBeanProperty btpBean = null;
                                try {
                                    btpBean = (BindingTypeBeanProperty)properties[i].getReadMethod().invoke(beanInstance, null);
                                }
                                catch (IllegalArgumentException e1) {
                                    LogFacility.logErrorMessage((String)e1.getLocalizedMessage(), (Throwable)e1);
                                }
                                catch (IllegalAccessException e1) {
                                    LogFacility.logErrorMessage((String)e1.getLocalizedMessage(), (Throwable)e1);
                                }
                                catch (InvocationTargetException e1) {
                                    LogFacility.logErrorMessage((String)e1.getLocalizedMessage(), (Throwable)e1);
                                }
                                catch (RuntimeException e) {
                                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                                }
                                if (btpBean != null) {
                                    ArrayList<String> list = new ArrayList<String>();
                                    String[] tags = btpBean.getTags();
                                    int j = 0;
                                    while (j < tags.length) {
                                        list.add(tags[j]);
                                        ++j;
                                    }
                                    btp.setTags(list);
                                    btp.setDefaultValue(btpBean.getValue());
                                }
                                propertyDescriptors.add(btp);
                                ((PropertyGroupImpl)parentGroup).addProperty(btp);
                            } else {
                                try {
                                    Constructor<?> defaultCtor = typeClass.getConstructor(null);
                                    if (defaultCtor != null) {
                                        JavaBeanPropertyGroup propertyGroup = new JavaBeanPropertyGroup(typeClass, properties[i].getName(), properties[i].getDisplayName(), properties[i].getShortDescription());
                                        propertyDescriptors.add(propertyGroup);
                                        ((PropertyGroupImpl)parentGroup).addProperty(propertyGroup);
                                    }
                                }
                                catch (NoSuchMethodException noSuchMethodException) {}
                            }
                        }
                    }
                    ++i;
                }
            }
            ArrayList<PropertyDescriptorImpl> arrayList = propertyDescriptors;
            return arrayList;
        }
        catch (InstantiationException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (IllegalAccessException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (IntrospectionException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (MetadataException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public JavaBeanPropertyGroup(Class bean, String description) throws CoreException, MetadataException {
        super(bean.getName());
        this.setDescription(description);
        try {
            JavaBeanPropertyGroup.getPropertyDescriptorList(bean, this);
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            throw e;
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
    }

    protected JavaBeanPropertyGroup(Class bean, String name, String displayName, String description) throws CoreException, MetadataException {
        super(name);
        this.setDisplayName(displayName);
        this.setDescription(description);
        try {
            JavaBeanPropertyGroup.getPropertyDescriptorList(bean, this);
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            throw e;
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
    }

    public static class JavaBeanArrayPropertyDescriptor
    extends MultiValuedPropertyImpl {
        private Object beanInstance;
        private Method writeMethod;

        public JavaBeanArrayPropertyDescriptor(String propertyName, String displayName, String propertyDescription, Class propertyType, PropertyGroup group) throws MetadataException {
            super(propertyName, propertyType);
            this.setDisplayName(displayName);
            this.setDescription(propertyDescription);
            if (group != null) {
                ((PropertyGroupImpl)group).addProperty(this);
            }
            this.addVetoablePropertyChangeListener(this);
        }

        @Override
        public Object clone() {
            JavaBeanArrayPropertyDescriptor property = (JavaBeanArrayPropertyDescriptor)super.clone();
            property.addVetoablePropertyChangeListener(property);
            return property;
        }

        public Object getBeanInstance() {
            return this.beanInstance;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public void setBeanInstance(Object beanInstance) {
            this.beanInstance = beanInstance;
        }

        public void setWriteMethod(Method writeMethod) {
            this.writeMethod = writeMethod;
        }

        @Override
        public void vetoableChange(PropertyEvent evt) throws PropertyVetoException {
            if (evt.getSource() != this || this.writeMethod == null || this.beanInstance != null) {
                // empty if block
            }
        }
    }

    public static class JavaBeanPropertyDescriptor
    extends SingleValuedPropertyImpl {
        private Object beanInstance;
        private Method writeMethod;

        public JavaBeanPropertyDescriptor(String propertyName, String displayName, String propertyDescription, Class propertyType, PropertyGroup group) throws MetadataException {
            super(propertyName, propertyType);
            this.setDisplayName(displayName);
            this.setDescription(propertyDescription);
            if (group != null) {
                ((PropertyGroupImpl)group).addProperty(this);
            }
            this.addVetoablePropertyChangeListener(this);
        }

        @Override
        public Object clone() {
            JavaBeanPropertyDescriptor property = (JavaBeanPropertyDescriptor)super.clone();
            property.addVetoablePropertyChangeListener(property);
            return property;
        }

        public Object getBeanInstance() {
            return this.beanInstance;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public void setBeanInstance(Object beanInstance) {
            this.beanInstance = beanInstance;
        }

        public void setWriteMethod(Method writeMethod) {
            this.writeMethod = writeMethod;
        }

        @Override
        public void vetoableChange(PropertyEvent evt) throws PropertyVetoException {
            if (evt.getSource() == this && this.writeMethod != null && this.beanInstance != null) {
                try {
                    this.writeMethod.invoke(this.beanInstance, evt.getNewValue());
                }
                catch (IllegalArgumentException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw new PropertyVetoException(e.getLocalizedMessage(), (PropertyChangeEvent)evt);
                }
                catch (IllegalAccessException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw new PropertyVetoException(e.getLocalizedMessage(), (PropertyChangeEvent)evt);
                }
                catch (InvocationTargetException e) {
                    String message = e.getLocalizedMessage() == null ? (e.getTargetException() != null ? e.getTargetException().getLocalizedMessage() : (e.getCause() != null ? e.getCause().getLocalizedMessage() : "")) : e.getLocalizedMessage();
                    LogFacility.logErrorMessage((String)message, (Throwable)e);
                    throw new PropertyVetoException(message, (PropertyChangeEvent)evt);
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw new PropertyVetoException(e.getLocalizedMessage(), (PropertyChangeEvent)evt);
                }
            }
        }
    }
}

