/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.db.generic.internal;

import com.ibm.ims.datatools.sqltools.db.generic.internal.Messages;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class GenericPlugin
extends Plugin {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static final int INTERNAL_ERROR = 0;
    private static GenericPlugin plugin;

    public GenericPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static GenericPlugin getDefault() {
        return plugin;
    }

    public void log(IStatus status) {
        int severity = status.getSeverity();
        switch (severity) {
            case 0: {
                logger.fine(status.getMessage());
                break;
            }
            case 4: {
                logger.error(status.getMessage(), status.getException(), new Object[0]);
                break;
            }
            case 2: {
                logger.warn(status.getMessage(), status.getException(), new Object[0]);
                break;
            }
            default: {
                logger.info(status.getMessage(), status.getException(), new Object[0]);
            }
        }
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public void log(String message, Throwable e) {
        this.log(this.createErrorStatus(message, e));
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, null);
    }

    public IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, e);
    }

    public IStatus createErrorStatus(Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, Messages.plugin_internal_error, e);
    }
}

