/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca.spi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.Bundle;

public class WASRuntimeLocator {
    public static final byte UNKNOWN_RUNTIME_LOCATOR_TYPE = 0;
    public static final byte BASE_STUB = 1;
    public static final byte BASE_V7 = 35;
    public static final byte BI_V75 = 36;
    public static final byte BASE_V7_STUB = 37;
    public static final byte BI_V75_STUB = 38;
    public static final byte BASE_V8 = 39;
    public static final byte BI_V8 = 40;
    public static final byte BASE_V8_STUB = 41;
    public static final byte BI_V8_STUB = 42;
    public static final byte BASE_V85 = 43;
    public static final byte BI_V85 = 44;
    public static final byte BASE_V85_STUB = 45;
    public static final byte BI_V85_STUB = 46;
    public static final byte BASE_V90 = 47;
    public static final byte BI_V90 = 48;
    public static final byte BASE_V90_STUB = 49;
    public static final byte BI_V90_STUB = 50;
    private static final byte RUNTIME_COUNT = 28;
    private static final String[] paths = new String[]{"UNKNOWN", "base_stub", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "base_v7", "bi_v75", "base_v7_stub", "bi_v75_stub", "base_v8", "bi_v8", "base_v8_stub", "bi_v8_stub", "base_v85", "bi_v85", "base_v85_stub", "bi_v85_stub", "base_v90", "bi_v90", "base_v90_stub", "bi_v90_stub"};
    private static Properties runtimeVerifyProps = null;
    private static Hashtable<String, IPath> runtimeLocationCache = new Hashtable();

    private static String convertToGenericRuntimeType(byte runtime) {
        switch (runtime) {
            case 35: {
                return "com.ibm.ws.ast.st.runtime.v70";
            }
            case 39: {
                return "com.ibm.ws.ast.st.runtime.v80";
            }
            case 43: {
                return "com.ibm.ws.ast.st.runtime.v85";
            }
            case 47: {
                return "com.ibm.ws.ast.st.runtime.v90";
            }
        }
        return null;
    }

    public static byte convertGenericToLocatorRuntimeType(IRuntime runtime) {
        if (runtime == null) {
            return 0;
        }
        String curRuntimeType = runtime.getRuntimeType().getId();
        boolean curIsStub = runtime.isStub();
        if (curRuntimeType == null) {
            return 0;
        }
        if (curRuntimeType.equals("com.ibm.ws.ast.st.runtime.v70")) {
            return curIsStub ? (byte)37 : 35;
        }
        if (curRuntimeType.equals("com.ibm.ws.ast.st.runtime.v80")) {
            return curIsStub ? (byte)41 : 39;
        }
        if (curRuntimeType.equals("com.ibm.ws.ast.st.runtime.v85")) {
            return curIsStub ? (byte)45 : 43;
        }
        if (curRuntimeType.equals("com.ibm.ws.ast.st.runtime.v90")) {
            return curIsStub ? (byte)49 : 47;
        }
        return 0;
    }

    public static IPath getCompatibleRuntimeLocation(byte runtime) {
        return WASRuntimeLocator.getCompatibleRuntimeLocation(runtime, false);
    }

    public static IPath getCompatibleRuntimeLocation(byte runtime, boolean isFindStackProductRuntime) {
        switch (runtime) {
            case 37: {
                IPath path = WASRuntimeLocator.getRuntimeLocation((byte)35);
                if (path == null) {
                    path = WASRuntimeLocator.getRuntimeLocation((byte)37);
                }
                if (isFindStackProductRuntime && path == null) break;
                return path;
            }
            case 41: {
                IPath path = WASRuntimeLocator.getRuntimeLocation((byte)39);
                if (path == null) {
                    path = WASRuntimeLocator.getRuntimeLocation((byte)41);
                }
                if (isFindStackProductRuntime && path == null) break;
                return path;
            }
            case 45: {
                IPath path = WASRuntimeLocator.getRuntimeLocation((byte)43);
                if (path == null) {
                    path = WASRuntimeLocator.getRuntimeLocation((byte)45);
                }
                if (isFindStackProductRuntime && path == null) break;
                return path;
            }
            case 49: {
                IPath path = WASRuntimeLocator.getRuntimeLocation((byte)47);
                if (path == null) {
                    path = WASRuntimeLocator.getRuntimeLocation((byte)49);
                }
                if (isFindStackProductRuntime && path == null) break;
                return path;
            }
        }
        boolean keepTrying = true;
        while (keepTrying) {
            IPath path;
            IPath iPath = path = isFindStackProductRuntime ? WASRuntimeLocator.getRuntimeLocation(runtime, false, true) : WASRuntimeLocator.getRuntimeLocation(runtime);
            if (path != null) {
                return path;
            }
            if (!(isFindStackProductRuntime || runtime != 36 && runtime != 40 && runtime != 44 && runtime != 48)) {
                keepTrying = false;
                continue;
            }
            if (isFindStackProductRuntime && (runtime == 38 || runtime == 42 || runtime == 46 || runtime == 50)) {
                keepTrying = false;
                continue;
            }
            runtime = (byte)(runtime + 1);
        }
        return null;
    }

    public static byte[] getInstalledRuntimes() {
        int count = 0;
        byte[] runtimeTemp = new byte[28];
        byte b = 0;
        while (b < 28) {
            if (WASRuntimeLocator.getRuntimeLocation(b) != null) {
                runtimeTemp[count] = b;
                ++count;
            }
            b = (byte)(b + 1);
        }
        byte[] runtimes = new byte[count];
        System.arraycopy(runtimeTemp, 0, runtimes, 0, count);
        return runtimes;
    }

    public static boolean getIsRuntimeExists(IPath path, byte runtime) {
        return WASRuntimeLocator.getIsRuntimeExists(path, runtime, false);
    }

    private static boolean getIsRuntimeExists(IPath path, byte runtime, boolean isFindSkeletonStub) {
        if (path == null || !path.toFile().exists()) {
            return false;
        }
        boolean result = true;
        Iterator curRuntimeVerifyIter = WASRuntimeLocator.getRuntimeVerifyList(paths[runtime]).iterator();
        while (result && curRuntimeVerifyIter.hasNext()) {
            if (path.append((String)curRuntimeVerifyIter.next()).toFile().exists()) continue;
            result = false;
        }
        if (!result && isFindSkeletonStub) {
            result = true;
            curRuntimeVerifyIter = WASRuntimeLocator.getRuntimeVerifyList(String.valueOf(paths[runtime]) + "_skeleton").iterator();
            while (result && curRuntimeVerifyIter.hasNext()) {
                if (path.append((String)curRuntimeVerifyIter.next()).toFile().exists()) continue;
                result = false;
            }
        }
        return result;
    }

    public static IPath getRuntimeLocation(byte runtime) {
        return WASRuntimeLocator.getRuntimeLocation(runtime, true);
    }

    protected static List<IRuntime> getRuntimes(IRuntimeType runtimeType) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                IRuntime runtime = runtimes[i];
                if (runtime.getRuntimeType() != null && runtime.getRuntimeType().equals(runtimeType)) {
                    list.add(runtime);
                }
                ++i;
            }
        }
        return list;
    }

    public static IPath getRuntimeLocation(byte runtime, boolean includeExternal) {
        return WASRuntimeLocator.getRuntimeLocation(runtime, includeExternal, false);
    }

    public static IPath getRuntimeStubLocation(byte runtime, boolean isFindSkeletonStub) {
        return WASRuntimeLocator.getRuntimeLocation(runtime, true, true, isFindSkeletonStub);
    }

    public static IPath getRuntimeStubLocation(byte runtime) {
        return WASRuntimeLocator.getRuntimeStubLocation(runtime, false);
    }

    private static IPath getRuntimeLocation(byte runtime, boolean includeExternal, boolean isStub) {
        return WASRuntimeLocator.getRuntimeLocation(runtime, includeExternal, isStub, false);
    }

    private static IPath getRuntimeLocation(byte runtime, boolean includeExternal, boolean isStub, boolean isFindSkeletonStub) {
        Path path;
        Bundle bundle;
        block19: {
            String genericRuntimeType;
            IPath cachedRuntimeLocation;
            if (!isStub && (cachedRuntimeLocation = runtimeLocationCache.get(paths[runtime])) != null) {
                return cachedRuntimeLocation;
            }
            if (WASRuntimeLocator.isServerCorePluginInitialized() && (genericRuntimeType = WASRuntimeLocator.convertToGenericRuntimeType(runtime)) != null) {
                try {
                    List<IRuntime> curRuntimeLst;
                    IRuntimeType curRuntimeType = ServerCore.findRuntimeType((String)genericRuntimeType);
                    if (curRuntimeType != null && (curRuntimeLst = WASRuntimeLocator.getRuntimes(curRuntimeType)) != null) {
                        for (IRuntime curRuntime : curRuntimeLst) {
                            IPath path2;
                            if (!includeExternal && !curRuntime.getId().startsWith("was.") || curRuntime.isStub() || !WASRuntimeLocator.getIsRuntimeExists(path2 = curRuntime.getLocation(), runtime, isFindSkeletonStub)) continue;
                            if (!isStub) {
                                runtimeLocationCache.put(paths[runtime], path2);
                            }
                            return path2;
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
            try {
                IPath path3;
                String runtimeLoc = System.getProperty("was.runtime");
                if (runtimeLoc != null && WASRuntimeLocator.getIsRuntimeExists(path3 = new Path(runtimeLoc).append(paths[runtime]), runtime, isFindSkeletonStub)) {
                    if (!isStub) {
                        runtimeLocationCache.put(paths[runtime], path3);
                    }
                    return path3;
                }
                bundle = Platform.getBundle((String)"com.ibm.ws.ast.st.core");
                if (bundle != null) break block19;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        URL installURL = bundle.getEntry("/");
        URL realURL = FileLocator.resolve((URL)installURL);
        Path pluginPath = new Path(new File(realURL.getFile()).getAbsolutePath());
        IPath rootPath = pluginPath.removeLastSegments(3);
        String wasInstallDir = System.getProperty("wrd.runtime");
        if (wasInstallDir != null) {
            path = new Path(wasInstallDir);
            if ((runtime == 35 || runtime == 39 || runtime == 43 || runtime == 47) && WASRuntimeLocator.getIsRuntimeExists((IPath)path, runtime, isFindSkeletonStub)) {
                runtimeLocationCache.put(paths[runtime], (IPath)path);
                return path;
            }
        }
        if (rootPath != null) {
            path = rootPath.append("runtimes").append(paths[runtime]);
            if (WASRuntimeLocator.getIsRuntimeExists((IPath)path, runtime, isFindSkeletonStub)) {
                if (!isStub) {
                    runtimeLocationCache.put(paths[runtime], (IPath)path);
                }
                return path;
            }
            if (rootPath.segmentCount() > 1 && WASRuntimeLocator.getIsRuntimeExists((IPath)(path = rootPath.removeLastSegments(1).append("runtimes").append(paths[runtime])), runtime, isFindSkeletonStub)) {
                if (!isStub) {
                    runtimeLocationCache.put(paths[runtime], (IPath)path);
                }
                return path;
            }
        }
        return null;
    }

    public static String getRuntimeLocatorPluginLocation() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.ws.ast.st.core");
        if (bundle == null) {
            return null;
        }
        URL installURL = bundle.getEntry("/");
        String installLocation = null;
        try {
            URL realURL = FileLocator.resolve((URL)installURL);
            installLocation = realURL.getFile();
            if (installLocation != null && installLocation.startsWith("/") && installLocation.indexOf(":") > 0 && !(installLocation = installLocation.substring(1)).endsWith("/")) {
                installLocation = String.valueOf(installLocation) + "/";
            }
        }
        catch (IOException iOException) {}
        return installLocation;
    }

    private static List getRuntimeVerifyList(String runtimePath) {
        String curRuntimeVerifyStr;
        ArrayList<String> runtimeVerifyLst;
        block18: {
            runtimeVerifyLst = new ArrayList<String>();
            if (runtimeVerifyProps == null) {
                runtimeVerifyProps = new Properties();
                String curPluginLocation = WASRuntimeLocator.getRuntimeLocatorPluginLocation();
                if (curPluginLocation != null) {
                    FileInputStream fp = null;
                    try {
                        try {
                            fp = new FileInputStream(String.valueOf(curPluginLocation) + "runtimeCheck.properties");
                            runtimeVerifyProps.load(fp);
                        }
                        catch (IOException iOException) {
                            if (fp != null) {
                                try {
                                    fp.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fp != null) {
                            try {
                                fp.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (fp != null) {
                        try {
                            fp.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if ((curRuntimeVerifyStr = (String)runtimeVerifyProps.get(runtimePath)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(curRuntimeVerifyStr, ",");
            while (tokenizer.hasMoreElements()) {
                runtimeVerifyLst.add(((String)tokenizer.nextElement()).trim());
            }
        }
        return runtimeVerifyLst;
    }

    public static byte getStubServerType(byte curServerType) {
        int stubServerType = curServerType;
        boolean keepTrying = true;
        while (keepTrying && curServerType >= 0) {
            switch (curServerType) {
                case 35: 
                case 37: {
                    keepTrying = false;
                    stubServerType = 37;
                    break;
                }
                case 39: 
                case 41: {
                    keepTrying = false;
                    stubServerType = 41;
                    break;
                }
                case 43: 
                case 45: {
                    keepTrying = false;
                    stubServerType = 45;
                    break;
                }
                case 47: 
                case 49: {
                    keepTrying = false;
                    stubServerType = 49;
                    break;
                }
                default: {
                    curServerType = (byte)(curServerType - 1);
                }
            }
        }
        return (byte)stubServerType;
    }

    private static boolean isServerCorePluginInitialized() {
        Bundle serverCoreBundle = Platform.getBundle((String)"org.eclipse.wst.server.core");
        return serverCoreBundle == null ? false : serverCoreBundle.getState() == 32;
    }
}

