/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca.internal;

import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.internal.LogFacility;
import com.ibm.adapter.j2ca.internal.ResourceAdapterRegistry;
import com.ibm.adapter.j2ca.spi.util.ConnectorProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;

public class ConnectorChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        try {
            switch (event.getType()) {
                case 8: {
                    if (event.getBuildKind() == 15) {
                        IProject connProject;
                        if (event.getSource() instanceof IProject && ConnectorProjectHelper.isConnectorProject(connProject = (IProject)event.getSource()) != null) {
                            IResourceAdapterDescriptor desc = ResourceAdapterRegistry.getRegistry().getResourceAdapterForProject(connProject);
                            if (desc != null) {
                                ResourceAdapterRegistry.getRegistry().removeResourceAdapter(desc);
                            }
                            ResourceAdapterRegistry.getRegistry().addResourceAdapter(connProject);
                        }
                    } else if (event.getDelta() != null) {
                        IResourceDelta[] topLevelChilren = event.getDelta().getAffectedChildren(7);
                        int i = topLevelChilren.length;
                        while (--i >= 0) {
                            topLevelChilren[i].accept((IResourceDeltaVisitor)ResourceAdapterRegistry.getRegistry());
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

