/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.j2c.properties;

import com.ibm.propertygroup.spi.common.JavaPackageProperty;
import com.ibm.propertygroup.spi.common.JavaProjectProperty;
import com.ibm.record.writer.j2c.properties.DataBindingPropertyGroup;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class PropertyPopulator {
    public static void populateDataBindingPropertyGroupFromContext(DataBindingPropertyGroup pg, Object[] context) {
        IProject project;
        if (context == null || context.length != 1) {
            return;
        }
        if (pg == null) {
            return;
        }
        Object obj = context[0];
        if (obj instanceof IJavaElement) {
            obj = ((IJavaElement)obj).getResource();
        }
        if ((project = PropertyPopulator.getProjectFromObject(obj)) != null) {
            try {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                JavaProjectProperty jpp = pg.getProjectProperty();
                jpp.setValue((Object)javaProject);
                IFolder folder = PropertyPopulator.getFolderFromObject(obj);
                if (PropertyPopulator.isFolderValid(javaProject, folder)) {
                    JavaPackageProperty pkgProp = pg.getPackageProperty();
                    IPackageFragment pkgFrag = javaProject.findPackageFragment(folder.getFullPath());
                    pkgProp.setValue((Object)pkgFrag);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private static IProject getProjectFromObject(Object obj) {
        if (obj instanceof IProject) {
            return (IProject)obj;
        }
        if (obj instanceof IFolder) {
            IFolder folder = (IFolder)obj;
            return folder.getProject();
        }
        if (obj instanceof IResource) {
            IContainer parent = ((IResource)obj).getParent();
            if (parent instanceof IProject) {
                return (IProject)parent;
            }
            if (parent instanceof IFolder) {
                IFolder folder = (IFolder)parent;
                return folder.getProject();
            }
        }
        return null;
    }

    private static IFolder getFolderFromObject(Object obj) {
        if (obj instanceof IProject) {
            return null;
        }
        if (obj instanceof IFolder) {
            IFolder folder = (IFolder)obj;
            return folder;
        }
        if (obj instanceof IResource) {
            IContainer parent = ((IResource)obj).getParent();
            if (parent instanceof IProject) {
                return null;
            }
            if (parent instanceof IFolder) {
                IFolder folder = (IFolder)parent;
                return folder;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isFolderValid(IJavaProject javaProject, IFolder folder) {
        if (javaProject == null) return false;
        if (folder == null) {
            return false;
        }
        if ("gen".equalsIgnoreCase(folder.getProjectRelativePath().segment(0))) {
            return false;
        }
        try {
            IPath outputLocation = javaProject.getOutputLocation();
            if (outputLocation.lastSegment().equals(folder.getName())) {
                return false;
            }
            IPackageFragmentRoot[] fragmentRoots = javaProject.getPackageFragmentRoots();
            int j = 0;
            while (true) {
                IPath outputPath;
                if (j >= fragmentRoots.length) {
                    return true;
                }
                if (fragmentRoots[j].getKind() == 1 && (outputPath = fragmentRoots[j].getRawClasspathEntry().getOutputLocation()) != null && outputPath.lastSegment().equals(folder.getName())) {
                    return false;
                }
                ++j;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static IJavaProject getProjectFromContext(Object[] context) throws CoreException {
        if (context == null || context.length != 1) {
            return null;
        }
        Object obj = context[0];
        if (obj instanceof IJavaElement) {
            obj = ((IJavaElement)obj).getResource();
        }
        IProject project = PropertyPopulator.getProjectFromObject(obj);
        IJavaProject javaProject = null;
        if (project != null) {
            javaProject = JavaCore.create((IProject)project);
        }
        return javaProject;
    }

    public static IPackageFragment getPackageFromContext(Object[] context) throws CoreException {
        IFolder folder;
        IJavaProject javaProject;
        if (context == null || context.length != 1) {
            return null;
        }
        Object obj = context[0];
        if (obj instanceof IJavaElement) {
            obj = ((IJavaElement)obj).getResource();
        }
        IProject project = PropertyPopulator.getProjectFromObject(obj);
        IPackageFragment pkgFrag = null;
        if (project != null && PropertyPopulator.isFolderValid(javaProject = JavaCore.create((IProject)project), folder = PropertyPopulator.getFolderFromObject(obj))) {
            pkgFrag = javaProject.findPackageFragment(folder.getFullPath());
        }
        return pkgFrag;
    }
}

