/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.j2c;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.typesimport.api.ITypesImportCommand;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.lang.common.writer.CodegenUtil;
import com.ibm.lang.common.writer.NamingUtils;
import com.ibm.lang.common.writer.XSD2EMFConverter;
import com.ibm.record.writer.LogFacility;
import com.ibm.record.writer.MessageResource;
import com.ibm.record.writer.WriterPlugin;
import com.ibm.record.writer.internal.j2c.jet.CICSCharContainerJ2CRecordSkeletonEmitterJET;
import com.ibm.record.writer.internal.j2c.jet.J2CRecordSkeletonGenerationAdapter;
import com.ibm.record.writer.internal.j2c.jet.LanguageJ2CRecordSkeletonEmitterJET;
import com.ibm.record.writer.j2c.CreateJ2CRecordSkeleton;
import com.ibm.record.writer.j2c.UIUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;

public abstract class CreateLanguageJ2CRecordSkeleton
extends CreateJ2CRecordSkeleton {
    protected String containerName_ = null;
    protected String containerType_ = null;

    public CreateLanguageJ2CRecordSkeleton(IJavaProject project, IEnvironment environment) throws BaseException {
        super(project, environment);
    }

    public CreateLanguageJ2CRecordSkeleton(IJavaProject project, String packageName, String className, IEnvironment environment) throws BaseException {
        super(project, packageName, className, environment);
    }

    public CreateLanguageJ2CRecordSkeleton(IJavaProject project, String packageName, String className, String containerName, String containerType, IEnvironment environment) throws BaseException {
        super(project, packageName, className, environment);
        this.containerName_ = containerName;
        this.containerType_ = containerType;
    }

    private ICompilationUnit createSkeleton(IJavaProject project, EClass rootClass, EReference classReference, Map<ENamedElement, InstanceTDBase> EMFNamedElementToTDMap, Map<String, String> ODODependentMap, List<String> childClasses) throws BaseException {
        ICompilationUnit cu = null;
        cu = this.createCompilationUnit(project, rootClass);
        if (cu == null) {
            return cu;
        }
        Object emitterInstance = this.getEmitterInstance();
        J2CRecordSkeletonGenerationAdapter adapter = new J2CRecordSkeletonGenerationAdapter(cu, rootClass, classReference, EMFNamedElementToTDMap, ODODependentMap, childClasses, this.getLanguageType(), this.containerName_, this.containerType_, this.environment_);
        CodegenUtil.generate((ICompilationUnit)cu, (Object)emitterInstance, (Object)adapter, (IEnvironment)this.environment_);
        return cu;
    }

    private ICompilationUnit createCompilationUnit(IJavaProject project, EClass rootClass) throws BaseException {
        ICompilationUnit unit = null;
        String packageName = rootClass.getEPackage().getName();
        if (packageName == null) {
            return null;
        }
        String dataBindingName = rootClass.getName();
        unit = CodegenUtil.createCompilationUnit((IJavaProject)project, (String)packageName, (String)dataBindingName, (IEnvironment)this.environment_);
        UIUtils.closeOpenEditorForCU(unit, true);
        return unit;
    }

    protected abstract ITypesImportCommand getImportCommand();

    protected int getVAJGenerationStyle() {
        return 0;
    }

    protected abstract List<Object> getTypeList();

    protected abstract String getLanguageType();

    public ICompilationUnit[] createSkeleton() throws BaseException {
        IProgressMonitor progressMonitor = this.environment_.getProgressMonitor();
        progressMonitor.beginTask(MessageResource.DISP_PROG_MSG_PROCESS_META_DATA, 100);
        ITypesImportCommand command = this.getImportCommand();
        String namespace = NamingUtils.getXSDNamespaceFromPackageName((String)this.packageName_);
        command.setSchemaTargetNS(namespace);
        command.setTypes(this.getTypeList());
        IFile schemaFile = this.project_.getProject().getFile(String.valueOf(this.className_) + ".xsd");
        command.setSchemaFile(schemaFile);
        command.setModelResourceSet((ResourceSet)new ResourceSetImpl());
        command.setOverwriteTypes(true);
        command.setXSDTypeName(this.className_);
        command.setVAJGenerationStyle(this.getVAJGenerationStyle());
        command.setGenerateFlat(true);
        try {
            command.createResource((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exc) {
            String message = NLS.bind((String)MessageResource.ERR_CREATING_SCHEMA, (Object)schemaFile.getName());
            Status status = new Status(4, WriterPlugin.getPluginID(), 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
        progressMonitor.worked(15);
        Map typeMap = command.getXSDTypes();
        XSDComplexTypeDefinition rootTypeDefinition = null;
        if (typeMap != null) {
            rootTypeDefinition = (XSDComplexTypeDefinition)typeMap.get(this.className_);
        }
        if (rootTypeDefinition == null) {
            int char32 = UTF16.charAt((String)this.className_, (int)0);
            if (UCharacter.isLowerCase((int)char32)) {
                rootTypeDefinition = (XSDComplexTypeDefinition)typeMap.get(CodegenUtil.getUppercaseName((String)this.className_));
            }
            if (rootTypeDefinition == null) {
                String message = NLS.bind((String)MessageResource.ERR_SCHEMA_TYPE_DEF_NOT_FOUND, (Object)this.className_);
                Status status = new Status(4, WriterPlugin.getPluginID(), 4, message, null);
                LogFacility.logErrorMessage((IStatus)status);
                throw new BaseException((IStatus)status);
            }
            rootTypeDefinition.setName(this.className_);
        }
        Map xsdTypesTdBasePair = command.getXSDTypesTdBasePair();
        ICompilationUnit[] units = this.createSkeleton(rootTypeDefinition, this.className_, xsdTypesTdBasePair);
        progressMonitor.done();
        return units;
    }

    public ICompilationUnit[] createSkeleton(XSDComplexTypeDefinition rootTypeDefinition, String topLevelClassName, Map<XSDNamedComponent, InstanceTDBase> xsdTypesTdBasePair) throws BaseException {
        IProgressMonitor progressMonitor = this.environment_.getProgressMonitor();
        XSD2EMFConverter conv = new XSD2EMFConverter();
        XSDEcoreBuilder builder = conv.convertXSDToEMF(rootTypeDefinition.getSchema());
        EModelElement rootModelElem = (EModelElement)builder.getXSDComponentToEModelElementMap().get(rootTypeDefinition);
        if (!(rootModelElem instanceof EClass)) {
            String message = MessageResource.ERR_EMF_ROOT_ELEM_NOT_ECLASS;
            Status status = new Status(4, WriterPlugin.getPluginID(), 4, message, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
        ((EClass)rootModelElem).setName(topLevelClassName);
        final HashMap<ENamedElement, InstanceTDBase> EMFNamedElementToTDMap = new HashMap<ENamedElement, InstanceTDBase>();
        for (Map.Entry<XSDNamedComponent, InstanceTDBase> element : xsdTypesTdBasePair.entrySet()) {
            XSDNamedComponent xsdComp;
            XSDNamedComponent key = xsdComp = element.getKey();
            if (xsdComp instanceof XSDElementDeclaration) {
                key = xsdComp.eContainer();
            } else if (xsdComp instanceof XSDModelGroupDefinition) continue;
            ENamedElement newKey = (ENamedElement)builder.getXSDComponentToEModelElementMap().get(key);
            if (newKey == null) continue;
            EMFNamedElementToTDMap.put(newKey, element.getValue());
        }
        final EClass rootClass = (EClass)rootModelElem;
        final ArrayList<EReference> referenceList = new ArrayList<EReference>();
        this.getAllChildEReferences(referenceList, rootClass);
        final Map<String, String> ODODependentMap = this.preProcessODO(rootClass, referenceList, EMFNamedElementToTDMap);
        final ArrayList compilationUnits = new ArrayList();
        if (this.packageName_ != null && !rootClass.getEPackage().getName().equals(this.packageName_)) {
            rootClass.getEPackage().setName(this.packageName_);
        }
        if (this.className_ != null && !rootClass.getName().equals(this.className_)) {
            rootClass.setName(this.className_);
        }
        final ArrayList<String> childClasses = new ArrayList<String>();
        for (EReference aRef : referenceList) {
            InstanceTDBase tdBase = EMFNamedElementToTDMap.get(aRef);
            if (tdBase == null || tdBase instanceof SimpleInstanceTD) continue;
            EClass refClass = (EClass)aRef.getEType();
            if (tdBase.getArrayDescr().size() > 1) {
                EStructuralFeature feature = J2CRecordSkeletonGenerationAdapter.getBaseStructureFeatureForArraySF((EStructuralFeature)aRef, tdBase.getArrayDescr().size());
                refClass = (EClass)feature.getEType();
            }
            String packageName = refClass.getEPackage().getName();
            String className = refClass.getName();
            String qualifiedName = String.valueOf(packageName) + "." + className;
            childClasses.add(qualifiedName);
        }
        progressMonitor.subTask(NLS.bind((String)MessageResource.DISP_PROG_MSG_GENERATING_CLASS, (Object)(String.valueOf(rootClass.getEPackage().getName()) + "." + rootClass.getName())));
        progressMonitor.worked(15);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                ICompilationUnit parentClass = CreateLanguageJ2CRecordSkeleton.this.createSkeleton(CreateLanguageJ2CRecordSkeleton.this.project_, rootClass, null, EMFNamedElementToTDMap, ODODependentMap, childClasses);
                compilationUnits.add(parentClass);
                for (EReference aRef : referenceList) {
                    InstanceTDBase tdBase = (InstanceTDBase)EMFNamedElementToTDMap.get(aRef);
                    if (tdBase == null || tdBase instanceof SimpleInstanceTD) continue;
                    EClass aClass = (EClass)aRef.getEType();
                    if (tdBase.getArrayDescr().size() > 1) {
                        EStructuralFeature feature = J2CRecordSkeletonGenerationAdapter.getBaseStructureFeatureForArraySF((EStructuralFeature)aRef, tdBase.getArrayDescr().size());
                        aClass = (EClass)feature.getEType();
                    }
                    monitor.subTask(NLS.bind((String)MessageResource.DISP_PROG_MSG_GENERATING_CLASS, (Object)(String.valueOf(aClass.getEPackage().getName()) + "." + aClass.getName())));
                    ICompilationUnit unit = CreateLanguageJ2CRecordSkeleton.this.createSkeleton(CreateLanguageJ2CRecordSkeleton.this.project_, aClass, aRef, EMFNamedElementToTDMap, ODODependentMap, new ArrayList());
                    monitor.worked(50);
                    compilationUnits.add(unit);
                }
            }
        };
        try {
            op.run((IProgressMonitor)new SubProgressMonitor(progressMonitor, 70));
        }
        catch (InvocationTargetException exc) {
            Throwable t = exc.getTargetException();
            if (t == null) {
                t = exc.getCause();
            }
            if (t == null) {
                throw BaseException.createException((String)exc.getLocalizedMessage(), (Throwable)exc);
            }
            if (t instanceof BaseException) {
                throw (BaseException)t;
            }
            if (t instanceof CoreException) {
                throw new BaseException(((CoreException)t).getStatus());
            }
            throw BaseException.createException((String)t.getLocalizedMessage(), (Throwable)t);
        }
        catch (InterruptedException interruptedException) {}
        ICompilationUnit[] units = compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]);
        return units;
    }

    private void getAllChildEReferences(ArrayList<EReference> referenceList, EClass parentClass) {
        EList references = parentClass.getEReferences();
        for (EReference reference : references) {
            EClassifier cf = reference.getEType();
            if (!(cf instanceof EClass)) continue;
            referenceList.add(reference);
            this.getAllChildEReferences(referenceList, (EClass)cf);
        }
    }

    protected Map<String, String> preProcessODO(EClass rootClass, List<EReference> referenceList, Map<ENamedElement, InstanceTDBase> EMFNamedElementToTDMap) throws BaseException {
        HashMap<String, String> ODODependentMap = new HashMap<String, String>();
        return ODODependentMap;
    }

    protected Object getEmitterInstance() {
        if (this.containerType_ != null && "CHAR".equals(this.containerType_)) {
            return new CICSCharContainerJ2CRecordSkeletonEmitterJET();
        }
        return new LanguageJ2CRecordSkeletonEmitterJET();
    }
}

