/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.j2c;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.codegen.CodeGenUtils;
import com.ibm.etools.typedescriptor.AggregateInstanceTD;
import com.ibm.etools.typedescriptor.ArrayTD;
import com.ibm.etools.typedescriptor.Bi_DirectionStringTD;
import com.ibm.etools.typedescriptor.ExternalDecimalTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.StringTD;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.lang.common.writer.BaseGenerationAdapter;
import com.ibm.lang.common.writer.CodegenUtil;
import com.ibm.lang.common.writer.Level88;
import com.ibm.lang.common.writer.PropertyInfo;
import com.ibm.lang.common.writer.SerialVersionUIDAdder;
import com.ibm.record.writer.LogFacility;
import com.ibm.record.writer.MessageResource;
import com.ibm.record.writer.WriterPlugin;
import com.ibm.record.writer.internal.annotations.TypeDescriptorDeserializer;
import com.ibm.record.writer.internal.annotations.TypeJavaDocVisitor;
import com.ibm.record.writer.internal.j2c.CICSChannelMethodVisitor;
import com.ibm.record.writer.internal.j2c.MPOMethodVisitor;
import com.ibm.record.writer.internal.j2c.MessageBufferVisitor;
import com.ibm.record.writer.internal.j2c.MethodVisitor;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TagProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;

public class J2CRecordImplementationGenerationAdapter
extends BaseGenerationAdapter {
    protected Map<String, PropertyInfo> propertyToDataMap_ = null;
    protected TypeDescriptorDeserializer tdDeSer_ = null;
    protected TypeDeclaration typeDecl_ = null;
    protected MethodDeclaration[] methods_ = null;
    protected List<IResource> modifiedResources_ = new ArrayList<IResource>();
    protected IProgressMonitor monitor_ = null;

    public J2CRecordImplementationGenerationAdapter(ICompilationUnit compilationUnit, TypeDeclaration typeDeclaration, List<TagData> typeTagDataList, Map<String, List<TagData>> propertyToTagDataMap) throws TagProcessingException {
        this.compilationUnit_ = compilationUnit;
        this.typeDecl_ = typeDeclaration;
        this.monitor_ = new NullProgressMonitor();
        this.tdDeSer_ = new TypeDescriptorDeserializer(typeTagDataList);
        if (this.tdDeSer_.getAggregateTD() != null) {
            this.recordBaseOffset_ = this.tdDeSer_.getAggregateTD().getOffset();
        }
        this.methods_ = this.typeDecl_.getMethods();
        this.initPropertyToDataMap(propertyToTagDataMap);
        this.initialize();
        this.propagatePlatformInfoToChildren();
        this.generateTypeDependentCode();
    }

    protected void initialize() {
        AggregateInstanceTD aggregateTD = this.tdDeSer_.getAggregateTD();
        if (aggregateTD != null) {
            EList arrayList = aggregateTD.getArrayDescr();
            if (arrayList != null && !arrayList.isEmpty()) {
                ArrayTD arrayTD = (ArrayTD)arrayList.get(arrayList.size() - 1);
                this.initializeRecordSize_ = arrayTD.getStride();
                this.generatingSubrecord_ = true;
            } else {
                this.initializeRecordSize_ = aggregateTD.getSize();
            }
            this.contentSize_ = this.initializeRecordSize_;
            if (!this.generatingSubrecord_) {
                this.contentSize_ = aggregateTD.getContentSize();
            }
            if (CodeGenUtils.isFormula((String)this.contentSize_)) {
                this.populateValFormulaMaxSizeMap();
            }
            if (!this.tdDeSer_.getCICSContainerClasses().isEmpty()) {
                String[] values = this.tdDeSer_.getCICSContainerClasses().entrySet().iterator().next().getValue();
                if ("CHAR".equals(values[1])) {
                    this.isCICSCharContainer_ = true;
                }
                this.recordName_ = values[0];
            }
        } else {
            boolean isMultiOutput = this.tdDeSer_.isMultiOutput();
            boolean isMessageBuffer = this.tdDeSer_.isMessageBuffer();
            this.isCICSChannel_ = this.tdDeSer_.isCICSChannel();
            if (isMultiOutput || isMessageBuffer || this.isCICSChannel_) {
                return;
            }
            throw new IllegalArgumentException(NLS.bind((String)com.ibm.etools.marshall.codegen.MessageResource.MARSH_CG_AGGRTD_NOT_SET, (Object)this.typeDecl_.getName().getFullyQualifiedName()));
        }
        this.isTrimWhitespace_ = this.tdDeSer_.isTrimWhitespace();
    }

    public void initPropertyToDataMap(Map<String, List<TagData>> propertyToTagDataMap) {
        this.propertyToDataMap_ = new HashMap<String, PropertyInfo>();
        Set<Map.Entry<String, List<TagData>>> entrySet = propertyToTagDataMap.entrySet();
        for (Map.Entry<String, List<TagData>> mapEntry : entrySet) {
            TagData td;
            String propertyName = mapEntry.getKey();
            List<TagData> tagData = mapEntry.getValue();
            PropertyInfo info = new PropertyInfo();
            if (!"initialize".equals(propertyName)) {
                this.propertyToDataMap_.put(propertyName, info);
            }
            if (!tagData.isEmpty() && (td = tagData.get(0)).isMethodTag()) {
                info.methodDecl = ((MethodTagData)td).getMethodDeclaration();
            }
            this.populatePropertyInfo(info, tagData);
        }
    }

    protected void populatePropertyInfo(PropertyInfo info, List<TagData> tagDataList) {
        ArrayList<ArrayTD> arrayTDList = new ArrayList<ArrayTD>();
        ExternalDecimalTD baseTD = null;
        Bi_DirectionStringTD bidiTD = null;
        for (TagData tagData : tagDataList) {
            String tagName = tagData.getName();
            if (tagName.equals("type-descriptor.simple-instance-td")) {
                info.tdBase = this.tdDeSer_.deSerializeSimpleInstanceTD(tagData);
                continue;
            }
            if (tagName.equals("type-descriptor.aggregate-instance-td-method")) {
                info.tdBase = this.tdDeSer_.deSerializeAggregateTD(tagData);
                continue;
            }
            if (tagName.equals("type-descriptor.array-td")) {
                arrayTDList.add(this.tdDeSer_.deSerializeArrayTD(tagData));
                continue;
            }
            if (tagName.equals("type-descriptor.bi-direction-string-td")) {
                bidiTD = this.tdDeSer_.deSerializeBidiTD(tagData);
                continue;
            }
            if (tagName.equals("type-descriptor.string-td")) {
                StringTD stringTD = this.tdDeSer_.deSerializeStringTD(tagData);
                int charSize = MarshallParms.getCharacterSize((StringTD)stringTD);
                if (charSize > 1) {
                    this.charSize_ = charSize;
                }
                baseTD = stringTD;
                continue;
            }
            if (tagName.equals("type-descriptor.external-decimal-td")) {
                baseTD = this.tdDeSer_.deSerializeExternalDecimalTD(tagData);
                continue;
            }
            if (tagName.equals("type-descriptor.unicode-external-decimal-td")) {
                baseTD = this.tdDeSer_.deSerializeUnicodeExternalDecimalTD(tagData);
                continue;
            }
            if (tagName.equals("type-descriptor.packed-decimal-td")) {
                baseTD = this.tdDeSer_.deSerializePackedDecimalTD(tagData);
                continue;
            }
            if (tagName.equals("type-descriptor.integer-td")) {
                baseTD = this.tdDeSer_.deSerializeIntegerTD(tagData);
                continue;
            }
            if (tagName.equals("type-descriptor.float-td")) {
                baseTD = this.tdDeSer_.deSerializeFloatTD(tagData);
                continue;
            }
            if (tagName.equals("type-descriptor.binary-td")) {
                baseTD = this.tdDeSer_.deSerializeBinaryTD(tagData);
                continue;
            }
            if (tagName.equals("type-descriptor.initial-value")) {
                info.initialValueKind = tagData.get("kind");
                info.initialValueVal = tagData.get("value");
                continue;
            }
            if (tagName.equals("type-descriptor.restriction")) {
                info.lowerBound = tagData.get("lowerBound");
                info.upperBound = tagData.get("upperBound");
                info.maxLength = tagData.get("maxLength");
                continue;
            }
            if (tagName.equals("type-descriptor.level88")) {
                String name = tagData.get("name");
                String value = tagData.get("value");
                value = value.replaceAll("&quot;", "\"");
                String winSplitLine = "\r\n";
                String linuxSplitLine = "\n";
                String splitLine = null;
                int index = UTF16.indexOf((String)value, (String)winSplitLine);
                if (index != -1) {
                    splitLine = winSplitLine;
                } else {
                    index = UTF16.indexOf((String)value, (String)linuxSplitLine);
                    if (index != -1) {
                        splitLine = linuxSplitLine;
                    }
                }
                if (index != -1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(value.substring(0, index));
                    sb.append(" ");
                    value = value.substring(index + splitLine.length());
                    int length = UTF16.countCodePoint((String)value);
                    boolean starFound = false;
                    int starCP = UCharacter.getCodePoint((char)'*');
                    int i = 0;
                    int char32 = UTF16.charAt((String)value, (int)i);
                    while (i < length && (UCharacter.isWhitespace((int)char32) || !starFound && char32 == starCP)) {
                        if (char32 == starCP) {
                            starFound = true;
                        }
                        if ((i += UTF16.getCharCount((int)char32)) >= length) continue;
                        char32 = UTF16.charAt((String)value, (int)i);
                    }
                    index = UTF16.indexOf((String)value, (int)char32);
                    value = value.substring(index);
                    sb.append(value);
                    value = sb.toString();
                }
                String dataType = this.getTypeName(info.methodDecl.getReturnType2());
                if (name == null || value == null) continue;
                Level88 level88 = new Level88(dataType, name, value);
                this.level88List_.add(level88);
                continue;
            }
            if (tagName.equals("type-descriptor.depending-on")) {
                info.dependentField = tagData.get("dependentField");
                continue;
            }
            if (tagName.equals("type-descriptor.depending-on-control")) {
                String fieldName = tagData.get("fieldName");
                String maxOccurs = tagData.get("maxOccurances");
                String valFormula = tagData.get("valFormula");
                this.ODODependentMap_.put(fieldName, String.valueOf(maxOccurs) + ":" + valFormula);
                continue;
            }
            if (tagName.equals("type-descriptor.recognition-desc")) {
                info.recognitonPattern = tagData.get("pattern");
                info.recognitonPattern = info.recognitonPattern.replaceAll("&quot;", "\"");
                continue;
            }
            if (tagName.equals("type-descriptor.date-td")) {
                baseTD = this.tdDeSer_.deSerializeDateTD(tagData);
                continue;
            }
            if (!tagName.equals("type-descriptor.address-td")) continue;
            baseTD = this.tdDeSer_.deSerializeAddressTD(tagData);
        }
        if (info.tdBase != null) {
            if (!arrayTDList.isEmpty()) {
                info.tdBase.getArrayDescr().addAll(arrayTDList);
            }
            if (baseTD != null && info.tdBase instanceof SimpleInstanceTD) {
                ((SimpleInstanceTD)info.tdBase).setSharedType(baseTD);
                if (baseTD instanceof StringTD && bidiTD != null) {
                    ((StringTD)baseTD).setBidiAttributes(bidiTD);
                }
            }
        }
    }

    public String getGetSizeMethodBody() {
        if (this.tdDeSer_.isMessageBuffer()) {
            String body = "\tif (buffer_ != null)\n\t\treturn (buffer_.length);\n\telse\n\t\treturn (0);\n";
            return body;
        }
        String initialSize = Integer.toString(this.evaluateFormula(this.contentSize_));
        String sizeStr = "return (" + initialSize + ");\n";
        if (!CodeGenUtils.isFormula((String)this.contentSize_)) {
            return sizeStr;
        }
        StringBuilder sb = new StringBuilder();
        String indent = "\t\t";
        sb.append(indent);
        sb.append("if ((buffer_ == null) || (valFieldNameMap_ == null))\n");
        sb.append(indent);
        sb.append("\t" + sizeStr + "\n\n");
        sb.append(indent);
        sb.append("String formula = \"" + this.contentSize_ + "\";\n");
        sb.append(indent);
        sb.append("int size = evaluateFormula (formula, valFieldNameMap_);\n");
        sb.append(indent);
        sb.append("return (size);\n");
        return sb.toString();
    }

    protected void generateTypeDependentCode() {
        Set<Map.Entry<String, PropertyInfo>> entrySet = this.propertyToDataMap_.entrySet();
        for (Map.Entry<String, PropertyInfo> element : entrySet) {
            Type elementType;
            String propertyName = element.getKey();
            PropertyInfo info = element.getValue();
            Type dataType = info.methodDecl.getReturnType2();
            boolean isPrimitiveType = dataType.isPrimitiveType();
            boolean isArrayType = dataType.isArrayType();
            String dataTypeName = null;
            dataTypeName = isArrayType ? ((isPrimitiveType = (elementType = ((ArrayType)dataType).getElementType()).isPrimitiveType()) ? this.getTypeName((PrimitiveType)elementType) : this.getTypeName((SimpleType)elementType)) : (isPrimitiveType ? this.getTypeName((PrimitiveType)dataType) : this.getTypeName((SimpleType)dataType));
            if (isArrayType && dataTypeName.equals("byte")) {
                dataTypeName = "byte[]";
            }
            this.generateMethodBodies(dataTypeName, isPrimitiveType, info, propertyName);
        }
        this.generateLevel88Code(this.level88List_);
    }

    public String getTypeName(Type type) {
        Type elementType;
        String typeName = null;
        boolean isPrimitiveType = type.isPrimitiveType();
        boolean isArrayType = type.isArrayType();
        typeName = isArrayType ? ((isPrimitiveType = (elementType = ((ArrayType)type).getElementType()).isPrimitiveType()) ? this.getTypeName((PrimitiveType)elementType) : this.getTypeName((SimpleType)elementType)) : (isPrimitiveType ? this.getTypeName((PrimitiveType)type) : this.getTypeName((SimpleType)type));
        return typeName;
    }

    protected String getTypeName(PrimitiveType type) {
        PrimitiveType.Code typeCode = type.getPrimitiveTypeCode();
        String typeName = typeCode.toString();
        return typeName;
    }

    protected String getTypeName(SimpleType type) {
        Name simpleName = type.getName();
        String qualifiedName = simpleName.getFullyQualifiedName();
        String typeName = qualifiedName;
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring(typeName.lastIndexOf(46) + 1);
        }
        return typeName;
    }

    public MethodDeclaration[] getMethods() {
        return this.methods_;
    }

    public String getMethodBody(MethodDeclaration method) {
        String methodName = method.getName().getFullyQualifiedName();
        String body = null;
        if (methodName.equals("initialize")) {
            body = this.getInitializeMethodBody();
        } else if (methodName.equals("getSize")) {
            body = this.getGetSizeMethodBody();
        } else if (methodName.equals("match")) {
            body = this.getMatchMethodBody();
        } else if (methodName.equals("getRecordName")) {
            body = this.getRecordNameMethodBody();
        } else if (methodName.startsWith("get")) {
            if (method.getReturnType2().isArrayType()) {
                methodName = String.valueOf(methodName) + "[]";
            }
            body = (String)this.getterBodyMap_.get(methodName);
        } else if (methodName.startsWith("set")) {
            if (((SingleVariableDeclaration)method.parameters().get(0)).getType().isArrayType()) {
                methodName = String.valueOf(methodName) + "[]";
            }
            body = (String)this.setterBodyMap_.get(methodName);
        } else if (methodName.startsWith("is")) {
            body = (String)this.isBodyMap_.get(methodName);
        }
        return body;
    }

    public String getMethodSignature(MethodDeclaration method) {
        StringBuilder sb = new StringBuilder();
        sb.append("\tpublic ");
        sb.append(this.getTypeName(method.getReturnType2()));
        if (method.getReturnType2().isArrayType()) {
            sb.append("[]");
        }
        sb.append(" ");
        sb.append(method.getName().getFullyQualifiedName());
        sb.append(" (");
        List parameters = method.parameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration varDecl = (SingleVariableDeclaration)iter.next();
            sb.append(this.getTypeName(varDecl.getType()));
            if (varDecl.getType().isArrayType()) {
                sb.append("[]");
            }
            sb.append(" ");
            sb.append(varDecl.getName().getFullyQualifiedName());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public List<IResource> generate() throws TagProcessingException {
        try {
            IType type;
            IField uidField;
            ICompilationUnit workingCopy = this.compilationUnit_.getWorkingCopy(this.monitor_);
            ASTVisitor visitor = null;
            if (this.tdDeSer_.isMessageBuffer()) {
                visitor = new MessageBufferVisitor(this);
                CodegenUtil.modifyJavaSource((ICompilationUnit)workingCopy, (ASTVisitor)visitor);
                this.checkAllMessageBufferMethodsExist(workingCopy);
            }
            visitor = this.tdDeSer_.isMultiOutput() ? new MPOMethodVisitor(this) : (this.tdDeSer_.isCICSChannel() ? new CICSChannelMethodVisitor(this) : new MethodVisitor(this));
            if (!(this.tdDeSer_.isMessageBuffer() || this.tdDeSer_.isMultiOutput() || this.tdDeSer_.isCICSChannel())) {
                this.checkStaticBlockAndVarsExist(workingCopy);
            }
            this.checkBigMathVarsExist(workingCopy);
            CodegenUtil.modifyJavaSource((ICompilationUnit)workingCopy, (ASTVisitor)visitor);
            if (this.tdDeSer_.isMultiOutput()) {
                this.checkAllMPOMethodsExist(workingCopy);
            } else if (this.tdDeSer_.isCICSChannel()) {
                this.checkAllCICSChannelMethodsExist(workingCopy, (CICSChannelMethodVisitor)visitor);
            }
            if (workingCopy.hasUnsavedChanges()) {
                workingCopy.reconcile(0, false, null, this.monitor_);
                workingCopy.commitWorkingCopy(true, this.monitor_);
                workingCopy.save(this.monitor_, true);
            }
            workingCopy.discardWorkingCopy();
            boolean generateUID = false;
            int severity = this.compilationUnit_.getCorrespondingResource().findMaxProblemSeverity("org.eclipse.jdt.core.problem", false, 0);
            if (severity != 2 && !(uidField = (type = this.compilationUnit_.getTypes()[0]).getField("serialVersionUID")).exists()) {
                generateUID = true;
            }
            if (generateUID) {
                Job aJob = new Job(MessageResource.DISP_MSG_DATA_BINDING_NAME){

                    protected IStatus run(IProgressMonitor monitor) {
                        SerialVersionUIDAdder.addSerialVersionToClasses(Collections.singletonList(J2CRecordImplementationGenerationAdapter.this.compilationUnit_), (boolean)true, (IProgressMonitor)monitor);
                        return Status.OK_STATUS;
                    }
                };
                aJob.schedule();
            }
        }
        catch (Exception exc) {
            String message = NLS.bind((String)MessageResource.ERR_MODIFYING_JAVA_SOURCE, (Object)this.compilationUnit_.getResource().getLocation().toOSString());
            Status status = new Status(4, WriterPlugin.getPluginID(), 0, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            TagProcessingException newExc = new TagProcessingException(message);
            newExc.initCause((Throwable)exc);
            throw newExc;
        }
        return this.modifiedResources_;
    }

    protected void checkStaticBlockAndVarsExist(ICompilationUnit workingCopy) {
        try {
            IInitializer[] inits = workingCopy.getTypes()[0].getInitializers();
            if (inits != null && inits.length > 0) {
                return;
            }
            IType type = workingCopy.getTypes()[0];
            IField field = type.getField("bufferSize_");
            field.delete(true, null);
            StringBuilder sb = new StringBuilder();
            sb.append("/**\n * @generated\n */\n");
            sb.append("private static final int bufferSize_;\n");
            type.createField(sb.toString(), null, true, null);
            field = type.getField("initializedBuffer_");
            field.delete(true, null);
            sb = new StringBuilder();
            sb.append("/**\n * @generated\n */\n");
            sb.append("private static final byte[] initializedBuffer_;\n");
            type.createField(sb.toString(), null, true, null);
            sb = new StringBuilder();
            sb.append("/**\n * initializer\n * @generated\n */\n");
            sb.append("static\n");
            sb.append("{\n");
            sb.append("}\n");
            type.createInitializer(sb.toString(), (IJavaElement)type.getMethods()[0], null);
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void checkBigMathVarsExist(ICompilationUnit workingCopy) {
        try {
            IType type = workingCopy.getTypes()[0];
            IField[] fields = type.getFields();
            IField[] iFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField aField = iFieldArray[n2];
                String name = aField.getElementName();
                if (name != null && (name.startsWith("BD_") || name.startsWith("BI_"))) {
                    aField.delete(true, null);
                }
                ++n2;
            }
            Map bigDecimalValueMap = this.getBigDecimalValueMap();
            for (Map.Entry entry : bigDecimalValueMap.entrySet()) {
                String bdValue = (String)entry.getKey();
                String varName = (String)entry.getValue();
                IField field = type.getField(varName);
                if (field.exists()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("/**\n * @generated\n */\n");
                sb.append("public static final BigDecimal ");
                sb.append(varName);
                sb.append(" = new BigDecimal(\"");
                sb.append(bdValue);
                sb.append("\");\n");
                type.createField(sb.toString(), null, true, null);
            }
            Map bigIntegerValueMap = this.getBigIntegerValueMap();
            for (Map.Entry entry : bigIntegerValueMap.entrySet()) {
                String biValue = (String)entry.getKey();
                String varName = (String)entry.getValue();
                IField field = type.getField(varName);
                if (field.exists()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("/**\n * @generated\n */\n");
                sb.append("public static final BigInteger ");
                sb.append(varName);
                sb.append(" = new BigInteger(\"");
                sb.append(biValue);
                sb.append("\");\n");
                type.createField(sb.toString(), null, true, null);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void checkAllMPOMethodsExist(ICompilationUnit cu) throws JavaModelException {
        Map<String, Boolean[]> MPOClassNameMap = this.tdDeSer_.getMultiOutputClasses();
        Set<Map.Entry<String, Boolean[]>> entrySet = MPOClassNameMap.entrySet();
        for (Map.Entry<String, Boolean[]> entry : entrySet) {
            String className = entry.getKey();
            Boolean[] value = entry.getValue();
            if (value[0] == Boolean.FALSE) {
                this.createGetMPOMethodForClass(cu, className);
            }
            if (value[1] != Boolean.FALSE) continue;
            this.createSetMPOMethodForClass(cu, className);
        }
    }

    protected void createGetMPOMethodForClass(ICompilationUnit cu, String qualifiedClassName) throws JavaModelException {
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String upperCaseName = CodegenUtil.getUppercaseName((String)className);
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n */\n");
        sb.append("public ");
        sb.append(qualifiedClassName);
        sb.append(" get");
        sb.append(upperCaseName);
        sb.append("()\n");
        sb.append("{\n");
        sb.append(this.createGetMethodBodyForMPOClass(qualifiedClassName));
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createSetMPOMethodForClass(ICompilationUnit cu, String qualifiedClassName) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String parameterName = CodegenUtil.getParameterName((String)className);
        String upperCaseName = CodegenUtil.getUppercaseName((String)className);
        sb.append("/**\n * @generated\n */\n");
        sb.append("public void set");
        sb.append(upperCaseName);
        sb.append(" (");
        sb.append(qualifiedClassName);
        sb.append(" ");
        sb.append(parameterName);
        sb.append(")\n");
        sb.append("{\n");
        sb.append(this.createSetMethodBodyForMPOClass(qualifiedClassName));
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    public Map<String, Boolean[]> getMultiOutputClasses() {
        return this.tdDeSer_.getMultiOutputClasses();
    }

    public Map<String, String[]> getCICSContainerClasses() {
        return this.tdDeSer_.getCICSContainerClasses();
    }

    public String getCICSChannelName() {
        return this.tdDeSer_.getCICSChannelName();
    }

    public String createGetMethodBodyForMPOClass(String qualifiedClassName) {
        StringBuilder sb = new StringBuilder();
        String indent = "\t";
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String parameterName = CodegenUtil.getParameterName((String)className);
        sb.append(indent);
        sb.append(qualifiedClassName);
        sb.append(" ");
        sb.append(parameterName);
        sb.append(" = new ");
        sb.append(qualifiedClassName);
        sb.append("();\n");
        sb.append(indent);
        sb.append("if (");
        sb.append(parameterName);
        sb.append(".match (buffer_))\n");
        sb.append(indent);
        sb.append("{\n");
        sb.append(indent);
        sb.append("\t");
        sb.append(parameterName);
        sb.append(".populate (buffer_);\n");
        sb.append(indent);
        sb.append("\t");
        sb.append("return (");
        sb.append(parameterName);
        sb.append(");\n");
        sb.append(indent);
        sb.append("}\n");
        sb.append(indent);
        sb.append("else\n");
        sb.append(indent);
        sb.append("\t");
        sb.append("return (null);\n");
        return sb.toString();
    }

    public String createSetMethodBodyForMPOClass(String qualifiedClassName) {
        StringBuilder sb = new StringBuilder();
        String indent = "\t";
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String parameterName = CodegenUtil.getParameterName((String)className);
        sb.append(indent);
        sb.append("if (");
        sb.append(parameterName);
        sb.append(" != null)\n");
        sb.append(indent);
        sb.append("\t");
        sb.append("buffer_ = ");
        sb.append(parameterName);
        sb.append(".getBytes();\n");
        return sb.toString();
    }

    protected void propagatePlatformInfoToChildren() throws TagProcessingException {
        List<String> childClasses = this.tdDeSer_.getChildClasses();
        if (childClasses.isEmpty()) {
            return;
        }
        ArrayList<String> classList = new ArrayList<String>();
        classList.add("");
        String currentClass = "";
        try {
            TagElement parentJDoc = this.findPlatormInfoDoclet();
            if (parentJDoc == null) {
                return;
            }
            Iterator<String> iterator = childClasses.iterator();
            while (iterator.hasNext()) {
                String className;
                currentClass = className = iterator.next();
                classList.add(currentClass);
                IType type = this.compilationUnit_.getJavaProject().findType(className);
                if (type == null) continue;
                currentClass = type.getResource().getLocation().toOSString();
                ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)type.getResource()));
                ICompilationUnit workingCopy = cu.getWorkingCopy(this.monitor_);
                TypeJavaDocVisitor visitor = new TypeJavaDocVisitor(parentJDoc);
                Document doc = new Document(workingCopy.getSource());
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(doc.get().toCharArray());
                CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
                astCU.recordModifications();
                astCU.accept((ASTVisitor)visitor);
                if (!visitor.getJavaDocTagsMatch()) {
                    TextEdit te = astCU.rewrite((IDocument)doc, null);
                    te.apply((IDocument)doc);
                    Map options = cu.getJavaProject().getOptions(true);
                    options.put("org.eclipse.jdt.core.formatter.comment.format_javadoc_comments", "true");
                    options.put("org.eclipse.jdt.core.formatter.comment.format_header", "false");
                    CodeFormatter cf = ToolFactory.createCodeFormatter((Map)options);
                    TextEdit cfte = cf.format(8, doc.get(), 0, doc.get().length(), 0, null);
                    if (cfte != null) {
                        cfte.apply((IDocument)doc);
                    }
                    workingCopy.getBuffer().setContents(doc.get());
                    if (workingCopy.hasUnsavedChanges()) {
                        workingCopy.reconcile(0, false, null, this.monitor_);
                        workingCopy.commitWorkingCopy(true, this.monitor_);
                        workingCopy.save(this.monitor_, true);
                    }
                    this.modifiedResources_.add(type.getResource());
                }
                workingCopy.discardWorkingCopy();
            }
        }
        catch (Exception exc) {
            throw new TagProcessingException(exc.getLocalizedMessage());
        }
    }

    protected TagElement findPlatormInfoDoclet() throws JavaModelException {
        Document doc = new Document(this.compilationUnit_.getSource());
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(doc.get().toCharArray());
        CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
        String javadocTagName = "@type-descriptor.platform-compiler-info";
        TypeJavaDocVisitor visitor = new TypeJavaDocVisitor(javadocTagName);
        astCU.accept((ASTVisitor)visitor);
        return visitor.getDoclet();
    }

    protected void checkAllMessageBufferMethodsExist(ICompilationUnit cu) throws TagProcessingException {
        HashMap<String, Boolean> methodMap = new HashMap<String, Boolean>();
        String[] methodNames = new String[]{this.getClassName(), "read", "write", "getRecordName", "setRecordName", "getRecordShortDescription", "setRecordShortDescription", "clone", "equals", "hashCode", "getBytes", "setBytes", "getSize", "toString"};
        int i = 0;
        while (i < methodNames.length) {
            methodMap.put(methodNames[i], Boolean.FALSE);
            ++i;
        }
        MethodDeclaration[] methods = this.typeDecl_.getMethods();
        int j = 0;
        while (j < methods.length) {
            String methodName = methods[j].getName().getFullyQualifiedName();
            if (methodMap.containsKey(methodName)) {
                methodMap.put(methodName, Boolean.TRUE);
            }
            ++j;
        }
        Set entrySet = methodMap.entrySet();
        try {
            for (Map.Entry entry : entrySet) {
                String methodName = (String)entry.getKey();
                Boolean value = (Boolean)entry.getValue();
                if (value != Boolean.FALSE) continue;
                if (this.getClassName().equals(methodName)) {
                    this.createMBCtor(cu);
                    continue;
                }
                if ("read".equals(methodName)) {
                    this.createMBReadMethod(cu);
                    continue;
                }
                if ("write".equals(methodName)) {
                    this.createMBWriteMethod(cu);
                    continue;
                }
                if ("getRecordName".equals(methodName)) {
                    this.createMBGetRecordNameMethod(cu);
                    continue;
                }
                if ("setRecordName".equals(methodName)) {
                    this.createMBSetRecordNameMethod(cu);
                    continue;
                }
                if ("getRecordShortDescription".equals(methodName)) {
                    this.createMBGetRecordShortDescriptionMethod(cu);
                    continue;
                }
                if ("setRecordShortDescription".equals(methodName)) {
                    this.createMBSetRecordShortDescriptionMethod(cu);
                    continue;
                }
                if ("clone".equals(methodName)) {
                    this.createMBCloneMethod(cu);
                    continue;
                }
                if ("equals".equals(methodName)) {
                    this.createMBEqualsMethod(cu);
                    continue;
                }
                if ("hashCode".equals(methodName)) {
                    this.createMBHashCodeMethod(cu);
                    continue;
                }
                if ("getBytes".equals(methodName)) {
                    this.createMBGetBytesMethod(cu);
                    continue;
                }
                if ("setBytes".equals(methodName)) {
                    this.createMBSetBytesMethod(cu);
                    continue;
                }
                if ("getSize".equals(methodName)) {
                    this.createMBGetSizeMethod(cu);
                    continue;
                }
                if (!"toString".equals(methodName)) continue;
                this.createMBToStringMethod(cu);
            }
        }
        catch (Exception exc) {
            String message = NLS.bind((String)MessageResource.ERR_MODIFYING_JAVA_SOURCE, (Object)this.compilationUnit_.getResource().getLocation().toOSString());
            Status status = new Status(4, WriterPlugin.getPluginID(), 0, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            TagProcessingException newExc = new TagProcessingException(message);
            newExc.initCause((Throwable)exc);
            throw newExc;
        }
    }

    protected void createMBCtor(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n */\n");
        sb.append("public ");
        sb.append(this.getClassName());
        sb.append("()\n");
        sb.append("{\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBReadMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see javax.resource.cci.Streamable#read(InputStream)\n */\n");
        sb.append("public void read (java.io.InputStream inputStream) throws java.io.IOException\n");
        sb.append("{\n");
        sb.append("\tbyte[] input = new byte[inputStream.available()];\n");
        sb.append("\tinputStream.read (input);\n");
        sb.append("\tbuffer_ = input;\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBWriteMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see javax.resource.cci.Streamable#write(OutputStream)\n */\n");
        sb.append("public void write (java.io.OutputStream outputStream) throws java.io.IOException\n");
        sb.append("{\n");
        sb.append("\toutputStream.write (buffer_);\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBGetRecordNameMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see javax.resource.cci.Record#getRecordName()\n */\n");
        sb.append("public String getRecordName()\n");
        sb.append("{\n");
        sb.append("\treturn (this.getClass().getName());\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBSetRecordNameMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see javax.resource.cci.Record#setRecordName(String)\n */\n");
        sb.append("public void setRecordName (String recordName)\n");
        sb.append("{\n");
        sb.append("\treturn;\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBGetRecordShortDescriptionMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see javax.resource.cci.Record#getRecordShortDescription()\n */\n");
        sb.append("public String getRecordShortDescription()\n");
        sb.append("{\n");
        sb.append("\treturn (this.getClass().getName());\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBSetRecordShortDescriptionMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see javax.resource.cci.Record#setRecordShortDescription(String)\n */\n");
        sb.append("public void setRecordShortDescription (String shortDescription)\n");
        sb.append("{\n");
        sb.append("\treturn;\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBCloneMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see javax.resource.cci.Record#clone()\n */\n");
        sb.append("public Object clone() throws CloneNotSupportedException\n");
        sb.append("{\n");
        sb.append("\treturn (super.clone());\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBEqualsMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see javax.resource.cci.Record#equals()\n */\n");
        sb.append("public boolean equals (Object object)\n");
        sb.append("{\n");
        sb.append("\treturn (super.equals (object));\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBHashCodeMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see javax.resource.cci.Record#hashCode()\n */\n");
        sb.append("public int hashCode()\n");
        sb.append("{\n");
        sb.append("\treturn (super.hashCode());\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBGetBytesMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n */\n");
        sb.append("public byte[] getBytes()\n");
        sb.append("{\n");
        sb.append("\treturn (buffer_);\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBSetBytesMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n */\n");
        sb.append("public void setBytes (byte[] bytes)\n");
        sb.append("{\n");
        sb.append("\tif ((bytes != null) && (bytes.length != 0))\n\t\tbuffer_ = bytes;\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBGetSizeMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n */\n");
        sb.append("public int getSize()\n");
        sb.append("{\n");
        sb.append(this.getGetSizeMethodBody());
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createMBToStringMethod(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n * @see java.lang.Object#toString\n */\n");
        sb.append("public String toString()\n");
        sb.append("{\n");
        sb.append("\tStringBuffer sb = new StringBuffer(super.toString());\n");
        sb.append("\tsb.append (\"\\n\");\n");
        sb.append("\tcom.ibm.etools.marshall.util.ConversionUtils.dumpBytes (sb, buffer_);\n");
        sb.append("\treturn (sb.toString());\n");
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    public boolean isECIChannel() {
        try {
            String superclassName = this.compilationUnit_.getTypes()[0].getSuperclassName();
            if ("com.ibm.connector2.cics.ECIChannelRecord".equals(superclassName) || "ECIChannelRecord".equals(superclassName)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public String getSuperCTORParameterForCICSChannelClass() {
        StringBuilder sb = new StringBuilder();
        if (this.isECIChannel()) {
            sb.append("\"");
            sb.append(this.tdDeSer_.getCICSChannelName());
            sb.append("\"");
        }
        return sb.toString();
    }

    public String createCTORBodyForCICSChannelClass() {
        StringBuilder sb = new StringBuilder();
        String indent = "\t";
        sb.append(indent);
        sb.append("super(");
        if (this.isECIChannel()) {
            sb.append(this.getSuperCTORParameterForCICSChannelClass());
        }
        sb.append(");\n");
        for (Map.Entry<String, String[]> mapEntry : this.getCICSContainerClasses().entrySet()) {
            String qualifiedClassName = mapEntry.getKey();
            String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
            String parameterName = CodegenUtil.getParameterName((String)className);
            sb.append(indent);
            sb.append(parameterName);
            sb.append(" = new ");
            sb.append(qualifiedClassName);
            sb.append("();\n");
        }
        return sb.toString();
    }

    public String createGetMethodBodyForCICSChannelClass(String qualifiedClassName) {
        String[] values = this.getCICSContainerClasses().get(qualifiedClassName);
        if (values == null) {
            return "\treturn (null);\n";
        }
        StringBuilder sb = new StringBuilder();
        String indent = "\t";
        String containerName = values[0];
        String containerType = values[1];
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String parameterName = CodegenUtil.getParameterName((String)className);
        String variableName = String.valueOf(parameterName) + "Value";
        String dataType = "byte[]";
        String setMethod = "setBytes";
        boolean isCharType = false;
        if ("CHAR".equals(containerType)) {
            isCharType = true;
            dataType = "String";
            setMethod = "setString";
        }
        if (this.isECIChannel() || !isCharType) {
            sb.append(indent);
            sb.append(dataType);
            sb.append(" ");
            sb.append(variableName);
            sb.append(" = (");
            sb.append(dataType);
            sb.append(")get (\"");
            sb.append(containerName);
            sb.append("\");\n");
            sb.append(indent);
            sb.append("if (");
            sb.append(variableName);
            sb.append(" == null)\n");
            sb.append(indent);
            sb.append("\treturn (null);\n\n");
            sb.append(indent);
            sb.append(parameterName);
            sb.append(".");
            sb.append(setMethod);
            sb.append(" (");
            sb.append(variableName);
            sb.append(");\n");
            sb.append(indent);
            sb.append("return (");
            sb.append(parameterName);
            sb.append(");\n");
        } else {
            sb.append(indent);
            sb.append("byte[] ");
            sb.append(variableName);
            sb.append(" = get (\"");
            sb.append(containerName);
            sb.append("\");\n");
            sb.append(indent);
            sb.append("if (");
            sb.append(variableName);
            sb.append(" == null)\n");
            sb.append(indent);
            sb.append("\treturn (null);\n\n");
            sb.append(indent);
            sb.append("try {\n");
            sb.append(indent);
            sb.append("\t");
            sb.append(parameterName);
            sb.append(".");
            sb.append(setMethod);
            sb.append(" (new String(");
            sb.append(variableName);
            sb.append(", \"1208\")");
            sb.append(");\n");
            sb.append(indent);
            sb.append("\t");
            sb.append("return (");
            sb.append(parameterName);
            sb.append(");\n");
            sb.append(indent);
            sb.append("} catch (java.io.UnsupportedEncodingException exc) {");
            sb.append(indent);
            sb.append("\treturn (null);\n");
            sb.append(indent);
            sb.append("}\n");
        }
        return sb.toString();
    }

    public String createSetMethodBodyForCICSChannelClass(String qualifiedClassName) {
        String[] values = this.getCICSContainerClasses().get(qualifiedClassName);
        if (values == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String indent = "\t";
        String containerName = values[0];
        String containerType = values[1];
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String parameterName = CodegenUtil.getParameterName((String)className);
        String getMethod = ".getBytes()";
        boolean isStringMethod = false;
        if ("CHAR".equals(containerType)) {
            isStringMethod = true;
            getMethod = ".getString()";
        }
        sb.append(indent);
        sb.append("this.");
        sb.append(parameterName);
        sb.append(" = ");
        sb.append(parameterName);
        sb.append(";\n");
        if (isStringMethod) {
            boolean isECIChannel = this.isECIChannel();
            if (!isECIChannel) {
                sb.append(indent);
                sb.append("try {\n");
                sb.append(indent);
            }
            sb.append(indent);
            sb.append("put (\"");
            sb.append(containerName);
            sb.append("\", ");
            sb.append(parameterName);
            sb.append(getMethod);
            if (!isECIChannel) {
                sb.append(".getBytes (\"1208\")");
            }
            sb.append(");\n");
            if (!isECIChannel) {
                sb.append(indent);
                sb.append("} catch (java.io.UnsupportedEncodingException exc) { }\n");
            }
        } else {
            sb.append(indent);
            sb.append("int size = ");
            sb.append(parameterName);
            sb.append(".getSize();\n");
            sb.append(indent);
            sb.append("if (size == ");
            sb.append(parameterName);
            sb.append(".getBytes().length)\n");
            sb.append(indent);
            sb.append("\tput (\"");
            sb.append(containerName);
            sb.append("\", ");
            sb.append(parameterName);
            sb.append(getMethod);
            sb.append(");\n");
            sb.append(indent);
            sb.append("else\n");
            sb.append(indent);
            sb.append("{\n");
            sb.append(indent);
            sb.append("\tbyte[] bytes = new byte[size];\n");
            sb.append(indent);
            sb.append("\tSystem.arraycopy (");
            sb.append(parameterName);
            sb.append(".getBytes(), 0, bytes, 0, size);\n");
            sb.append(indent);
            sb.append("\tput (\"");
            sb.append(containerName);
            sb.append("\", bytes);\n");
            sb.append(indent);
            sb.append("}\n");
        }
        return sb.toString();
    }

    protected void checkAllCICSChannelMethodsExist(ICompilationUnit cu, CICSChannelMethodVisitor visitor) throws JavaModelException {
        ArrayList<String> foundMethods = visitor.getFoundMethods();
        if (!foundMethods.contains("toString")) {
            this.createToStringCICSChannelMethodForClass(cu);
        }
        Map<String, String[]> containerClassNameMap = this.tdDeSer_.getCICSContainerClasses();
        for (String qualifiedClassName : containerClassNameMap.keySet()) {
            IField field;
            String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
            String upperCaseName = CodegenUtil.getUppercaseName((String)className);
            String parameterName = CodegenUtil.getParameterName((String)className);
            String getMethod = "get" + upperCaseName;
            String setMethod = "set" + upperCaseName;
            if (!foundMethods.contains(getMethod)) {
                this.createGetCICSChannelMethodForClass(cu, className);
            }
            if (!foundMethods.contains(setMethod)) {
                this.createSetCICSChannelMethodForClass(cu, className);
            }
            if ((field = cu.getTypes()[0].getField(parameterName)).exists()) continue;
            StringBuilder sb = new StringBuilder("private ");
            sb.append(qualifiedClassName);
            sb.append(" ");
            sb.append(parameterName);
            sb.append(" = null;");
            cu.getTypes()[0].createField(sb.toString(), cu.getTypes()[0].getChildren()[0], false, this.monitor_);
        }
    }

    public void createGetCICSChannelMethodForClass(ICompilationUnit cu, String qualifiedClassName) throws JavaModelException {
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String upperCaseName = CodegenUtil.getUppercaseName((String)className);
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n */\n");
        sb.append("public ");
        sb.append(qualifiedClassName);
        sb.append(" get");
        sb.append(upperCaseName);
        sb.append("()\n");
        sb.append("{\n");
        sb.append(this.createGetMethodBodyForCICSChannelClass(qualifiedClassName));
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    protected void createSetCICSChannelMethodForClass(ICompilationUnit cu, String qualifiedClassName) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String parameterName = CodegenUtil.getParameterName((String)className);
        String upperCaseName = CodegenUtil.getUppercaseName((String)className);
        sb.append("/**\n * @generated\n */\n");
        sb.append("public void set");
        sb.append(upperCaseName);
        sb.append(" (");
        sb.append(qualifiedClassName);
        sb.append(" ");
        sb.append(parameterName);
        sb.append(")\n");
        sb.append("{\n");
        sb.append(this.createSetMethodBodyForCICSChannelClass(qualifiedClassName));
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }

    public String createToStringMethodBodyForCICSChannelClass() {
        StringBuilder sb = new StringBuilder();
        String indent = "\t";
        sb.append(indent);
        sb.append("StringBuilder sb = new StringBuilder (super.toString());\n");
        Map<String, String[]> containerClassNameMap = this.tdDeSer_.getCICSContainerClasses();
        for (String qualifiedClassName : containerClassNameMap.keySet()) {
            String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
            String upperCaseName = CodegenUtil.getUppercaseName((String)className);
            String parameterName = CodegenUtil.getParameterName((String)className);
            String getMethod = "get" + upperCaseName;
            sb.append(indent);
            sb.append(qualifiedClassName);
            sb.append(" ");
            sb.append(parameterName);
            sb.append(" = ");
            sb.append(getMethod);
            sb.append("();\n");
            sb.append(indent);
            sb.append("if (");
            sb.append(parameterName);
            sb.append(" != null)\n");
            sb.append(indent);
            sb.append("{");
            sb.append(indent);
            sb.append(indent);
            sb.append("sb.append (\"\\n\");\n");
            sb.append(indent);
            sb.append(indent);
            sb.append("sb.append (");
            sb.append(parameterName);
            sb.append(".toString());\n");
            sb.append(indent);
            sb.append("}");
        }
        sb.append(indent);
        sb.append("return (sb.toString());\n");
        return sb.toString();
    }

    protected void createToStringCICSChannelMethodForClass(ICompilationUnit cu) throws JavaModelException {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n * @generated\n */\n");
        sb.append("public String toString()\n");
        sb.append("{\n");
        sb.append(this.createToStringMethodBodyForCICSChannelClass());
        sb.append("}\n");
        cu.getTypes()[0].createMethod(sb.toString(), null, true, this.monitor_);
    }
}

