/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.j2c;

import com.ibm.record.writer.internal.j2c.J2CRecordImplementationGenerationAdapter;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;

public class CICSChannelMethodVisitor
extends ASTVisitor {
    protected J2CRecordImplementationGenerationAdapter adapter_ = null;
    protected ArrayList<String> foundMethods_ = new ArrayList();

    public CICSChannelMethodVisitor(J2CRecordImplementationGenerationAdapter adapter) {
        this.adapter_ = adapter;
    }

    public CICSChannelMethodVisitor(boolean visitDocTags, J2CRecordImplementationGenerationAdapter adapter) {
        super(visitDocTags);
        this.adapter_ = adapter;
    }

    public boolean visit(MethodDeclaration methodDecl) {
        String body = null;
        String methodName = methodDecl.getName().getFullyQualifiedName();
        if (methodDecl.isConstructor()) {
            body = this.adapter_.createCTORBodyForCICSChannelClass();
            this.foundMethods_.add(methodName);
        } else if ("toString".equals(methodName)) {
            body = this.adapter_.createToStringMethodBodyForCICSChannelClass();
            this.foundMethods_.add(methodName);
        } else {
            String key = null;
            Type type = null;
            if (methodName.startsWith("get")) {
                type = methodDecl.getReturnType2();
            } else if (methodName.startsWith("set")) {
                SingleVariableDeclaration svd = (SingleVariableDeclaration)methodDecl.parameters().get(0);
                type = svd.getType();
            }
            if (type == null) {
                return false;
            }
            key = this.adapter_.getTypeName(type);
            if (key.indexOf(46) == -1) {
                key = this.adapter_.getPackageName() + "." + key;
            }
            if (key == null || !this.adapter_.getCICSContainerClasses().containsKey(key)) {
                return false;
            }
            this.foundMethods_.add(methodName);
            body = methodName.startsWith("get") ? this.adapter_.createGetMethodBodyForCICSChannelClass(key) : this.adapter_.createSetMethodBodyForCICSChannelClass(key);
        }
        if (body == null) {
            return false;
        }
        char[] source = body.toCharArray();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(2);
        parser.setSource(source);
        ASTNode result = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        if (result.getNodeType() != 8) {
            return false;
        }
        result = ASTNode.copySubtree((AST)methodDecl.getAST(), (ASTNode)result);
        methodDecl.setBody((Block)result);
        return false;
    }

    public ArrayList<String> getFoundMethods() {
        return this.foundMethods_;
    }
}

