/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class TypeJavaDocVisitor
extends ASTVisitor {
    private String javadocTagName_ = null;
    private TagElement javadoc_ = null;
    private boolean javaDocTagsMatch_ = true;
    private Javadoc typeJavaDoc_ = null;

    public TypeJavaDocVisitor(String javadocTagName) {
        super(true);
        this.javadocTagName_ = javadocTagName;
    }

    public TypeJavaDocVisitor(TagElement javadoc) {
        super(true);
        this.javadoc_ = javadoc;
        this.javadocTagName_ = "@type-descriptor.platform-compiler-info";
    }

    public boolean visit(TypeDeclaration typeDecl) {
        this.typeJavaDoc_ = typeDecl.getJavadoc();
        List tags = this.typeJavaDoc_.tags();
        for (TagElement te : tags) {
            String tagName = te.getTagName();
            if (!tagName.equals(this.javadocTagName_)) continue;
            if (this.javadoc_ == null) {
                this.javadoc_ = te;
                return false;
            }
            if (!this.javaDocsMatch(te, this.javadoc_)) {
                for (Object element : this.javadoc_.fragments()) {
                    if (!(element instanceof TextElement)) continue;
                    TextElement aTe = (TextElement)element;
                    String text = aTe.getText();
                    if (text.startsWith(" ")) {
                        text = text.substring(1);
                    }
                    aTe.setText(text);
                }
                ASTNode result = ASTNode.copySubtree((AST)typeDecl.getAST(), (ASTNode)this.javadoc_);
                int index = tags.indexOf(te);
                tags.set(index, result);
                this.javaDocTagsMatch_ = false;
            }
            return false;
        }
        return false;
    }

    private boolean javaDocsMatch(TagElement jd1, TagElement jd2) {
        String jd2TagName;
        if (jd1 == jd2) {
            return true;
        }
        if (jd1 == null ^ jd2 == null) {
            return false;
        }
        String jd1TagName = jd1.getTagName();
        if (!jd1TagName.equals(jd2TagName = jd1.getTagName())) {
            return false;
        }
        List jd1Frags = jd1.fragments();
        List jd2Frags = jd2.fragments();
        StringBuilder jd1Buf = new StringBuilder();
        for (TextElement element : jd1Frags) {
            String text = element.getText();
            text = text.trim();
            jd1Buf.append(" ");
            jd1Buf.append(text);
        }
        String jd1String = jd1Buf.toString().trim();
        StringBuilder jd2Buf = new StringBuilder();
        for (TextElement element : jd2Frags) {
            String text = element.getText();
            text = text.trim();
            jd2Buf.append(" ");
            jd2Buf.append(text);
        }
        String jd2String = jd2Buf.toString().trim();
        StringTokenizer st1 = new StringTokenizer(jd1String);
        StringTokenizer st2 = new StringTokenizer(jd2String);
        ArrayList<String> tokenList1 = new ArrayList<String>();
        ArrayList<String> tokenList2 = new ArrayList<String>();
        while (st1.hasMoreTokens()) {
            tokenList1.add(st1.nextToken());
        }
        while (st2.hasMoreTokens()) {
            tokenList2.add(st2.nextToken());
        }
        if (tokenList1.size() != tokenList2.size()) {
            return false;
        }
        Collections.sort(tokenList1, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(tokenList2, String.CASE_INSENSITIVE_ORDER);
        int i = 0;
        while (i < tokenList1.size()) {
            String t2;
            String t1 = (String)tokenList1.get(i);
            if (!t1.equals(t2 = (String)tokenList2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TagElement getDoclet() {
        return this.javadoc_;
    }

    public boolean getJavaDocTagsMatch() {
        return this.javaDocTagsMatch_;
    }

    public Javadoc getTypeJavaDoc() {
        return this.typeJavaDoc_;
    }
}

