/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.etools.typedescriptor.AccessorValue;
import com.ibm.etools.typedescriptor.ExternalDecimalSignValue;
import com.ibm.etools.typedescriptor.FloatValue;
import com.ibm.etools.typedescriptor.NumeralShapes;
import com.ibm.etools.typedescriptor.Orientation;
import com.ibm.etools.typedescriptor.TextShapes;
import com.ibm.etools.typedescriptor.TypeOfText;
import com.ibm.record.writer.internal.annotations.ValidationUtils;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import java.util.Map;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class TypeDescriptorTypeTagData
extends TypeTagData {
    private boolean beenValidatedOnce_ = false;

    public TypeDescriptorTypeTagData(String name, Map data, TypeDeclaration td) {
        super(name, data, td);
    }

    public TypeDescriptorTypeTagData(TagData td) {
        super(td);
    }

    public boolean beenValidatedOnce() {
        return this.beenValidatedOnce_;
    }

    protected void setValidated() {
        this.beenValidatedOnce_ = true;
    }

    public boolean isValid() {
        boolean isValid = true;
        this.beenValidatedOnce_ = true;
        String tagName = this.getName();
        if (tagName.equals("type-descriptor.aggregate-instance-td")) {
            isValid = this.validateAggregateTD();
        } else if (tagName.equals("type-descriptor.platform-compiler-info")) {
            isValid = this.validatePlatformInfo();
        } else if (tagName.equals("type-descriptor.array-td-type")) {
            isValid = ValidationUtils.validateArrayTD((TagData)this);
        } else if (tagName.equals("type-descriptor.type-bi-direction-string-td")) {
            isValid = this.validateBidiTD();
        }
        return isValid;
    }

    private boolean validatePlatformInfo() {
        String hostCodePage;
        FloatValue fv;
        String floatType;
        ExternalDecimalSignValue extDec;
        String extDecSign;
        String codePage;
        String bigEndian;
        boolean isValid = true;
        String language = this.get("language");
        if (language != null && !this.validEnum(language, "language", ValidationUtils.getLanguageChoice())) {
            isValid = false;
        }
        if ((bigEndian = this.get("defaultBigEndian")) != null && !this.validEnum(bigEndian, "defaultBigEndian", ValidationUtils.getTrueFalseChoice())) {
            isValid = false;
        }
        if ((codePage = this.get("defaultCodepage")) != null) {
            boolean bl = isValid = isValid && ValidationUtils.validateCodepage(codePage, (TagData)this, "defaultCodepage");
        }
        if ((extDecSign = this.get("defaultExternalDecimalSign")) != null && (extDec = ExternalDecimalSignValue.get((String)extDecSign)) == null) {
            this.validEnum(extDecSign, "defaultExternalDecimalSign", ValidationUtils.getExtDecSignChoice());
            isValid = false;
        }
        if ((floatType = this.get("defaultFloatType")) != null && (fv = FloatValue.get((String)floatType)) == null) {
            this.validEnum(floatType, "defaultFloatType", ValidationUtils.getFloatValueChoice());
            isValid = false;
        }
        if ((hostCodePage = this.get("defaultHostCodepage")) != null) {
            isValid = isValid && ValidationUtils.validateCodepage(hostCodePage, (TagData)this, "defaultHostCodepage");
        }
        return isValid;
    }

    private boolean validateAggregateTD() {
        AccessorValue av;
        boolean isValid = true;
        String accessor = this.get("accessor");
        if (accessor != null && (av = AccessorValue.get((String)accessor)) == null) {
            this.validEnum(accessor, "accessor", ValidationUtils.getAccessorValueChoice());
            isValid = false;
        }
        return isValid;
    }

    private boolean validateBidiTD() {
        TypeOfText tt;
        String typeOfText;
        TextShapes ts;
        String textShapes;
        String symmetric;
        Orientation orient;
        String orientation;
        NumeralShapes ns;
        boolean isValid = true;
        String numeralShapes = this.get("numeralShapes");
        if (numeralShapes != null && (ns = NumeralShapes.get((String)numeralShapes)) == null) {
            this.validEnum(numeralShapes, "numeralShapes", ValidationUtils.getNumeralShapesChoice());
            isValid = false;
        }
        if ((orientation = this.get("orientation")) != null && (orient = Orientation.get((String)orientation)) == null) {
            this.validEnum(orientation, "orientation", ValidationUtils.getOrientationChoice());
            isValid = false;
        }
        if ((symmetric = this.get("symmetric")) != null && !this.validEnum(symmetric, "symmetric", ValidationUtils.getTrueFalseChoice())) {
            isValid = false;
        }
        if ((textShapes = this.get("textShape")) != null && (ts = TextShapes.get((String)textShapes)) == null) {
            this.validEnum(textShapes, "textShape", ValidationUtils.getTextShapesChoice());
            isValid = false;
        }
        if ((typeOfText = this.get("orderingScheme")) != null && (tt = TypeOfText.get((String)typeOfText)) == null) {
            this.validEnum(typeOfText, "orderingScheme", ValidationUtils.getTypeOfTextChoice());
            isValid = false;
        }
        return isValid;
    }
}

