/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.etools.typedescriptor.AccessorValue;
import com.ibm.etools.typedescriptor.AddressTD;
import com.ibm.etools.typedescriptor.AggregateInstanceTD;
import com.ibm.etools.typedescriptor.ArrayTD;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.Bi_DirectionStringTD;
import com.ibm.etools.typedescriptor.BinaryTD;
import com.ibm.etools.typedescriptor.DateTD;
import com.ibm.etools.typedescriptor.ExternalDecimalSignValue;
import com.ibm.etools.typedescriptor.ExternalDecimalTD;
import com.ibm.etools.typedescriptor.FloatTD;
import com.ibm.etools.typedescriptor.FloatValue;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.IntegerTD;
import com.ibm.etools.typedescriptor.LengthEncodingValue;
import com.ibm.etools.typedescriptor.NumberTD;
import com.ibm.etools.typedescriptor.NumeralShapes;
import com.ibm.etools.typedescriptor.Orientation;
import com.ibm.etools.typedescriptor.PackedDecimalTD;
import com.ibm.etools.typedescriptor.PlatformCompilerInfo;
import com.ibm.etools.typedescriptor.SignCodingValue;
import com.ibm.etools.typedescriptor.SignFormatValue;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.StringJustificationKind;
import com.ibm.etools.typedescriptor.StringTD;
import com.ibm.etools.typedescriptor.TextShapes;
import com.ibm.etools.typedescriptor.TypeDescriptorFactory;
import com.ibm.etools.typedescriptor.TypeOfText;
import com.ibm.etools.typedescriptor.UnicodeExternalDecimalTD;
import com.ibm.etools.typedescriptor.UnicodeTransformationFormat;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeDescriptorDeserializer {
    private PlatformCompilerInfo platformInfo_ = null;
    private AggregateInstanceTD aggregateTD_ = null;
    private Map<String, Boolean[]> multiOutputClasses_ = new HashMap<String, Boolean[]>();
    private boolean isMessageBuffer_ = false;
    private boolean isMultiOutput_ = false;
    private boolean isCICSChannel_ = false;
    private String CICSChannelName_ = null;
    private boolean isTrimWhitespace_ = false;
    private Map<String, String[]> CICSContainerClasses_ = new HashMap<String, String[]>();
    private List<String> childClasses_ = new ArrayList<String>();

    private TypeDescriptorDeserializer() {
    }

    public TypeDescriptorDeserializer(List<TagData> typeTagDataList) {
        this();
        this.init(typeTagDataList);
    }

    public void init(List<TagData> typeTagDataList) {
        Bi_DirectionStringTD bidiTD = null;
        ArrayList<ArrayTD> arrayTDList = new ArrayList<ArrayTD>();
        for (TagData typeData : typeTagDataList) {
            String tagName = typeData.getName();
            if (tagName.equals("type-descriptor.aggregate-instance-td")) {
                this.aggregateTD_ = this.deSerializeAggregateTD(typeData);
                continue;
            }
            if (tagName.equals("type-descriptor.platform-compiler-info")) {
                this.platformInfo_ = this.deSerializePlatformInfo(typeData);
                continue;
            }
            if (tagName.equals("type-descriptor.array-td-type")) {
                arrayTDList.add(this.deSerializeArrayTD(typeData));
                continue;
            }
            if (tagName.equals("type-descriptor.type-bi-direction-string-td")) {
                bidiTD = this.deSerializeBidiTD(typeData);
                continue;
            }
            if (tagName.equals("type-descriptor.message-buffer")) {
                this.isMessageBuffer_ = true;
                continue;
            }
            if (tagName.equals("type-descriptor.multiple-output")) {
                this.isMultiOutput_ = true;
                this.deSerializeMultiOutput(typeData);
                continue;
            }
            if (tagName.equals("type-descriptor.child-class")) {
                this.deSerializeChildClass(typeData);
                continue;
            }
            if (tagName.equals("type-descriptor.CICSChannel")) {
                this.isCICSChannel_ = true;
                this.deSerializeCICSChannel(typeData);
                continue;
            }
            if (tagName.equals("type-descriptor.CICSContainer")) {
                this.deSerializeCICSContainer(typeData);
                continue;
            }
            if (!tagName.equals("type-descriptor.trim-whitespace")) continue;
            this.isTrimWhitespace_ = true;
        }
        if (this.platformInfo_ != null && bidiTD != null) {
            this.platformInfo_.setBidiAttributes(bidiTD);
        }
        if (this.aggregateTD_ != null) {
            if (this.platformInfo_ != null) {
                this.aggregateTD_.setPlatformInfo(this.platformInfo_);
            }
            if (!arrayTDList.isEmpty()) {
                this.aggregateTD_.getArrayDescr().addAll(arrayTDList);
            }
        }
    }

    public boolean isMessageBuffer() {
        return this.isMessageBuffer_;
    }

    public boolean isTrimWhitespace() {
        return this.isTrimWhitespace_;
    }

    public boolean isMultiOutput() {
        return this.isMultiOutput_;
    }

    public AggregateInstanceTD getAggregateTD() {
        return this.aggregateTD_;
    }

    public void deSerializeMultiOutput(TagData tagData) {
        String className = tagData.get("class-name");
        if (className != null) {
            this.multiOutputClasses_.put(className, new Boolean[]{Boolean.FALSE, Boolean.FALSE});
        }
    }

    public void deSerializeChildClass(TagData tagData) {
        String className = tagData.get("class-name");
        if (className != null) {
            this.childClasses_.add(className);
        }
    }

    public Bi_DirectionStringTD deSerializeBidiTD(TagData tagData) {
        TypeOfText tt;
        String textType;
        TextShapes ts;
        Orientation orient;
        String orientation;
        NumeralShapes ns;
        Bi_DirectionStringTD bidiTD = TypeDescriptorFactory.eINSTANCE.createBi_DirectionStringTD();
        String numeralShpaes = tagData.get("numeralShapes");
        if (numeralShpaes != null && (ns = NumeralShapes.get((String)numeralShpaes)) != null) {
            bidiTD.setNumeralShapes(ns);
        }
        if ((orientation = tagData.get("orientation")) != null && (orient = Orientation.get((String)orientation)) != null) {
            bidiTD.setOrientation(orient);
        }
        boolean symmetric = tagData.getBool("symmetric", true);
        bidiTD.setSymmetric(new Boolean(symmetric));
        String textShape = tagData.get("textShape");
        if (textShape != null && (ts = TextShapes.get((String)textShape)) != null) {
            bidiTD.setTextShape(ts);
        }
        if ((textType = tagData.get("orderingScheme")) != null && (tt = TypeOfText.get((String)textType)) != null) {
            bidiTD.setTextType(tt);
        }
        return bidiTD;
    }

    public PlatformCompilerInfo deSerializePlatformInfo(TagData tagData) {
        String hostCodepage;
        FloatValue fv;
        String floatType;
        ExternalDecimalSignValue extDec;
        String extDecSign;
        String codePage;
        String bigEndianStr;
        this.platformInfo_ = TypeDescriptorFactory.eINSTANCE.createPlatformCompilerInfo();
        String language = tagData.get("language");
        if (language != null) {
            this.platformInfo_.setLanguage(language);
        }
        if ((bigEndianStr = tagData.get("defaultBigEndian")) != null) {
            boolean bigEndian = tagData.getBool("defaultBigEndian", false);
            this.platformInfo_.setDefaultBigEndian(new Boolean(bigEndian));
        }
        if ((codePage = tagData.get("defaultCodepage")) != null) {
            this.platformInfo_.setDefaultCodepage(codePage);
        }
        if ((extDecSign = tagData.get("defaultExternalDecimalSign")) != null && (extDec = ExternalDecimalSignValue.get((String)extDecSign)) != null) {
            this.platformInfo_.setDefaultExternalDecimalSign(extDec);
        }
        if ((floatType = tagData.get("defaultFloatType")) != null && (fv = FloatValue.get((String)floatType)) != null) {
            this.platformInfo_.setDefaultFloatType(fv);
        }
        if ((hostCodepage = tagData.get("defaultHostCodepage")) != null) {
            this.platformInfo_.setDefaultHostCodepage(hostCodepage);
        }
        return this.platformInfo_;
    }

    public void deSerializeInstanceTDBase(TagData tagData, InstanceTDBase tdBase) {
        String size;
        String offset;
        String contentSize;
        AccessorValue av;
        String accessor = tagData.get("accessor");
        if (accessor != null && (av = AccessorValue.get((String)accessor)) != null) {
            tdBase.setAccessor(av);
        }
        if ((contentSize = tagData.get("contentSize")) != null) {
            tdBase.setContentSize(contentSize);
        }
        if ((offset = tagData.get("offset")) != null) {
            tdBase.setOffset(offset);
        }
        if ((size = tagData.get("size")) != null) {
            tdBase.setSize(size);
        }
    }

    public AggregateInstanceTD deSerializeAggregateTD(TagData tagData) {
        AggregateInstanceTD aggregateTD = TypeDescriptorFactory.eINSTANCE.createAggregateInstanceTD();
        this.deSerializeInstanceTDBase(tagData, (InstanceTDBase)aggregateTD);
        if (this.platformInfo_ != null) {
            aggregateTD.setPlatformInfo(this.platformInfo_);
        }
        return aggregateTD;
    }

    public SimpleInstanceTD deSerializeSimpleInstanceTD(TagData tagData) {
        SimpleInstanceTD simpleTD = TypeDescriptorFactory.eINSTANCE.createSimpleInstanceTD();
        this.deSerializeInstanceTDBase(tagData, (InstanceTDBase)simpleTD);
        String format = tagData.get("format");
        if (format != null) {
            simpleTD.setFormat(format);
        }
        simpleTD.setPlatformInfo(this.platformInfo_);
        return simpleTD;
    }

    public ArrayTD deSerializeArrayTD(TagData tagData) {
        String upperBound;
        String stride;
        ArrayTD arrayTD = TypeDescriptorFactory.eINSTANCE.createArrayTD();
        String lowerBound = tagData.get("lowerBound");
        if (lowerBound != null) {
            arrayTD.setLowerBound(lowerBound);
        }
        if ((stride = tagData.get("stride")) != null) {
            arrayTD.setStride(stride);
        }
        if ((upperBound = tagData.get("upperBound")) != null) {
            arrayTD.setUpperBound(upperBound);
        }
        return arrayTD;
    }

    public void deSerializeBaseTDType(TagData tagData, BaseTDType baseTD) {
        String bigEndianStr = tagData.get("bigEndian");
        if (bigEndianStr != null) {
            boolean bigEndian = tagData.getBool("bigEndian", false);
            baseTD.setBigEndian(new Boolean(bigEndian));
        }
    }

    public StringTD deSerializeStringTD(TagData tagData) {
        boolean dbcsOnly;
        StringJustificationKind sjk;
        String stringJustification;
        String prefixLength;
        String paddingCharacter;
        LengthEncodingValue lev;
        String lengthEncoding;
        String codepage;
        StringTD stringTD = TypeDescriptorFactory.eINSTANCE.createStringTD();
        this.deSerializeBaseTDType(tagData, (BaseTDType)stringTD);
        String characterSize = tagData.get("characterSize");
        if (characterSize != null) {
            stringTD.setCharacterSize(Integer.parseInt(characterSize));
        }
        if ((codepage = tagData.get("codepage")) != null) {
            stringTD.setCodepage(codepage);
        }
        if ((lengthEncoding = tagData.get("lengthEncoding")) != null && (lev = LengthEncodingValue.get((String)lengthEncoding)) != null) {
            stringTD.setLengthEncoding(lev);
        }
        if ((paddingCharacter = tagData.get("paddingCharacter")) != null) {
            if (paddingCharacter.equals("")) {
                paddingCharacter = " ";
            }
            stringTD.setPaddingCharacter(paddingCharacter);
        }
        if ((prefixLength = tagData.get("prefixLength")) != null) {
            stringTD.setPrefixLength(Integer.parseInt(prefixLength));
        }
        if ((stringJustification = tagData.get("stringJustification")) != null && (sjk = StringJustificationKind.get((String)stringJustification)) != null) {
            stringTD.setStringJustification(sjk);
        }
        if (dbcsOnly = tagData.getBool("dBCSOnly", false)) {
            stringTD.setDBCSOnly(new Boolean(dbcsOnly));
        }
        return stringTD;
    }

    public AddressTD deSerializeAddressTD(TagData tagData) {
        AddressTD addrTD = TypeDescriptorFactory.eINSTANCE.createAddressTD();
        this.deSerializeBaseTDType(tagData, (BaseTDType)addrTD);
        return addrTD;
    }

    public DateTD deSerializeDateTD(TagData tagData) {
        DateTD dateTD = TypeDescriptorFactory.eINSTANCE.createDateTD();
        this.deSerializeBaseTDType(tagData, (BaseTDType)dateTD);
        return dateTD;
    }

    public FloatTD deSerializeFloatTD(TagData tagData) {
        FloatValue fv;
        FloatTD floatTD = TypeDescriptorFactory.eINSTANCE.createFloatTD();
        this.deSerializeBaseTDType(tagData, (BaseTDType)floatTD);
        String floatType = tagData.get("floatType");
        if (floatType != null && (fv = FloatValue.get((String)floatType)) != null) {
            floatTD.setFloatType(fv);
        }
        return floatTD;
    }

    public BinaryTD deSerializeBinaryTD(TagData tagData) {
        BinaryTD binaryTD = TypeDescriptorFactory.eINSTANCE.createBinaryTD();
        return binaryTD;
    }

    public void deSerializeNumberTD(TagData tagData, NumberTD numberTD) {
        this.deSerializeBaseTDType(tagData, (BaseTDType)numberTD);
        boolean signed = tagData.getBool("signed", true);
        numberTD.setSigned(new Boolean(signed));
        String virtualDecimalPoint = tagData.get("virtualDecimalPoint");
        if (virtualDecimalPoint != null) {
            numberTD.setVirtualDecimalPoint(Integer.parseInt(virtualDecimalPoint));
        }
    }

    public IntegerTD deSerializeIntegerTD(TagData tagData) {
        SignCodingValue scv;
        IntegerTD integerTD = TypeDescriptorFactory.eINSTANCE.createIntegerTD();
        this.deSerializeNumberTD(tagData, (NumberTD)integerTD);
        String signCoding = tagData.get("signCoding");
        if (signCoding != null && (scv = SignCodingValue.get((String)signCoding)) != null) {
            integerTD.setSignCoding(scv);
        }
        return integerTD;
    }

    public PackedDecimalTD deSerializePackedDecimalTD(TagData tagData) {
        PackedDecimalTD packedTD = TypeDescriptorFactory.eINSTANCE.createPackedDecimalTD();
        this.deSerializeNumberTD(tagData, (NumberTD)packedTD);
        return packedTD;
    }

    public ExternalDecimalTD deSerializeExternalDecimalTD(TagData tagData) {
        String hostCodepage;
        SignFormatValue sfv;
        String signFormat;
        ExternalDecimalSignValue edsv;
        ExternalDecimalTD extDecTD = TypeDescriptorFactory.eINSTANCE.createExternalDecimalTD();
        this.deSerializeNumberTD(tagData, (NumberTD)extDecTD);
        String externalDecimalSign = tagData.get("externalDecimalSign");
        if (externalDecimalSign != null && (edsv = ExternalDecimalSignValue.get((String)externalDecimalSign)) != null) {
            extDecTD.setExternalDecimalSign(edsv);
        }
        if ((signFormat = tagData.get("signFormat")) != null && (sfv = SignFormatValue.get((String)signFormat)) != null) {
            extDecTD.setSignFormat(sfv);
        }
        if ((hostCodepage = tagData.get("hostCodepage")) != null) {
            extDecTD.setHostCodepage(hostCodepage);
        }
        return extDecTD;
    }

    public UnicodeExternalDecimalTD deSerializeUnicodeExternalDecimalTD(TagData tagData) {
        UnicodeTransformationFormat utf;
        String encoding;
        SignFormatValue sfv;
        UnicodeExternalDecimalTD extDecTD = TypeDescriptorFactory.eINSTANCE.createUnicodeExternalDecimalTD();
        this.deSerializeNumberTD(tagData, (NumberTD)extDecTD);
        String signFormat = tagData.get("signFormat");
        if (signFormat != null && (sfv = SignFormatValue.get((String)signFormat)) != null) {
            extDecTD.setSignFormat(sfv);
        }
        if ((encoding = tagData.get("encoding")) != null && (utf = UnicodeTransformationFormat.get((String)encoding)) != null) {
            extDecTD.setEncoding(utf);
        }
        return extDecTD;
    }

    public Map<String, Boolean[]> getMultiOutputClasses() {
        return this.multiOutputClasses_;
    }

    public List<String> getChildClasses() {
        return this.childClasses_;
    }

    public void deSerializeCICSChannel(TagData tagData) {
        String channelName = tagData.get("channel-name");
        if (channelName != null) {
            this.CICSChannelName_ = channelName;
        }
    }

    public boolean isCICSChannel() {
        return this.isCICSChannel_;
    }

    public String getCICSChannelName() {
        return this.CICSChannelName_;
    }

    public Map<String, String[]> getCICSContainerClasses() {
        return this.CICSContainerClasses_;
    }

    public void deSerializeCICSContainer(TagData tagData) {
        String className = tagData.get("class-name");
        String containerName = tagData.get("container-name");
        String containerType = tagData.get("container-type");
        if (className != null && containerName != null && containerType != null) {
            this.CICSContainerClasses_.put(className, new String[]{containerName, containerType});
        }
    }
}

